/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class SemanticVersioningTestClassGroup
extends BatchTestClassGroup {
    private static final Pattern _quarterlyReleaseNamePattern = Pattern.compile("(release-\\d{4}.[qQ](.\\d)?)");

    protected SemanticVersioningTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
    }

    protected SemanticVersioningTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        if (this.ignore()) {
            return;
        }
        File buildTestBatchFile = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "build-test-batch.xml");
        this.addTestClass(TestClassFactory.newTestClass((BatchTestClassGroup)this, buildTestBatchFile));
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    @Override
    protected boolean ignore() {
        if (!this.isStableTestSuiteBatch() && this.testRelevantJUnitTestsOnly) {
            return true;
        }
        return this.isStableTestSuiteBatch() && this.testRelevantJUnitTestsOnlyInStable || this.isQuarterlyReleaseBranch();
    }

    protected boolean isQuarterlyReleaseBranch() {
        Matcher quarterlyReleaseNameMatcher = _quarterlyReleaseNamePattern.matcher(this.portalGitWorkingDirectory.getUpstreamBranchName());
        return quarterlyReleaseNameMatcher.find();
    }
}

