/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public class TCKJunitBatchTestClassGroup
extends BatchTestClassGroup {
    private final File _tckHomeDir;

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("exclude_globs", this.getGlobs(this._getExcludesJobProperties()));
        this.jsonObject.put("include_globs", this.getGlobs(this._getIncludesJobProperties()));
        this.jsonObject.put("tck_home_dir", (Object)this._tckHomeDir);
        return this.jsonObject;
    }

    protected TCKJunitBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
        this._tckHomeDir = new File(jsonObject.getString("tck_home_dir"));
    }

    protected TCKJunitBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        if (this.ignore()) {
            this._tckHomeDir = null;
            return;
        }
        this._tckHomeDir = this._getTCKHomeDir();
        this.setTestClasses();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    protected void setTestClasses() {
        final List<PathMatcher> includesPathMatchers = this.getPathMatchers(this._getIncludesJobProperties());
        final List<PathMatcher> excludesPathMatchers = this.getPathMatchers(this._getExcludesJobProperties());
        final ArrayList tckTestFiles = new ArrayList();
        try {
            Files.walkFileTree(this._tckHomeDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (JenkinsResultsParserUtil.isFileExcluded((List<PathMatcher>)excludesPathMatchers, filePath.toFile())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (JenkinsResultsParserUtil.isFileIncluded((List<PathMatcher>)excludesPathMatchers, (List<PathMatcher>)includesPathMatchers, filePath)) {
                        tckTestFiles.add(filePath.toFile());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to search for test file names in " + this._tckHomeDir.getPath(), ioException);
        }
        for (File tckTestFile : tckTestFiles) {
            this.testClasses.add(TestClassFactory.newTestClass((BatchTestClassGroup)this, tckTestFile));
        }
        if (this.testClasses.isEmpty()) {
            File buildTestBatchFile = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "build-test-batch.xml");
            this.testClasses.add(TestClassFactory.newTestClass((BatchTestClassGroup)this, buildTestBatchFile));
        }
        Collections.sort(this.testClasses);
    }

    private List<JobProperty> _getExcludesJobProperties() {
        ArrayList<JobProperty> excludesJobProperties = new ArrayList<JobProperty>();
        excludesJobProperties.add(this.getJobProperty("test.batch.class.names.excludes", this._tckHomeDir, JobProperty.Type.EXCLUDE_GLOB));
        if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
            excludesJobProperties.add(this.getJobProperty("test.batch.class.names.excludes", "stable", this._tckHomeDir, JobProperty.Type.EXCLUDE_GLOB));
        }
        this.recordJobProperties(excludesJobProperties);
        return excludesJobProperties;
    }

    private List<JobProperty> _getIncludesJobProperties() {
        ArrayList<JobProperty> includesJobProperties = new ArrayList<JobProperty>();
        includesJobProperties.add(this.getJobProperty("test.batch.class.names.includes", this._tckHomeDir, JobProperty.Type.INCLUDE_GLOB));
        if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
            includesJobProperties.add(this.getJobProperty("test.batch.class.names.includes", "stable", this._tckHomeDir, JobProperty.Type.INCLUDE_GLOB));
        }
        this.recordJobProperties(includesJobProperties);
        return includesJobProperties;
    }

    private File _getTCKHomeDir() {
        File jenkinsDir;
        JobProperty jobProperty = this.getJobProperty("tck.home");
        String tckHome = jobProperty.getValue();
        if (JenkinsResultsParserUtil.isNullOrEmpty(tckHome) && (jenkinsDir = new File("/opt/dev/projects/github/liferay-jenkins-ee")).exists()) {
            tckHome = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getProperties(new File(jenkinsDir, "commands/dependencies/test.properties")), "tck.home");
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(tckHome)) {
            try {
                tckHome = JenkinsResultsParserUtil.getBuildProperty("portal.test.properties[tck.home]");
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(tckHome)) {
            throw new RuntimeException("Unable find the TCK home");
        }
        return new File(tckHome);
    }
}

