/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.suite;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.job.property.JobPropertyFactory;
import com.liferay.jenkins.results.parser.test.batch.TestBatch;
import com.liferay.jenkins.results.parser.test.batch.TestBatchFactory;
import com.liferay.jenkins.results.parser.test.suite.RelevantRuleConfigurationException;
import com.liferay.jenkins.results.parser.test.suite.RelevantRuleEngine;
import java.io.File;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class RelevantRule
implements Comparable<RelevantRule> {
    private final String _filePath;
    private final Job _job;
    private List<PathMatcher> _modifiedFilesExcludesPathMatchers;
    private List<PathMatcher> _modifiedFilesIncludesPathMatchers;
    private final String _name;
    private final Properties _properties;
    private List<TestBatch> _testBatches;
    private final Set<JobProperty> _testBatchNamesJobProperties = new HashSet<JobProperty>();

    public RelevantRule(String filePath, Job job, String name, Properties properties) {
        this._filePath = filePath;
        this._job = job;
        this._name = name;
        this._properties = properties;
    }

    @Override
    public int compareTo(RelevantRule relevantRule) {
        return this._name.compareTo(relevantRule.getName());
    }

    public String getFilePath() {
        return this._filePath;
    }

    public String getKey() {
        return this._filePath + "_" + this._name;
    }

    public List<PathMatcher> getModifiedFilesExcludesPathMatchers() {
        String modifiedFilesGlobalExcludes;
        if (this._modifiedFilesExcludesPathMatchers != null) {
            return this._modifiedFilesExcludesPathMatchers;
        }
        ArrayList<PathMatcher> modifiedFilesExcludesPathMatchers = new ArrayList<PathMatcher>();
        String modifiedFilesExcludes = JenkinsResultsParserUtil.getProperty(this.getProperties(), "modified.files.excludes", this.getName(), this.getTestSuiteName());
        if (modifiedFilesExcludes != null) {
            modifiedFilesExcludesPathMatchers.addAll(JenkinsResultsParserUtil.toPathMatchers(this._getParentFilePath() + "/", modifiedFilesExcludes.split(",")));
        }
        if ((modifiedFilesGlobalExcludes = this._getBaseDirTestProperty("modified.files.global.excludes")) != null) {
            modifiedFilesExcludesPathMatchers.addAll(JenkinsResultsParserUtil.toPathMatchers(this._getBaseDirPath() + "/", modifiedFilesGlobalExcludes.split(",")));
        }
        if (!modifiedFilesExcludesPathMatchers.isEmpty()) {
            this._modifiedFilesExcludesPathMatchers = modifiedFilesExcludesPathMatchers;
        }
        return this._modifiedFilesExcludesPathMatchers;
    }

    public List<PathMatcher> getModifiedFilesIncludesPathMatchers() {
        if (this._modifiedFilesIncludesPathMatchers != null) {
            return this._modifiedFilesIncludesPathMatchers;
        }
        String modifiedFilesIncludes = JenkinsResultsParserUtil.getProperty(this.getProperties(), "modified.files.includes", this.getName(), this.getTestSuiteName());
        this._modifiedFilesIncludesPathMatchers = modifiedFilesIncludes == null || modifiedFilesIncludes.isEmpty() ? Collections.emptyList() : JenkinsResultsParserUtil.toPathMatchers(this._getParentFilePath() + "/", modifiedFilesIncludes.split(","));
        String modifiedFilesGlobalIncludes = this._getBaseDirTestProperty("modified.files.global.includes");
        if (modifiedFilesGlobalIncludes != null) {
            this._modifiedFilesIncludesPathMatchers.addAll(JenkinsResultsParserUtil.toPathMatchers(this._getBaseDirPath() + "/", modifiedFilesGlobalIncludes.split(",")));
        }
        return this._modifiedFilesIncludesPathMatchers;
    }

    public String getName() {
        return this._name;
    }

    public Properties getProperties() {
        return this._properties;
    }

    public List<TestBatch> getTestBatches() {
        if (this._testBatches == null) {
            JobProperty testBatchNamesJobProperty = this.getTestBatchNamesJobProperty();
            String testBatchNamesPropertyValue = testBatchNamesJobProperty.getValue();
            if (testBatchNamesPropertyValue == null) {
                return Collections.emptyList();
            }
            this._testBatchNamesJobProperties.add(testBatchNamesJobProperty);
            this._testBatches = new ArrayList<TestBatch>();
            for (String testBatchName : testBatchNamesPropertyValue.split(",")) {
                this._testBatches.add(TestBatchFactory.newTestBatch(new File(this._filePath), this.getProperties(), testBatchName, this.getName(), this.getTestSuiteName()));
            }
        }
        return this._testBatches;
    }

    public Set<JobProperty> getTestBatchNamesJobProperties() {
        return this._testBatchNamesJobProperties;
    }

    public JobProperty getTestBatchNamesJobProperty() {
        File propertiesFile = new File(this._filePath);
        File propertiesBaseDir = propertiesFile.getParentFile();
        JobProperty.Type jobPropertyType = JobProperty.Type.DEFAULT_TEST_DIR;
        if (!this._filePath.endsWith("liferay-portal/test.properties")) {
            jobPropertyType = JobProperty.Type.MODULE_TEST_DIR;
        }
        return JobPropertyFactory.newJobProperty("test.batch.names", "relevant", null, this._name, this._job, propertiesBaseDir, jobPropertyType, true);
    }

    public String getTestSuiteName() {
        RelevantRuleEngine relevantRuleEngine = RelevantRuleEngine.getInstance();
        return relevantRuleEngine.getTestSuiteName();
    }

    public boolean matches(File modifiedFile) {
        return JenkinsResultsParserUtil.isFileIncluded(this.getModifiedFilesExcludesPathMatchers(), this.getModifiedFilesIncludesPathMatchers(), modifiedFile);
    }

    public void validate() throws RelevantRuleConfigurationException {
        List<TestBatch> testBatches = this.getTestBatches();
        if (testBatches.isEmpty()) {
            throw new RelevantRuleConfigurationException(JenkinsResultsParserUtil.combine("Unable to find test.batch.names for relevant rule \"", this.getName(), "\" in ", this._filePath));
        }
        List<PathMatcher> modifiedFilesIncludes = this.getModifiedFilesIncludesPathMatchers();
        if (modifiedFilesIncludes.isEmpty()) {
            throw new RelevantRuleConfigurationException(JenkinsResultsParserUtil.combine("Unable to find modified.files.includes for relevant ", "rule \"", this.getName(), "\" in ", this._filePath));
        }
    }

    private String _getBaseDirPath() {
        RelevantRuleEngine relevantRuleEngine = RelevantRuleEngine.getInstance();
        return JenkinsResultsParserUtil.getCanonicalPath(relevantRuleEngine.getBaseDir());
    }

    private String _getBaseDirTestProperty(String propertyName) {
        RelevantRuleEngine relevantRuleEngine = RelevantRuleEngine.getInstance();
        File baseTestPropertiesFile = new File(relevantRuleEngine.getBaseDir(), "test.properties");
        if (!baseTestPropertiesFile.exists()) {
            return null;
        }
        return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getProperties(baseTestPropertiesFile), propertyName, this.getTestSuiteName());
    }

    private String _getParentFilePath() {
        File file = new File(this._filePath);
        return JenkinsResultsParserUtil.getCanonicalPath(file.getParentFile());
    }
}

