/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.suite;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalAcceptancePullRequestJob;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.test.suite.RelevantRule;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class RelevantRuleEngine {
    private static RelevantRuleEngine _relevantRuleEngine;
    private File _baseDir;
    private final Job _job;
    private final Map<RelevantRule, Set<File>> _relevantRuleMap = new HashMap<RelevantRule, Set<File>>();
    private final String _testSuiteName;

    public static void clear() {
        _relevantRuleEngine = null;
    }

    public static RelevantRuleEngine getInstance() {
        if (_relevantRuleEngine == null) {
            throw new IllegalStateException("Relevant rule engine is null");
        }
        return _relevantRuleEngine;
    }

    public static RelevantRuleEngine getInstance(PortalAcceptancePullRequestJob portalAcceptancePullRequestJob) {
        if (_relevantRuleEngine == null) {
            _relevantRuleEngine = new RelevantRuleEngine(portalAcceptancePullRequestJob);
        }
        return _relevantRuleEngine;
    }

    public File getBaseDir() {
        return this._baseDir;
    }

    public Job getJob() {
        return this._job;
    }

    public List<RelevantRule> getMatchingRelevantRules(List<File> modifiedFiles) {
        this._populateRelevantRuleMap(this._getTestPropertiesModifiedFilesMap(modifiedFiles));
        ArrayList<RelevantRule> matchingRelevantRules = new ArrayList<RelevantRule>();
        block0: for (Map.Entry<RelevantRule, Set<File>> entry : this._relevantRuleMap.entrySet()) {
            RelevantRule relevantRule = entry.getKey();
            for (File modifiedFile : entry.getValue()) {
                if (!relevantRule.matches(modifiedFile)) continue;
                matchingRelevantRules.add(relevantRule);
                continue block0;
            }
        }
        return matchingRelevantRules;
    }

    public List<String> getRelevantRuleNames(List<RelevantRule> relevantRules) {
        ArrayList<String> relevantRuleNames = new ArrayList<String>();
        for (RelevantRule relevantRule : relevantRules) {
            relevantRuleNames.add(relevantRule.getName());
        }
        return relevantRuleNames;
    }

    public String getTestSuiteName() {
        return this._testSuiteName;
    }

    public void setBaseDir(File baseDir) {
        this._baseDir = baseDir;
    }

    private RelevantRuleEngine(PortalAcceptancePullRequestJob portalAcceptancePullRequestJob) {
        this._job = portalAcceptancePullRequestJob;
        this._testSuiteName = portalAcceptancePullRequestJob.getTestSuiteName();
        PortalGitWorkingDirectory portalGitWorkingDirectory = portalAcceptancePullRequestJob.getPortalGitWorkingDirectory();
        this._baseDir = portalGitWorkingDirectory.getWorkingDirectory();
        _relevantRuleEngine = this;
    }

    private RelevantRule _getRelevantRule(String filePath, Job job, String relevantRuleName, Properties properties) {
        String relevantRuleKey = filePath + "_" + relevantRuleName;
        for (RelevantRule relevantRule : this._relevantRuleMap.keySet()) {
            if (!relevantRuleKey.equals(relevantRule.getKey())) continue;
            return relevantRule;
        }
        RelevantRule relevantRule = new RelevantRule(filePath, job, relevantRuleName, properties);
        this._relevantRuleMap.put(relevantRule, new HashSet());
        return relevantRule;
    }

    private Properties _getRelevantRuleProperties(String relevantRuleName, Properties properties) {
        Properties relevantRuleProperties = new Properties();
        for (Object object : properties.keySet()) {
            String propertyName = (String)object;
            if (!propertyName.contains("[" + relevantRuleName + "]") || !propertyName.contains("[" + this.getTestSuiteName() + "]")) continue;
            String propertyValue = properties.getProperty(propertyName);
            relevantRuleProperties.setProperty(propertyName, propertyValue);
        }
        return relevantRuleProperties;
    }

    private Set<String> _getTestPropertiesFilePaths(File file, Set<String> testPropertiesFilePaths) {
        if (testPropertiesFilePaths == null) {
            testPropertiesFilePaths = new HashSet<String>();
        }
        file = file.getParentFile();
        File testPropertiesFile = new File(file, "test.properties");
        String testPropertiesFilePath = JenkinsResultsParserUtil.getCanonicalPath(testPropertiesFile);
        if (testPropertiesFile.exists() && !testPropertiesFilePaths.contains(testPropertiesFilePath)) {
            testPropertiesFilePaths.add(testPropertiesFilePath);
        }
        if (file.equals(this._baseDir)) {
            return testPropertiesFilePaths;
        }
        return this._getTestPropertiesFilePaths(file, testPropertiesFilePaths);
    }

    private Map<String, Set<File>> _getTestPropertiesModifiedFilesMap(List<File> modifiedFiles) {
        HashMap<String, Set<File>> testPropertiesModifiedFilesMap = new HashMap<String, Set<File>>();
        for (File modifiedFile : modifiedFiles) {
            for (String testPropertiesFilePath : this._getTestPropertiesFilePaths(modifiedFile, null)) {
                if (!testPropertiesModifiedFilesMap.containsKey(testPropertiesFilePath)) {
                    testPropertiesModifiedFilesMap.put(testPropertiesFilePath, new HashSet());
                }
                Set testPropertiesModifiedFiles = (Set)testPropertiesModifiedFilesMap.get(testPropertiesFilePath);
                testPropertiesModifiedFiles.add(modifiedFile);
            }
        }
        return testPropertiesModifiedFilesMap;
    }

    private void _populateRelevantRuleMap(Map<String, Set<File>> testPropertiesModifiedFilesMap) {
        for (Map.Entry<String, Set<File>> entry : testPropertiesModifiedFilesMap.entrySet()) {
            String testPropertiesFilePath = entry.getKey();
            File testPropertiesFile = new File(testPropertiesFilePath);
            Properties properties = JenkinsResultsParserUtil.getProperties(testPropertiesFile);
            String relevantRuleNames = JenkinsResultsParserUtil.getProperty(properties, "relevant.rule.names");
            if (relevantRuleNames == null) continue;
            for (String relevantRuleName : relevantRuleNames.split(",")) {
                this._relevantRuleMap.put(this._getRelevantRule(testPropertiesFilePath, this._job, relevantRuleName, this._getRelevantRuleProperties(relevantRuleName, properties)), entry.getValue());
            }
        }
    }
}

