/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.suite;

import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.JobFactory;
import com.liferay.jenkins.results.parser.PortalAcceptancePullRequestJob;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.test.batch.DefaultTestBatch;
import com.liferay.jenkins.results.parser.test.batch.TestBatch;
import com.liferay.jenkins.results.parser.test.suite.RelevantRule;
import com.liferay.jenkins.results.parser.test.suite.RelevantRuleConfigurationException;
import com.liferay.jenkins.results.parser.test.suite.RelevantRuleEngine;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class RelevantRuleValidation {
    private static final String[] _EXCLUDE_GLOBS = new String[]{"**/.git/**", "**/.gradle/**", "**/.m2/**", "**/.settings/**", "**/bin/**", "**/build/**", "**/classes/**", "**/jenkins-results-parser/src/test/resources/dependencies/**", "**/node_modules/**", "**/test-classes/**", "**/test-coverage/**", "**/test-results/**", "**/tmp/**", "**/tools/**", "**/WEB-INF/classes/**", "**/work/**"};

    public static void evaluate(List<RelevantRule> relevantRules) {
        for (RelevantRule relevantRule : relevantRules) {
            try {
                relevantRule.validate();
            }
            catch (RelevantRuleConfigurationException relevantRuleConfigurationException) {
                RelevantRuleConfigurationException.addException(relevantRuleConfigurationException);
            }
            for (TestBatch testBatch : relevantRule.getTestBatches()) {
                if (testBatch instanceof DefaultTestBatch) continue;
                Object testSelector = testBatch.getTestSelector();
                try {
                    testSelector.validate();
                }
                catch (RelevantRuleConfigurationException relevantRuleConfigurationException) {
                    RelevantRuleConfigurationException.addException(relevantRuleConfigurationException);
                }
            }
        }
    }

    public static void throwExceptions() {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        for (Exception exception : RelevantRuleConfigurationException.getExceptions()) {
            if (i == 1) {
                sb.append("The following issues were found:");
            }
            sb.append("\n");
            sb.append(i);
            sb.append(". ");
            sb.append(exception.getMessage());
            ++i;
        }
        if (sb.length() > 0) {
            throw new RuntimeException(sb.toString());
        }
    }

    public static void validate(List<RelevantRule> relevantRules) {
        RelevantRuleValidation.evaluate(relevantRules);
        RelevantRuleValidation.throwExceptions();
    }

    public static void validate(String repositoryName, String upstreamBranchName) throws IOException {
        Properties properties = JenkinsResultsParserUtil.getBuildProperties();
        File portalDir = new File(properties.getProperty("portal.dir[" + upstreamBranchName + "]"));
        PortalGitWorkingDirectory portalGitWorkingDirectory = (PortalGitWorkingDirectory)GitWorkingDirectoryFactory.newGitWorkingDirectory(upstreamBranchName, portalDir, repositoryName);
        PortalAcceptancePullRequestJob portalAcceptancePullRequestJob = (PortalAcceptancePullRequestJob)JobFactory.newJob(Job.BuildProfile.DXP, "test-portal-acceptance-pullrequest(master)", null, portalGitWorkingDirectory, upstreamBranchName, null, repositoryName, "relevant", upstreamBranchName);
        RelevantRuleEngine.getInstance(portalAcceptancePullRequestJob);
        for (Path testPropertiesPath : RelevantRuleValidation._findTestPropertiesPaths(portalDir)) {
            Properties testProperties = JenkinsResultsParserUtil.getProperties(testPropertiesPath.toFile());
            String relevantRuleNames = JenkinsResultsParserUtil.getProperty(testProperties, "relevant.rule.names");
            if (relevantRuleNames == null) continue;
            ArrayList<RelevantRule> relevantRules = new ArrayList<RelevantRule>();
            for (String relevantRuleName : relevantRuleNames.split(",")) {
                RelevantRule relevantRule = new RelevantRule(testPropertiesPath.toString(), portalAcceptancePullRequestJob, relevantRuleName, testProperties);
                relevantRules.add(relevantRule);
            }
            RelevantRuleValidation.evaluate(relevantRules);
        }
        RelevantRuleValidation.throwExceptions();
    }

    private static List<Path> _findTestPropertiesPaths(final File baseDir) throws IOException {
        final ArrayList<Path> testPropertiesFiles = new ArrayList<Path>();
        Files.walkFileTree(baseDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                if (JenkinsResultsParserUtil.isFileExcluded(JenkinsResultsParserUtil.toPathMatchers(baseDir.getCanonicalPath(), _EXCLUDE_GLOBS), filePath.toFile())) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes basicFileAttributes) {
                if (Objects.equals(String.valueOf(file.getFileName()), "test.properties")) {
                    testPropertiesFiles.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return testPropertiesFiles;
    }
}

