/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.suite;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalAcceptancePullRequestJob;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.batch.TestBatch;
import com.liferay.jenkins.results.parser.test.suite.RelevantRule;
import com.liferay.jenkins.results.parser.test.suite.RelevantRuleEngine;
import com.liferay.jenkins.results.parser.test.suite.RelevantRuleValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RelevantTestSuite {
    private List<File> _modifiedFiles;
    private final PortalGitWorkingDirectory _portalGitWorkingDirectory;
    private final RelevantRuleEngine _relevantRuleEngine;
    private final Set<JobProperty> _testBatchNamesJobProperties = new HashSet<JobProperty>();

    public RelevantTestSuite(PortalAcceptancePullRequestJob portalAcceptancePullRequestJob) {
        PortalGitWorkingDirectory portalGitWorkingDirectory = portalAcceptancePullRequestJob.getPortalGitWorkingDirectory();
        this._modifiedFiles = portalGitWorkingDirectory.getModifiedFilesList();
        this._portalGitWorkingDirectory = portalGitWorkingDirectory;
        this._relevantRuleEngine = RelevantRuleEngine.getInstance(portalAcceptancePullRequestJob);
    }

    public List<TestBatch> getTestBatches(boolean validateAllRules) {
        File baseTestPropertiesFile = new File(this._relevantRuleEngine.getBaseDir(), "test.properties");
        String testBatchNamesPropertyValue = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getProperties(baseTestPropertiesFile), "test.batch.names[relevant]");
        if (testBatchNamesPropertyValue == null) {
            throw new RuntimeException("Please set test.batch.names[relevant] in " + baseTestPropertiesFile);
        }
        List<RelevantRule> relevantRules = this._relevantRuleEngine.getMatchingRelevantRules(this._modifiedFiles);
        Collections.sort(relevantRules);
        try {
            if (validateAllRules) {
                RelevantRuleValidation.validate(this._portalGitWorkingDirectory.getGitRepositoryName(), this._portalGitWorkingDirectory.getUpstreamBranchName());
            } else {
                RelevantRuleValidation.validate(relevantRules);
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        List<String> validTestBatchNames = Arrays.asList(testBatchNamesPropertyValue.split(","));
        ArrayList<TestBatch> testBatches = new ArrayList<TestBatch>();
        System.out.println("There are " + relevantRules.size() + " matching relevant rules: " + this._relevantRuleEngine.getRelevantRuleNames(relevantRules));
        for (RelevantRule relevantRule : relevantRules) {
            for (TestBatch testBatch : relevantRule.getTestBatches()) {
                if (testBatches.contains(testBatch)) {
                    TestBatch existingTestBatch = (TestBatch)testBatches.get(testBatches.indexOf(testBatch));
                    existingTestBatch.merge(testBatch);
                    continue;
                }
                if (validTestBatchNames.isEmpty() || !validTestBatchNames.contains(testBatch.getName())) continue;
                testBatches.add(testBatch);
            }
            this._testBatchNamesJobProperties.addAll(relevantRule.getTestBatchNamesJobProperties());
        }
        Collections.sort(testBatches);
        return testBatches;
    }

    public Set<JobProperty> getTestBatchNamesJobProperties() {
        return this._testBatchNamesJobProperties;
    }

    public void setModifiedFiles(List<File> modifiedFiles) {
        this._modifiedFiles = modifiedFiles;
    }
}

