/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class BaseTestrayAttachment
implements TestrayAttachment {
    private final String _key;
    private final String _name;
    private final TestrayCaseResult _testrayCaseResult;
    private final URL _url;

    @Override
    public String getKey() {
        return this._key;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public URL getURL() {
        if (this._url != null) {
            return this._url;
        }
        TestrayServer testrayServer = this._testrayCaseResult.getTestrayServer();
        try {
            return new URL(JenkinsResultsParserUtil.combine(String.valueOf(testrayServer.getURL()), "/reports/production/logs/", this.getKey()));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValue() {
        String urlString = String.valueOf(this.getURL());
        if (urlString.contains(".gz")) {
            String timeStamp = JenkinsResultsParserUtil.getDistinctTimeStamp();
            File file = new File(timeStamp);
            File gzipFile = new File(timeStamp + ".gz");
            try {
                JenkinsResultsParserUtil.toFile(this.getURL(), gzipFile);
                JenkinsResultsParserUtil.unGzip(gzipFile, file);
                String string = JenkinsResultsParserUtil.read(file);
                return string;
            }
            catch (Exception exception) {
                System.out.println("Unable to download " + this.getURL());
                String string = null;
                return string;
            }
            finally {
                JenkinsResultsParserUtil.delete(file);
                JenkinsResultsParserUtil.delete(gzipFile);
            }
        }
        try {
            return JenkinsResultsParserUtil.toString(urlString);
        }
        catch (IOException ioException) {
            System.out.println("Unable to download " + this.getURL());
            return null;
        }
    }

    protected BaseTestrayAttachment(TestrayCaseResult testrayCaseResult, String name, String key) {
        this(testrayCaseResult, name, key, null);
    }

    protected BaseTestrayAttachment(TestrayCaseResult testrayCaseResult, String name, String key, URL url) {
        this._testrayCaseResult = testrayCaseResult;
        this._name = name;
        this._key = key;
        this._url = url;
    }

    protected TestrayCaseResult getTestrayCaseResult() {
        return this._testrayCaseResult;
    }
}

