/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.TestrayAttachmentRecorder;
import com.liferay.jenkins.results.parser.testray.TestrayAttachmentUploader;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;

public abstract class BaseTestrayAttachmentUploader
implements TestrayAttachmentUploader {
    private final Build _build;
    private boolean _prepared;
    private final TestrayAttachmentRecorder _testrayAttachmentRecorder;
    private final URL _testrayServerURL;

    @Override
    public URL getTestrayServerURL() {
        return this._testrayServerURL;
    }

    @Override
    public void prepareFiles() {
        if (this._prepared) {
            return;
        }
        File preparedFilesBaseDir = this.getPreparedFilesBaseDir();
        JenkinsResultsParserUtil.delete(preparedFilesBaseDir);
        TestrayAttachmentRecorder testrayAttachmentRecorder = this.getTestrayAttachmentRecorder();
        testrayAttachmentRecorder.record();
        try {
            JenkinsResultsParserUtil.copy(testrayAttachmentRecorder.getRecordedFilesBaseDir(), preparedFilesBaseDir);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        for (File preparedFile : this.getPreparedFiles()) {
            String preparedFilePath = preparedFile.toString();
            if (preparedFilePath.contains("playwright-report")) continue;
            String preparedFileName = preparedFile.getName();
            if (preparedFileName.endsWith(".html")) {
                try {
                    String preparedFileContent = JenkinsResultsParserUtil.read(preparedFile);
                    File preparedParentFile = preparedFile.getParentFile();
                    preparedFileContent = preparedFileContent.replaceAll("(screenshots/(?:after|before|screenshot)\\d+)\\.jpg", JenkinsResultsParserUtil.combine(String.valueOf(this.getTestrayServerLogsURL()), "/", testrayAttachmentRecorder.getRelativeBuildDirPath(), "/", preparedParentFile.getName(), "/$1.jpg.gz"));
                    preparedFileContent = preparedFileContent.replace("https://cdn.alloyui.com/3.1.0/", "https://cdn.jsdelivr.net/npm/alloy-ui@3.1.0/build/");
                    JenkinsResultsParserUtil.write(preparedFile, preparedFileContent);
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
            this._convertToGzipFile(preparedFile);
        }
        this._prepared = true;
    }

    protected BaseTestrayAttachmentUploader(Build build, URL testrayServerURL) {
        if (build == null) {
            throw new RuntimeException("Please set a build");
        }
        this._build = build;
        this._testrayAttachmentRecorder = TestrayFactory.newTestrayAttachmentRecorder(build);
        this._testrayServerURL = testrayServerURL;
    }

    protected Build getBuild() {
        return this._build;
    }

    protected List<File> getPreparedFiles() {
        return JenkinsResultsParserUtil.findFiles(this.getPreparedFilesBaseDir(), ".*");
    }

    protected TestrayAttachmentRecorder getTestrayAttachmentRecorder() {
        return this._testrayAttachmentRecorder;
    }

    private File _convertToGzipFile(File file) {
        File gzipFile = new File(file.getParent(), file.getName() + ".gz");
        JenkinsResultsParserUtil.gzip(file, gzipFile);
        JenkinsResultsParserUtil.delete(file);
        return gzipFile;
    }
}

