/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.DownstreamBuild;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.QAWebsitesGitRepositoryJob;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.job.property.JobPropertyFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.testray.BuildTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TopLevelBuildTestrayCaseResult;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class BatchBuildTestrayCaseResult
extends BuildTestrayCaseResult {
    private static final Pattern _dockerLogsURLPattern = Pattern.compile("https?://.+/(?<key>docker-logs/(?<fileName>[^/]+.log).txt.gz)");
    private static final Pattern _gcLogsURLPattern = Pattern.compile("https?://.+/(?<key>gc/(?<fileName>[^/]+.log).txt.gz)");
    private static final Pattern _jStacksURLPattern = Pattern.compile("https?://.+/(?<key>jstacks/(?<fileName>[^/]+.log).txt.gz)");
    private final AxisTestClassGroup _axisTestClassGroup;
    private TopLevelBuildTestrayCaseResult _topLevelBuildTestrayCaseResult;

    public BatchBuildTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild, AxisTestClassGroup axisTestClassGroup) {
        super(testrayBuild, topLevelBuild);
        this._axisTestClassGroup = axisTestClassGroup;
    }

    public String getAxisName() {
        return this._axisTestClassGroup.getAxisName();
    }

    public String getBatchName() {
        return this._axisTestClassGroup.getBatchName();
    }

    @Override
    public Build getBuild() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        DownstreamBuild downstreamBuild = topLevelBuild.getDownstreamBuild(this.getAxisName());
        if (downstreamBuild != null) {
            return downstreamBuild;
        }
        return topLevelBuild.getDownstreamAxisBuild(this.getAxisName());
    }

    @Override
    public String getComponentName() {
        try {
            return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.component", this.getBatchName());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String getErrors() {
        Build build = this.getBuild();
        if (build == null) {
            return "Unable to run on CI";
        }
        if (!build.isFailing()) {
            return null;
        }
        String result = build.getResult();
        if (result == null) {
            return "Unable to finish build on CI";
        }
        if (result.equals("ABORTED")) {
            return build.getJobName() + " timed out after 2 hours";
        }
        String errorMessage = build.getFailureMessage();
        if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage)) {
            return "Failed for unknown reason";
        }
        if (errorMessage.contains("\n")) {
            errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n"));
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage = errorMessage.trim())) {
            return "Failed for unknown reason";
        }
        return errorMessage;
    }

    @Override
    public String getName() {
        return this.getAxisName();
    }

    @Override
    public int getPriority() {
        try {
            String testrayCasePriority = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.priority", this.getBatchName());
            if (testrayCasePriority != null && testrayCasePriority.matches("\\d+")) {
                return Integer.parseInt(testrayCasePriority);
            }
            return 5;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String getTeamName() {
        JobProperty teamNamesJobProperty = this._getJobProperty("testray.team.names");
        String teamNames = teamNamesJobProperty.getValue();
        if (JenkinsResultsParserUtil.isNullOrEmpty(teamNames)) {
            try {
                return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.team", this.getBatchName());
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
        String componentName = this.getComponentName();
        for (String teamName : teamNames.split(",")) {
            String teamComponentNames;
            JobProperty teamComponentNamesJobProperty = this._getJobProperty("testray.team." + teamName + ".component.names");
            if (teamComponentNamesJobProperty == null || JenkinsResultsParserUtil.isNullOrEmpty(teamComponentNames = teamComponentNamesJobProperty.getValue())) continue;
            for (String teamComponentName : teamComponentNames.split(",")) {
                if (!teamComponentName.equals(componentName)) continue;
                teamName = teamName.replace("-", " ");
                return WordUtils.capitalize((String)teamName);
            }
        }
        try {
            return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.team", this.getBatchName());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public List<TestrayAttachment> getTestrayAttachments() {
        ArrayList<TestrayAttachment> testrayAttachments = new ArrayList<TestrayAttachment>();
        testrayAttachments.addAll(this._getDockerLogsTestrayAttachments());
        testrayAttachments.addAll(this._getGCLogsTestrayAttachments());
        testrayAttachments.addAll(this._getJStacksTestrayAttachments());
        testrayAttachments.add(this._getGradlePluginsAttachment());
        testrayAttachments.add(this._getJenkinsConsoleTestrayAttachment());
        testrayAttachments.add(this.getTopLevelBuildReportTestrayAttachment());
        testrayAttachments.add(this.getTopLevelJenkinsConsoleTestrayAttachment());
        testrayAttachments.add(this.getTopLevelJenkinsReportTestrayAttachment());
        testrayAttachments.add(this.getTopLevelJobSummaryTestrayAttachment());
        testrayAttachments.add(this._getWarningsTestrayAttachment());
        testrayAttachments.removeAll(Collections.singleton(null));
        return testrayAttachments;
    }

    @Override
    public String getType() {
        try {
            return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.type", this.getBatchName());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String[] getWarnings() {
        TestrayAttachment testrayAttachment = this._getWarningsTestrayAttachment();
        if (testrayAttachment == null) {
            return null;
        }
        String testrayAttachmentValue = testrayAttachment.getValue();
        if (JenkinsResultsParserUtil.isNullOrEmpty(testrayAttachmentValue)) {
            return null;
        }
        try {
            Document document = Dom4JUtil.parse(testrayAttachmentValue);
            Element rootElement = document.getRootElement();
            ArrayList<String> warnings = new ArrayList<String>();
            for (Element valueElement : rootElement.elements()) {
                String warning = valueElement.getText();
                if (JenkinsResultsParserUtil.isNullOrEmpty(warning = warning.trim())) continue;
                warnings.add(warning);
            }
            if (!warnings.isEmpty()) {
                return warnings.toArray(new String[0]);
            }
        }
        catch (DocumentException documentException) {
            return null;
        }
        return null;
    }

    protected String getAxisBuildURLPath() {
        return JenkinsResultsParserUtil.combine(this.getTopLevelBuildURLPath(), "/", this.getAxisName());
    }

    protected AxisTestClassGroup getAxisTestClassGroup() {
        return this._axisTestClassGroup;
    }

    protected List<TestrayAttachment> getLiferayLogTestrayAttachments() {
        TestrayAttachment liferayLogTestrayAttachment;
        ArrayList<TestrayAttachment> testrayAttachments = new ArrayList<TestrayAttachment>();
        TestrayAttachment testrayAttachment = this.getTestrayAttachment(this.getBuild(), "Liferay Log", this.getAxisBuildURLPath() + "/liferay-log.txt.gz");
        if (testrayAttachment == null) {
            return testrayAttachments;
        }
        testrayAttachments.add(testrayAttachment);
        for (int i = 1; i <= 5 && (liferayLogTestrayAttachment = this.getTestrayAttachment(this.getBuild(), "Liferay Log (" + i + ")", JenkinsResultsParserUtil.combine(this.getAxisBuildURLPath(), "/liferay-log-", String.valueOf(i), ".txt.gz"))) != null; ++i) {
            testrayAttachments.add(liferayLogTestrayAttachment);
        }
        return testrayAttachments;
    }

    protected List<TestrayAttachment> getLiferayOSGiLogTestrayAttachments() {
        TestrayAttachment liferayOSGiLogTestrayAttachment;
        ArrayList<TestrayAttachment> testrayAttachments = new ArrayList<TestrayAttachment>();
        TestrayAttachment testrayAttachment = this.getTestrayAttachment(this.getBuild(), "Liferay OSGi Log", this.getAxisBuildURLPath() + "/liferay-osgi-log.txt.gz");
        if (testrayAttachment == null) {
            return testrayAttachments;
        }
        testrayAttachments.add(testrayAttachment);
        for (int i = 1; i <= 5 && (liferayOSGiLogTestrayAttachment = this.getTestrayAttachment(this.getBuild(), "Liferay OSGi Log (" + i + ")", JenkinsResultsParserUtil.combine(this.getAxisBuildURLPath(), "/liferay-osgi-log-", String.valueOf(i), ".txt.gz"))) != null; ++i) {
            testrayAttachments.add(liferayOSGiLogTestrayAttachment);
        }
        return testrayAttachments;
    }

    protected TestResult getTestResult() {
        return null;
    }

    protected long getTestResultDuration() {
        TestResult testResult = this.getTestResult();
        if (testResult == null) {
            return 0L;
        }
        return testResult.getDuration();
    }

    protected String getTestResultErrors() {
        String testResultErrors = null;
        Build build = this.getBuild();
        TestResult testResult = this.getTestResult();
        if (testResult == null) {
            String failureMessage;
            if (build == null) {
                return "Unable to run build on CI";
            }
            String result = build.getResult();
            testResultErrors = "Failed prior to running test";
            if (result == null) {
                testResultErrors = "Unable to finish build on CI";
            }
            if (result.equals("ABORTED")) {
                testResultErrors = build.getJobName() + " timed out after 2 hours";
            }
            if (result.equals("SUCCESS") || result.equals("UNSTABLE")) {
                testResultErrors = "Unable to run test on CI";
            }
            if (JenkinsResultsParserUtil.isNullOrEmpty(failureMessage = build.getFailureMessage())) {
                return testResultErrors;
            }
            return testResultErrors + ": " + failureMessage;
        }
        if (testResult.isSkipped()) {
            return "Failed to run test on CI";
        }
        if (!testResult.isFailing()) {
            return null;
        }
        testResultErrors = testResult.getErrorDetails();
        if (JenkinsResultsParserUtil.isNullOrEmpty(testResultErrors)) {
            testResultErrors = build.getFailureMessage();
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(testResultErrors)) {
            return "Failed for unknown reason";
        }
        if (testResultErrors.contains("\n")) {
            testResultErrors = testResultErrors.substring(0, testResultErrors.indexOf("\n"));
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(testResultErrors = testResultErrors.trim())) {
            return "Failed for unknown reason";
        }
        return testResultErrors;
    }

    protected TestrayCaseResult.Status getTestResultStatus() {
        Build build = this.getBuild();
        if (build == null) {
            return TestrayCaseResult.Status.UNTESTED;
        }
        TestResult testResult = this.getTestResult();
        if (testResult == null) {
            String result = build.getResult();
            if (result == null || result.equals("SUCCESS") || result.equals("UNSTABLE")) {
                return TestrayCaseResult.Status.UNTESTED;
            }
            return TestrayCaseResult.Status.FAILED;
        }
        if (testResult.isFailing()) {
            return TestrayCaseResult.Status.FAILED;
        }
        if (testResult.isSkipped()) {
            return TestrayCaseResult.Status.UNTESTED;
        }
        return TestrayCaseResult.Status.PASSED;
    }

    @Override
    protected TestrayAttachment getTopLevelBuildReportTestrayAttachment() {
        TopLevelBuildTestrayCaseResult topLevelBuildTestrayCaseResult = this.getTopLevelBuildTestrayCaseResult();
        if (topLevelBuildTestrayCaseResult == null) {
            return null;
        }
        return topLevelBuildTestrayCaseResult.getTopLevelBuildReportTestrayAttachment();
    }

    protected TopLevelBuildTestrayCaseResult getTopLevelBuildTestrayCaseResult() {
        if (this._topLevelBuildTestrayCaseResult != null) {
            return this._topLevelBuildTestrayCaseResult;
        }
        this._topLevelBuildTestrayCaseResult = TestrayFactory.newTopLevelBuildTestrayCaseResult(this.getTestrayBuild(), this.getTopLevelBuild());
        return this._topLevelBuildTestrayCaseResult;
    }

    @Override
    protected TestrayAttachment getTopLevelJenkinsConsoleTestrayAttachment() {
        TopLevelBuildTestrayCaseResult topLevelBuildTestrayCaseResult = this.getTopLevelBuildTestrayCaseResult();
        if (topLevelBuildTestrayCaseResult == null) {
            return null;
        }
        return topLevelBuildTestrayCaseResult.getTopLevelJenkinsConsoleTestrayAttachment();
    }

    @Override
    protected TestrayAttachment getTopLevelJenkinsReportTestrayAttachment() {
        TopLevelBuildTestrayCaseResult topLevelBuildTestrayCaseResult = this.getTopLevelBuildTestrayCaseResult();
        if (topLevelBuildTestrayCaseResult == null) {
            return null;
        }
        return topLevelBuildTestrayCaseResult.getTopLevelJenkinsReportTestrayAttachment();
    }

    @Override
    protected TestrayAttachment getTopLevelJobSummaryTestrayAttachment() {
        TopLevelBuildTestrayCaseResult topLevelBuildTestrayCaseResult = this.getTopLevelBuildTestrayCaseResult();
        if (topLevelBuildTestrayCaseResult == null) {
            return null;
        }
        return topLevelBuildTestrayCaseResult.getTopLevelJobSummaryTestrayAttachment();
    }

    private List<TestrayAttachment> _getDockerLogsTestrayAttachments() {
        ArrayList<TestrayAttachment> testrayAttachments = new ArrayList<TestrayAttachment>();
        Build build = this.getBuild();
        if (build == null) {
            return testrayAttachments;
        }
        for (URL testrayAttachmentURL : build.getTestrayAttachmentURLs()) {
            Matcher matcher = _dockerLogsURLPattern.matcher(String.valueOf(testrayAttachmentURL));
            if (!matcher.find()) continue;
            testrayAttachments.add(this.getTestrayAttachment(build, "Docker Log (" + matcher.group("fileName") + ")", this.getAxisBuildURLPath() + "/" + matcher.group("key")));
        }
        return testrayAttachments;
    }

    private List<TestrayAttachment> _getGCLogsTestrayAttachments() {
        ArrayList<TestrayAttachment> testrayAttachments = new ArrayList<TestrayAttachment>();
        Build build = this.getBuild();
        if (build == null) {
            return testrayAttachments;
        }
        for (URL testrayAttachmentURL : build.getTestrayAttachmentURLs()) {
            Matcher matcher = _gcLogsURLPattern.matcher(String.valueOf(testrayAttachmentURL));
            if (!matcher.find()) continue;
            testrayAttachments.add(this.getTestrayAttachment(build, "GC Log (" + matcher.group("fileName") + ")", this.getAxisBuildURLPath() + "/" + matcher.group("key")));
        }
        return testrayAttachments;
    }

    private TestrayAttachment _getGradlePluginsAttachment() {
        return this.getTestrayAttachment(this.getBuild(), "Gradle Plugins Test Report", this.getAxisBuildURLPath() + "/gradle_plugins.tar.gz");
    }

    private TestrayAttachment _getJenkinsConsoleTestrayAttachment() {
        String name = "Jenkins Console";
        String key = this.getAxisBuildURLPath() + "/jenkins-console.txt.gz";
        TestrayAttachment testrayAttachment = this.getTestrayAttachment(this.getBuild(), name, key);
        if (testrayAttachment != null) {
            return testrayAttachment;
        }
        final Build build = this.getBuild();
        if (build == null) {
            return null;
        }
        return this.uploadTestrayAttachment(name, key, new Callable<File>(){

            @Override
            public File call() throws Exception {
                File jenkinsConsoleFile = new File(BatchBuildTestrayCaseResult.this.getTestrayUploadBaseDir(), "jenkins-console.txt");
                File jenkinsConsoleGzFile = new File(BatchBuildTestrayCaseResult.this.getTestrayUploadBaseDir(), "jenkins-console.txt.gz");
                try {
                    JenkinsResultsParserUtil.write(jenkinsConsoleFile, build.getConsoleText());
                    JenkinsResultsParserUtil.gzip(jenkinsConsoleFile, jenkinsConsoleGzFile);
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
                finally {
                    JenkinsResultsParserUtil.delete(jenkinsConsoleFile);
                }
                if (jenkinsConsoleGzFile.exists()) {
                    return jenkinsConsoleGzFile;
                }
                return null;
            }
        });
    }

    private JobProperty _getJobProperty(String basePropertyName) {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        Job job = topLevelBuild.getJob();
        if (job instanceof QAWebsitesGitRepositoryJob) {
            AxisTestClassGroup axisTestClassGroup = this.getAxisTestClassGroup();
            return JobPropertyFactory.newJobProperty(basePropertyName, job, axisTestClassGroup.getTestBaseDir(), JobProperty.Type.QA_WEBSITES_TEST_DIR);
        }
        return JobPropertyFactory.newJobProperty(basePropertyName, job);
    }

    private List<TestrayAttachment> _getJStacksTestrayAttachments() {
        ArrayList<TestrayAttachment> testrayAttachments = new ArrayList<TestrayAttachment>();
        Build build = this.getBuild();
        if (build == null) {
            return testrayAttachments;
        }
        for (URL testrayAttachmentURL : build.getTestrayAttachmentURLs()) {
            Matcher matcher = _jStacksURLPattern.matcher(String.valueOf(testrayAttachmentURL));
            if (!matcher.find()) continue;
            testrayAttachments.add(this.getTestrayAttachment(build, "Docker Log (" + matcher.group("fileName") + ")", this.getAxisBuildURLPath() + "/" + matcher.group("key")));
        }
        return testrayAttachments;
    }

    private TestrayAttachment _getWarningsTestrayAttachment() {
        return this.getTestrayAttachment(this.getBuild(), "Warnings", this.getAxisBuildURLPath() + "/warnings.html.gz");
    }
}

