/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.test.clazz.FunctionalTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.testray.BatchBuildTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FunctionalBatchBuildTestrayCaseResult
extends BatchBuildTestrayCaseResult {
    private final FunctionalTestClass _functionalTestClass;

    public FunctionalBatchBuildTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild, AxisTestClassGroup axisTestClassGroup, TestClass testClass) {
        super(testrayBuild, topLevelBuild, axisTestClassGroup);
        if (!(testClass instanceof FunctionalTestClass)) {
            throw new RuntimeException("Test class is not a functional test class");
        }
        this._functionalTestClass = (FunctionalTestClass)testClass;
    }

    @Override
    public String getComponentName() {
        return JenkinsResultsParserUtil.getProperty(this._functionalTestClass.getPoshiProperties(), "testray.main.component.name");
    }

    @Override
    public long getDuration() {
        return this.getTestResultDuration();
    }

    @Override
    public String getErrors() {
        return this.getTestResultErrors();
    }

    @Override
    public String getName() {
        return this._functionalTestClass.getTestClassMethodName();
    }

    @Override
    public int getPriority() {
        String priority = JenkinsResultsParserUtil.getProperty(this._functionalTestClass.getPoshiProperties(), "priority");
        if (priority != null && priority.matches("\\d+")) {
            return Integer.parseInt(priority);
        }
        return 5;
    }

    @Override
    public TestrayCaseResult.Status getStatus() {
        String errorDetails;
        TestResult testResult = this.getTestResult();
        if (testResult != null && !JenkinsResultsParserUtil.isNullOrEmpty(errorDetails = testResult.getErrorDetails()) && errorDetails.contains("TEST_SETUP_ERROR:")) {
            return TestrayCaseResult.Status.BLOCKED;
        }
        return this.getTestResultStatus();
    }

    @Override
    public String getSubcomponentNames() {
        return JenkinsResultsParserUtil.getProperty(this._functionalTestClass.getPoshiProperties(), "testray.component.names");
    }

    @Override
    public List<TestrayAttachment> getTestrayAttachments() {
        List<TestrayAttachment> testrayAttachments = super.getTestrayAttachments();
        testrayAttachments.addAll(this.getLiferayLogTestrayAttachments());
        testrayAttachments.addAll(this.getLiferayOSGiLogTestrayAttachments());
        testrayAttachments.add(this._getPoshiConsoleTestrayAttachment());
        testrayAttachments.add(this._getPoshiReportTestrayAttachment());
        testrayAttachments.add(this._getPoshiSummaryTestrayAttachment());
        testrayAttachments.removeAll(Collections.singleton(null));
        return testrayAttachments;
    }

    @Override
    public TestResult getTestResult() {
        Build build = this.getBuild();
        if (build == null) {
            return null;
        }
        TestClassResult testClassResult = build.getTestClassResult("com.liferay.poshi.runner.PoshiRunner");
        if (testClassResult == null) {
            testClassResult = build.getTestClassResult("com.liferay.poshi.runner.ParallelPoshiRunner");
        }
        if (testClassResult == null) {
            return null;
        }
        return testClassResult.getTestResult("test[" + this.getName() + "]");
    }

    @Override
    protected List<TestrayAttachment> getLiferayLogTestrayAttachments() {
        if (this.getTestResult() == null) {
            return new ArrayList<TestrayAttachment>();
        }
        return super.getLiferayLogTestrayAttachments();
    }

    @Override
    protected List<TestrayAttachment> getLiferayOSGiLogTestrayAttachments() {
        if (this.getTestResult() == null) {
            return new ArrayList<TestrayAttachment>();
        }
        return super.getLiferayOSGiLogTestrayAttachments();
    }

    private TestrayAttachment _getPoshiConsoleTestrayAttachment() {
        if (this.getTestResult() == null) {
            return null;
        }
        String name = this.getName();
        name = name.replace("#", "_");
        return this.getTestrayAttachment(this.getBuild(), "Poshi Console", JenkinsResultsParserUtil.combine(this.getAxisBuildURLPath(), "/", JenkinsResultsParserUtil.fixURL(name), "/console.txt.gz"));
    }

    private TestrayAttachment _getPoshiReportTestrayAttachment() {
        if (this.getTestResult() == null) {
            return null;
        }
        String name = this.getName();
        name = name.replace("#", "_");
        return this.getTestrayAttachment(this.getBuild(), "Poshi Report", JenkinsResultsParserUtil.combine(this.getAxisBuildURLPath(), "/", JenkinsResultsParserUtil.fixURL(name), "/index.html.gz"));
    }

    private TestrayAttachment _getPoshiSummaryTestrayAttachment() {
        if (this.getTestResult() == null) {
            return null;
        }
        String name = this.getName();
        name = name.replace("#", "_");
        return this.getTestrayAttachment(this.getBuild(), "Poshi Summary", JenkinsResultsParserUtil.combine(this.getAxisBuildURLPath(), "/", JenkinsResultsParserUtil.fixURL(name), "/summary.html.gz"));
    }
}

