/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.test.clazz.JSUnitModulesTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.testray.BatchBuildTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JSUnitBatchBuildTestrayCaseResult
extends BatchBuildTestrayCaseResult {
    private final JSUnitModulesTestClass _jsUnitModulesTestClass;
    private final TestClassMethod _testClassMethod;
    private List<TestClassResult> _testClassResults;

    public JSUnitBatchBuildTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild, AxisTestClassGroup axisTestClassGroup, TestClassMethod testClassMethod) {
        super(testrayBuild, topLevelBuild, axisTestClassGroup);
        this._testClassMethod = testClassMethod;
        this._jsUnitModulesTestClass = (JSUnitModulesTestClass)testClassMethod.getTestClass();
    }

    @Override
    public String getComponentName() {
        String componentName = this._jsUnitModulesTestClass.getTestrayMainComponentName();
        if (JenkinsResultsParserUtil.isNullOrEmpty(componentName)) {
            return super.getComponentName();
        }
        return componentName;
    }

    @Override
    public long getDuration() {
        List<TestClassResult> testClassResults = this._getTestClassResults();
        if (testClassResults == null) {
            return 0L;
        }
        long duration = 0L;
        for (TestClassResult testClassResult : testClassResults) {
            duration += testClassResult.getDuration();
        }
        return duration;
    }

    @Override
    public String getErrors() {
        Build build = this.getBuild();
        List<TestClassResult> testClassResults = this._getTestClassResults();
        if (testClassResults == null || testClassResults.isEmpty()) {
            if (build == null) {
                return "Unable to run build on CI";
            }
            String result = build.getResult();
            if (result == null) {
                return "Unable to finish build on CI";
            }
            if (result.equals("ABORTED")) {
                return build.getJobName() + " timed out after 2 hours";
            }
            if (result.equals("SUCCESS") || result.equals("UNSTABLE")) {
                return "Unable to run test on CI";
            }
            return "Failed prior to running test";
        }
        if (!this._isTestClassResultsFailing()) {
            return null;
        }
        HashMap<String, String> errorMessages = new HashMap<String, String>();
        for (TestClassResult testClassResult : testClassResults) {
            if (testClassResult == null || !testClassResult.isFailing()) continue;
            for (TestResult testResult : testClassResult.getTestResults()) {
                if (!testResult.isFailing()) continue;
                String errorMessage = testResult.getErrorDetails();
                if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage)) {
                    errorMessage = build.getFailureMessage();
                }
                if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage)) {
                    errorMessage = "Failed for unknown reason";
                }
                if (errorMessage.contains("\n")) {
                    errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n"));
                }
                if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage = errorMessage.trim())) {
                    errorMessage = "Failed for unknown reason";
                }
                String testName = testResult.getTestName();
                errorMessages.put(testName, JenkinsResultsParserUtil.combine(testName, ": ", errorMessage));
            }
        }
        if (errorMessages.size() > 1) {
            return JenkinsResultsParserUtil.combine("Failed tests: ", JenkinsResultsParserUtil.join(", ", new ArrayList<String>(errorMessages.keySet())));
        }
        if (errorMessages.size() == 1) {
            ArrayList values = new ArrayList(errorMessages.values());
            return (String)values.get(0);
        }
        return "Failed for unknown reason";
    }

    @Override
    public String getName() {
        return this._testClassMethod.getName();
    }

    @Override
    public TestrayCaseResult.Status getStatus() {
        Build build = this.getBuild();
        if (build == null) {
            return TestrayCaseResult.Status.UNTESTED;
        }
        List<TestClassResult> testClassResults = this._getTestClassResults();
        if (testClassResults == null || testClassResults.isEmpty()) {
            String result = build.getResult();
            if (result == null || result.equals("ABORTED") || result.equals("FAILURE") || result.equals("SUCCESS") || result.equals("UNSTABLE")) {
                return TestrayCaseResult.Status.UNTESTED;
            }
            return TestrayCaseResult.Status.FAILED;
        }
        if (this._isTestClassResultsFailing()) {
            return TestrayCaseResult.Status.FAILED;
        }
        return TestrayCaseResult.Status.PASSED;
    }

    private List<TestClassResult> _getTestClassResults() {
        if (this._testClassResults != null) {
            return this._testClassResults;
        }
        this._testClassResults = new ArrayList<TestClassResult>();
        Build build = this.getBuild();
        if (build == null) {
            return this._testClassResults;
        }
        String taskDirectoryName = this.getName();
        taskDirectoryName = taskDirectoryName.replace(":packageRunTest", "");
        for (TestClassResult testClassResult : build.getTestClassResults()) {
            String testResultTaskName = this._getTestResultTaskName(testClassResult);
            if (!testResultTaskName.startsWith(taskDirectoryName)) continue;
            this._testClassResults.add(testClassResult);
        }
        return this._testClassResults;
    }

    private String _getTestResultTaskName(TestClassResult testClassResult) {
        String testClassName = testClassResult.getClassName();
        testClassName = testClassName.contains(".modules.") ? testClassName.replaceAll(".*\\.modules(\\..+)", "$1") : ".apps." + testClassName;
        return testClassName.replaceAll("\\.", ":");
    }

    private boolean _isTestClassResultsFailing() {
        for (TestClassResult testClassResult : this._getTestClassResults()) {
            if (!testClassResult.isFailing()) continue;
            return true;
        }
        return false;
    }
}

