/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.test.clazz.JUnitTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.testray.BatchBuildTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class JUnitBatchBuildTestrayCaseResult
extends BatchBuildTestrayCaseResult {
    private final JUnitTestClass _jUnitTestClass;
    private List<TestClassResult> _testClassResults;

    public JUnitBatchBuildTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild, AxisTestClassGroup axisTestClassGroup, TestClass testClass) {
        super(testrayBuild, topLevelBuild, axisTestClassGroup);
        this._jUnitTestClass = (JUnitTestClass)testClass;
    }

    @Override
    public String getComponentName() {
        String componentName = this._jUnitTestClass.getTestrayMainComponentName();
        if (JenkinsResultsParserUtil.isNullOrEmpty(componentName)) {
            return super.getComponentName();
        }
        return componentName;
    }

    @Override
    public long getDuration() {
        List<TestClassResult> testClassResults = this.getTestClassResults();
        if (testClassResults == null) {
            return 0L;
        }
        long duration = 0L;
        for (TestClassResult testClassResult : testClassResults) {
            duration += testClassResult.getDuration();
        }
        return duration;
    }

    @Override
    public String getErrors() {
        Build build = this.getBuild();
        List<TestClassResult> testClassResults = this.getTestClassResults();
        if (testClassResults == null || testClassResults.isEmpty()) {
            if (build == null) {
                return "Unable to run build on CI";
            }
            String result = build.getResult();
            if (result == null) {
                return "Unable to finish build on CI";
            }
            if (result.equals("ABORTED")) {
                return build.getJobName() + " timed out after 2 hours";
            }
            if (result.equals("SUCCESS") || result.equals("UNSTABLE")) {
                return "Unable to run test on CI";
            }
            return "Failed prior to running test";
        }
        if (this._isTestClassResultsSkipped()) {
            return "Failed prior to running test";
        }
        if (!this._isTestClassResultsFailing()) {
            return null;
        }
        HashMap<String, String> errorMessages = new HashMap<String, String>();
        for (TestResult testResult : this.getTestResults()) {
            if (testResult == null || !testResult.isFailing()) continue;
            String errorMessage = testResult.getErrorDetails();
            if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage)) {
                errorMessage = build.getFailureMessage();
            }
            if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage)) {
                errorMessage = "Failed for unknown reason";
            }
            if (errorMessage.contains("\n")) {
                errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n"));
            }
            if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage = errorMessage.trim())) {
                errorMessage = "Failed for unknown reason";
            }
            String testName = testResult.getTestName();
            errorMessages.put(testName, JenkinsResultsParserUtil.combine(testName, ": ", errorMessage));
        }
        if (errorMessages.size() > 1) {
            return JenkinsResultsParserUtil.combine(String.valueOf(errorMessages.size()), " Failed tests: ", JenkinsResultsParserUtil.join(", ", new ArrayList<String>(errorMessages.keySet())));
        }
        if (errorMessages.size() == 1) {
            ArrayList values = new ArrayList(errorMessages.values());
            return (String)values.get(0);
        }
        return "Failed for unknown reason";
    }

    @Override
    public String getName() {
        String testClassName = JenkinsResultsParserUtil.getCanonicalPath(this._jUnitTestClass.getTestClassFile());
        testClassName = testClassName.replaceAll(".*/(com/.*)\\.java", "$1");
        return testClassName.replace("/", ".");
    }

    @Override
    public TestrayCaseResult.Status getStatus() {
        Build build = this.getBuild();
        if (build == null) {
            return TestrayCaseResult.Status.UNTESTED;
        }
        List<TestClassResult> testClassResults = this.getTestClassResults();
        if (testClassResults == null || testClassResults.isEmpty()) {
            String result = build.getResult();
            if (result == null || result.equals("ABORTED") || result.equals("FAILURE") || result.equals("SUCCESS") || result.equals("UNSTABLE")) {
                return TestrayCaseResult.Status.UNTESTED;
            }
            return TestrayCaseResult.Status.FAILED;
        }
        if (this._isTestClassResultsSkipped()) {
            return TestrayCaseResult.Status.UNTESTED;
        }
        if (this._isTestClassResultsFailing()) {
            return TestrayCaseResult.Status.FAILED;
        }
        return TestrayCaseResult.Status.PASSED;
    }

    @Override
    public List<TestrayAttachment> getTestrayAttachments() {
        List<TestrayAttachment> testrayAttachments = super.getTestrayAttachments();
        testrayAttachments.add(this.getFailureMessagesTestrayAttachment());
        testrayAttachments.addAll(this.getLiferayLogTestrayAttachments());
        testrayAttachments.addAll(this.getLiferayOSGiLogTestrayAttachments());
        testrayAttachments.removeAll(Collections.singleton(null));
        return testrayAttachments;
    }

    protected TestrayAttachment getFailureMessagesTestrayAttachment() {
        List<TestClassResult> testClassResults = this.getTestClassResults();
        if (testClassResults == null || testClassResults.isEmpty()) {
            return null;
        }
        TestrayAttachment testrayAttachment = this.getTestrayAttachment(this.getBuild(), "Failure Messages", this.getAxisBuildURLPath() + "/" + this.getName() + ".txt.gz");
        if (testrayAttachment == null) {
            return null;
        }
        return testrayAttachment;
    }

    @Override
    protected List<TestrayAttachment> getLiferayLogTestrayAttachments() {
        List<TestClassResult> testClassResults = this.getTestClassResults();
        if (testClassResults == null || testClassResults.isEmpty()) {
            return new ArrayList<TestrayAttachment>();
        }
        return super.getLiferayLogTestrayAttachments();
    }

    @Override
    protected List<TestrayAttachment> getLiferayOSGiLogTestrayAttachments() {
        List<TestClassResult> testClassResults = this.getTestClassResults();
        if (testClassResults == null || testClassResults.isEmpty()) {
            return new ArrayList<TestrayAttachment>();
        }
        return super.getLiferayOSGiLogTestrayAttachments();
    }

    protected List<TestClassResult> getTestClassResults() {
        if (this._testClassResults != null) {
            return this._testClassResults;
        }
        Build build = this.getBuild();
        if (build == null) {
            return null;
        }
        this._testClassResults = new ArrayList<TestClassResult>();
        block0: for (TestClassResult testClassResult : build.getTestClassResults()) {
            String testClassName = testClassResult.getClassName();
            if (testClassName.equals(this.getName()) || testClassName.startsWith(this.getName() + "$")) {
                this._testClassResults.add(testClassResult);
                continue;
            }
            if (!testClassName.equals("junit.framework.TestSuite")) continue;
            for (TestResult testResult : testClassResult.getTestResults()) {
                String testName = testResult.getTestName();
                if (!testName.equals(this.getName())) continue;
                this._testClassResults.add(testClassResult);
                continue block0;
            }
        }
        return this._testClassResults;
    }

    protected List<TestResult> getTestResults() {
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (TestClassResult testClassResult : this.getTestClassResults()) {
            String testClassName = testClassResult.getClassName();
            if (!testClassName.equals("junit.framework.TestSuite")) {
                testResults.addAll(testClassResult.getTestResults());
                continue;
            }
            for (TestResult testResult : testClassResult.getTestResults()) {
                String testName = testResult.getTestName();
                if (!testName.equals(this.getName())) continue;
                testResults.add(testResult);
            }
        }
        return testResults;
    }

    private boolean _isTestClassResultsFailing() {
        for (TestClassResult testClassResult : this.getTestClassResults()) {
            if (!testClassResult.isFailing()) continue;
            return true;
        }
        return false;
    }

    private boolean _isTestClassResultsSkipped() {
        for (TestClassResult testClassResult : this.getTestClassResults()) {
            if (!testClassResult.isSkipped()) continue;
            return true;
        }
        return false;
    }
}

