/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.test.clazz.PlaywrightJUnitTestClass;
import com.liferay.jenkins.results.parser.test.clazz.PlaywrightTestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.testray.BatchBuildTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import java.util.Collections;
import java.util.List;

public class PlaywrightBatchBuildTestrayCaseResult
extends BatchBuildTestrayCaseResult {
    private final PlaywrightJUnitTestClass _playwrightJUnitTestClass;
    private final PlaywrightTestClassMethod _playwrightTestClassMethod;

    public PlaywrightBatchBuildTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild, AxisTestClassGroup axisTestClassGroup, TestClass testClass, TestClassMethod testClassMethod) {
        super(testrayBuild, topLevelBuild, axisTestClassGroup);
        this._playwrightJUnitTestClass = (PlaywrightJUnitTestClass)testClass;
        this._playwrightTestClassMethod = (PlaywrightTestClassMethod)testClassMethod;
    }

    @Override
    public String getComponentName() {
        String componentName = this._playwrightJUnitTestClass.getTestrayMainComponentName();
        if (JenkinsResultsParserUtil.isNullOrEmpty(componentName)) {
            return super.getComponentName();
        }
        return componentName;
    }

    @Override
    public long getDuration() {
        return this.getTestResultDuration();
    }

    @Override
    public String getErrors() {
        return this.getTestResultErrors();
    }

    @Override
    public String getName() {
        if (this._playwrightJUnitTestClass == null) {
            return super.getName();
        }
        return this._playwrightTestClassMethod.getName();
    }

    @Override
    public TestrayCaseResult.Status getStatus() {
        return this.getTestResultStatus();
    }

    @Override
    public List<TestrayAttachment> getTestrayAttachments() {
        List<TestrayAttachment> testrayAttachments = super.getTestrayAttachments();
        testrayAttachments.add(this.getPlaywrightReportTestrayAttachment());
        testrayAttachments.removeAll(Collections.singleton(null));
        return testrayAttachments;
    }

    @Override
    public TestResult getTestResult() {
        Build build = this.getBuild();
        if (build == null) {
            return null;
        }
        TestClassResult testClassResult = build.getTestClassResult(this._playwrightJUnitTestClass.getSpecFilePath());
        if (testClassResult == null) {
            return null;
        }
        for (TestResult testResult : testClassResult.getTestResults()) {
            String fullTestName = JenkinsResultsParserUtil.combine(testClassResult.getClassName(), " > ", testResult.getTestName());
            if (!fullTestName.equals(this.getName())) continue;
            return testResult;
        }
        System.out.println("Unable to find test result for: " + this.getName());
        return null;
    }

    protected TestrayAttachment getPlaywrightReportTestrayAttachment() {
        return this.getTestrayAttachment(this.getBuild(), "Playwright Report", this.getAxisBuildURLPath() + "/playwright-report/index.html");
    }
}

