/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.testray.BatchBuildTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import java.io.IOException;

public class PortalLogBatchBuildTestrayCaseResult
extends BatchBuildTestrayCaseResult {
    private TestClassResult _testClassResult;

    public PortalLogBatchBuildTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild, AxisTestClassGroup axisTestClassGroup) {
        super(testrayBuild, topLevelBuild, axisTestClassGroup);
    }

    @Override
    public String getComponentName() {
        try {
            return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.component");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public long getDuration() {
        TestClassResult testClassResult = this._getTestClassResult();
        if (testClassResult == null) {
            return 0L;
        }
        return testClassResult.getDuration();
    }

    @Override
    public String getErrors() {
        TestClassResult testClassResult = this._getTestClassResult();
        if (testClassResult == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (TestResult testResult : testClassResult.getTestResults()) {
            if (!testResult.isFailing()) continue;
            sb.append("PortalLogAssertorTest#");
            sb.append(testResult.getTestName());
            sb.append(": ");
            String errorDetails = testResult.getErrorDetails();
            if (JenkinsResultsParserUtil.isNullOrEmpty(errorDetails)) {
                sb.append("Failed for unknown reason | ");
                continue;
            }
            errorDetails = errorDetails.replace("Portal log assert failure, see above log for more information:", "");
            if ((errorDetails = errorDetails.trim()).length() > 1000) {
                errorDetails = errorDetails.substring(0, 1000);
                errorDetails = errorDetails + "...";
            }
            sb.append(errorDetails);
            sb.append(" | ");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 3);
            return sb.toString();
        }
        return null;
    }

    @Override
    public String getName() {
        return "PortalLogAssertorTest-" + this.getAxisName();
    }

    private TestClassResult _getTestClassResult() {
        if (this._testClassResult != null) {
            return this._testClassResult;
        }
        Build build = this.getBuild();
        if (build == null || !build.isFailing()) {
            return null;
        }
        String result = build.getResult();
        if (result == null) {
            return null;
        }
        for (TestClassResult testClassResult : build.getTestClassResults()) {
            String className = testClassResult.getClassName();
            if (!className.equals("com.liferay.portal.log.assertor.PortalLogAssertorTest")) continue;
            this._testClassResult = testClassResult;
            return this._testClassResult;
        }
        return null;
    }
}

