/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.test.clazz.SemVerModulesTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.testray.BatchBuildTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemVerModulesBatchBuildTestrayCaseResult
extends BatchBuildTestrayCaseResult {
    private static final String _TEST_CLASS_NAME = "com.liferay.semantic.versioning.SemanticVersioningTest";
    private static final Pattern _modulePathPattern = Pattern.compile("testSemanticVersioning\\[(?<modulePath>[\\w\\/-]+)\\]");
    private final SemVerModulesTestClass _semVerModulesTestClass;
    private List<TestResult> _testResults;

    public SemVerModulesBatchBuildTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild, AxisTestClassGroup axisTestClassGroup, TestClass testClass) {
        super(testrayBuild, topLevelBuild, axisTestClassGroup);
        this._semVerModulesTestClass = (SemVerModulesTestClass)testClass;
    }

    @Override
    public String getComponentName() {
        String componentName = this._semVerModulesTestClass.getTestrayMainComponentName();
        if (JenkinsResultsParserUtil.isNullOrEmpty(componentName)) {
            return super.getComponentName();
        }
        return componentName;
    }

    @Override
    public long getDuration() {
        List<TestResult> testResults = this.getTestResults();
        if (testResults.isEmpty()) {
            return super.getDuration();
        }
        long duration = 0L;
        for (TestResult testResult : testResults) {
            duration += testResult.getDuration();
        }
        return duration;
    }

    @Override
    public String getErrors() {
        List<TestResult> testResults = this.getTestResults();
        Build build = this.getBuild();
        if (testResults.isEmpty()) {
            if (build == null) {
                return "Unable to run build on CI";
            }
            String result = build.getResult();
            if (result == null) {
                return "Unable to finish build on CI";
            }
            if (result.equals("ABORTED")) {
                return build.getJobName() + " timed out after 2 hours";
            }
            if (result.equals("SUCCESS") || result.equals("UNSTABLE")) {
                return "Unable to run test on CI";
            }
            return "Failed prior to running test";
        }
        StringBuilder sb = new StringBuilder();
        for (TestResult testResult : testResults) {
            if (!testResult.isFailing()) continue;
            sb.append(testResult.getTestName());
            sb.append(": ");
            sb.append(testResult.getErrorDetails());
            sb.append("\n");
        }
        if (sb.length() == 0) {
            return null;
        }
        sb.setLength(sb.length() - 1);
        String errorMessage = sb.toString();
        if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage)) {
            errorMessage = build.getFailureMessage();
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage)) {
            return "Failed for unknown reason";
        }
        if (errorMessage.contains("\n")) {
            errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n"));
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage = errorMessage.trim())) {
            return "Failed for unknown reason";
        }
        return errorMessage;
    }

    @Override
    public String getName() {
        if (this._semVerModulesTestClass == null) {
            return super.getName();
        }
        return this.getBatchName() + "[" + this._semVerModulesTestClass.getName() + "]";
    }

    @Override
    public TestrayCaseResult.Status getStatus() {
        Build build = this.getBuild();
        if (build == null) {
            return TestrayCaseResult.Status.UNTESTED;
        }
        List<TestResult> testResults = this.getTestResults();
        if (testResults.isEmpty()) {
            String result = build.getResult();
            if (result == null || result.equals("SUCCESS") || result.equals("UNSTABLE")) {
                return TestrayCaseResult.Status.UNTESTED;
            }
            return TestrayCaseResult.Status.FAILED;
        }
        for (TestResult testResult : testResults) {
            if (!testResult.isFailing()) continue;
            return TestrayCaseResult.Status.FAILED;
        }
        return TestrayCaseResult.Status.PASSED;
    }

    public List<TestResult> getTestResults() {
        if (this._testResults != null) {
            return this._testResults;
        }
        this._testResults = new ArrayList<TestResult>();
        Build build = this.getBuild();
        if (build == null) {
            return this._testResults;
        }
        TestClassResult testClassResult = build.getTestClassResult(_TEST_CLASS_NAME);
        if (testClassResult == null) {
            return this._testResults;
        }
        for (TestResult testResult : testClassResult.getTestResults()) {
            String modulePath;
            Matcher matcher = _modulePathPattern.matcher(testResult.getTestName());
            if (!matcher.find() || !(modulePath = matcher.group("modulePath")).startsWith(this._getModulePath())) continue;
            this._testResults.add(testResult);
        }
        return this._testResults;
    }

    private String _getModulePath() {
        String modulePath = this._semVerModulesTestClass.getName();
        if (modulePath.startsWith("modules")) {
            modulePath = modulePath.substring(7);
        }
        return modulePath;
    }
}

