/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildReportFactory;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.DownstreamBuild;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.TopLevelBuildReport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.json.JSONObject;

public class TestrayAttachmentRecorder {
    private static final Pattern _bundlesDirNamePattern = Pattern.compile("bundles(?<bundlesSuffix>.*)");
    private final Build _build;
    private PortalGitWorkingDirectory _portalGitWorkingDirectory;
    private GitWorkingDirectory _qaWebsitesGitWorkingDirectory;
    private boolean _recorded;
    private final Properties _startProperties;

    public void record() {
        if (this._recorded) {
            return;
        }
        JenkinsResultsParserUtil.delete(this.getRecordedFilesBaseDir());
        try {
            this._recordJenkinsConsole();
            if (this._build instanceof TopLevelBuild) {
                this._recordBuildReport();
                this._recordJobSummary();
                this._recordJenkinsReport();
            } else {
                this._recordDockerLogs();
                this._recordFailureMessages();
                this._recordGCLogs();
                this._recordGradlePluginsFiles();
                this._recordJStacks();
                this._recordLiferayLogs();
                this._recordLiferayOSGiLogs();
                this._recordPlaywrightReportFile();
                this._recordPoshiReportFiles();
                this._recordWarnings();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Unable to record attachments for: " + this._build.getBuildURL());
            illegalArgumentException.printStackTrace();
        }
        this._recorded = true;
    }

    protected TestrayAttachmentRecorder(Build build) {
        if (build == null) {
            throw new RuntimeException("Please set a build");
        }
        this._build = build;
        BuildDatabase buildDatabase = build.getBuildDatabase();
        String jobVariant = build.getParameterValue("JOB_VARIANT");
        jobVariant = jobVariant == null ? "" : jobVariant + "/";
        this._startProperties = buildDatabase.getProperties(jobVariant + "start.properties");
    }

    protected File getRecordedFilesBaseDir() {
        String workspace = System.getenv("WORKSPACE");
        if (JenkinsResultsParserUtil.isNullOrEmpty(workspace)) {
            throw new RuntimeException("Please set WORKSPACE");
        }
        return new File(workspace, "testray/recorded_logs");
    }

    protected String getRelativeBuildDirPath() {
        StringBuilder sb = new StringBuilder();
        Date topLevelStartDate = new Date(Long.parseLong(this._startProperties.getProperty("TOP_LEVEL_START_TIME")));
        sb.append(JenkinsResultsParserUtil.toDateString(topLevelStartDate, "yyyy-MM", "America/Los_Angeles"));
        sb.append("/");
        sb.append(this._startProperties.getProperty("TOP_LEVEL_MASTER_HOSTNAME"));
        sb.append("/");
        sb.append(this._startProperties.getProperty("TOP_LEVEL_JOB_NAME"));
        sb.append("/");
        sb.append(this._startProperties.getProperty("TOP_LEVEL_BUILD_NUMBER"));
        sb.append("/");
        if (!(this._build instanceof TopLevelBuild)) {
            sb.append(this._build.getJobVariant());
            if (this._build instanceof AxisBuild) {
                AxisBuild axisBuild = (AxisBuild)this._build;
                sb.append("/");
                sb.append(axisBuild.getAxisNumber());
            } else if (this._build instanceof DownstreamBuild) {
                DownstreamBuild downstreamBuild = (DownstreamBuild)this._build;
                sb.append("/");
                sb.append(downstreamBuild.getAxisVariable());
            }
        }
        return sb.toString();
    }

    private void _copyToRecordedFilesBuildDir(File sourceFile) {
        if (!sourceFile.exists()) {
            return;
        }
        try {
            JenkinsResultsParserUtil.copy(sourceFile, new File(this._getRecordedFilesBuildDir(), sourceFile.getName()));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private List<File> _getLiferayBundlesDirs() {
        ArrayList<File> liferayBundlesDirs = new ArrayList<File>();
        PortalGitWorkingDirectory portalGitWorkingDirectory = this._getPortalGitWorkingDirectory();
        if (portalGitWorkingDirectory == null) {
            return liferayBundlesDirs;
        }
        Properties appServerProperties = portalGitWorkingDirectory.getAppServerProperties();
        File appServerParentDir = new File(JenkinsResultsParserUtil.getProperty(appServerProperties, "app.server.parent.dir"));
        for (File siblingFile : JenkinsResultsParserUtil.findSiblingFiles(appServerParentDir, true)) {
            String siblingFileName;
            Matcher matcher;
            if (!siblingFile.isDirectory() || !(matcher = _bundlesDirNamePattern.matcher(siblingFileName = siblingFile.getName())).find()) continue;
            liferayBundlesDirs.add(siblingFile);
        }
        return liferayBundlesDirs;
    }

    private int _getLiferayLogMaxSize() {
        int liferayLogMaxSizeInMB = 10;
        try {
            liferayLogMaxSizeInMB = Integer.parseInt(JenkinsResultsParserUtil.getBuildProperty("testray.liferay.log.max.size.in.mb"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return liferayLogMaxSizeInMB * 1024 * 1024;
    }

    private PortalGitWorkingDirectory _getPortalGitWorkingDirectory() {
        if (this._portalGitWorkingDirectory != null) {
            return this._portalGitWorkingDirectory;
        }
        String portalUpstreamBranchName = this._startProperties.getProperty("PORTAL_UPSTREAM_BRANCH_NAME");
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalUpstreamBranchName)) {
            return null;
        }
        this._portalGitWorkingDirectory = GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(portalUpstreamBranchName);
        return this._portalGitWorkingDirectory;
    }

    private List<String> _getPortalLogWarnings() {
        ArrayList<String> portalLogWarnings = new ArrayList<String>();
        if (this._build == null) {
            return portalLogWarnings;
        }
        TestClassResult testClassResult = this._build.getTestClassResult("com.liferay.portal.log.assertor.PortalLogAssertorTest");
        if (testClassResult == null) {
            return portalLogWarnings;
        }
        for (TestResult testResult : testClassResult.getTestResults()) {
            String errorDetails = testResult.getErrorDetails();
            if (JenkinsResultsParserUtil.isNullOrEmpty(errorDetails)) continue;
            portalLogWarnings.add(errorDetails);
        }
        return portalLogWarnings;
    }

    private List<String> _getPoshiWarnings() {
        ArrayList<String> poshiWarnings = new ArrayList<String>();
        PortalGitWorkingDirectory portalGitWorkingDirectory = this._getPortalGitWorkingDirectory();
        if (portalGitWorkingDirectory == null) {
            return poshiWarnings;
        }
        File poshiWarningsFile = new File(portalGitWorkingDirectory.getWorkingDirectory(), "poshi-warnings.xml");
        if (!poshiWarningsFile.exists()) {
            return poshiWarnings;
        }
        String content = null;
        try {
            content = JenkinsResultsParserUtil.read(poshiWarningsFile);
            content = content.trim();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(content)) {
            return poshiWarnings;
        }
        try {
            Document document = Dom4JUtil.parse("<html>" + content + "</html>");
            Element rootElement = document.getRootElement();
            for (Element valueElement : rootElement.elements()) {
                String valueElementText = valueElement.getText();
                if (JenkinsResultsParserUtil.isNullOrEmpty(valueElementText = valueElementText.trim())) continue;
                poshiWarnings.add(valueElementText);
            }
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
        return poshiWarnings;
    }

    private GitWorkingDirectory _getQAWebsitesGitWorkingDirectory() {
        Properties buildProperties;
        if (this._qaWebsitesGitWorkingDirectory != null) {
            return this._qaWebsitesGitWorkingDirectory;
        }
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String upstreamBranchName = "master";
        String upstreamDirPath = JenkinsResultsParserUtil.getProperty(buildProperties, "qa.websites.dir", upstreamBranchName);
        String upstreamRepository = JenkinsResultsParserUtil.getProperty(buildProperties, "qa.websites.repository", upstreamBranchName);
        this._qaWebsitesGitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(upstreamBranchName, upstreamDirPath, upstreamRepository);
        return this._qaWebsitesGitWorkingDirectory;
    }

    private File _getRecordedFilesBuildDir() {
        return new File(this.getRecordedFilesBaseDir(), this.getRelativeBuildDirPath());
    }

    private void _recordBuildReport() {
        if (!(this._build instanceof TopLevelBuild)) {
            return;
        }
        TopLevelBuild topLevelBuild = (TopLevelBuild)this._build;
        TopLevelBuildReport topLevelBuildReport = BuildReportFactory.newTopLevelBuildReport(topLevelBuild);
        JSONObject buildReportJSONObject = topLevelBuildReport.getBuildReportJSONObject();
        File buildReportJSONObjectFile = new File(this._getRecordedFilesBuildDir(), "build-report.json");
        try {
            JenkinsResultsParserUtil.write(buildReportJSONObjectFile, buildReportJSONObject.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private void _recordDockerLogs() {
        File sourceDockerLogsDir = new File(System.getenv("BUILD_DIR"), "docker-logs");
        if (!sourceDockerLogsDir.exists()) {
            return;
        }
        File destinationDockerLogsDir = new File(this._getRecordedFilesBuildDir(), "docker-logs");
        for (File sourceDockerLogFile : sourceDockerLogsDir.listFiles()) {
            try {
                JenkinsResultsParserUtil.copy(sourceDockerLogFile, new File(destinationDockerLogsDir, sourceDockerLogFile.getName() + ".txt"));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
    }

    private void _recordFailureMessages() {
        String batchName = null;
        if (this._build instanceof AxisBuild) {
            AxisBuild axisBuild = (AxisBuild)this._build;
            batchName = axisBuild.getBatchName();
        } else if (this._build instanceof DownstreamBuild) {
            DownstreamBuild downstreamBuild = (DownstreamBuild)this._build;
            batchName = downstreamBuild.getBatchName();
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(batchName)) {
            return;
        }
        if (!(batchName.startsWith("integration-") || batchName.startsWith("modules-integration-") || batchName.startsWith("modules-unit-") || batchName.startsWith("unit-"))) {
            return;
        }
        File testResultsFile = new File(System.getenv("WORKSPACE"), "test-results/TESTS-TestSuites.xml");
        if (!testResultsFile.exists()) {
            return;
        }
        try {
            Document document = Dom4JUtil.parse(JenkinsResultsParserUtil.read(testResultsFile));
            Element rootElement = document.getRootElement();
            TreeMap<String, ArrayList<Element>> testcaseElementsMap = new TreeMap<String, ArrayList<Element>>();
            for (Element element : rootElement.elements("testsuite")) {
                for (Element testcaseElement : element.elements("testcase")) {
                    ArrayList<Element> testcaseElements;
                    if (testcaseElement.element("failure") == null) continue;
                    String testClassName = testcaseElement.attributeValue("classname");
                    if (testClassName.contains("$")) {
                        testClassName = testClassName.substring(0, testClassName.indexOf("$"));
                    }
                    if ((testcaseElements = (ArrayList<Element>)testcaseElementsMap.get(testClassName)) == null) {
                        testcaseElements = new ArrayList<Element>();
                        testcaseElementsMap.put(testClassName, testcaseElements);
                    }
                    testcaseElements.add(testcaseElement);
                }
            }
            for (Map.Entry entry : testcaseElementsMap.entrySet()) {
                StringBuilder sb = new StringBuilder();
                List testcaseElements = (List)entry.getValue();
                for (Element testcaseElement : testcaseElements) {
                    sb.append("##\n## ");
                    sb.append(testcaseElement.attributeValue("classname"));
                    sb.append(" > ");
                    sb.append(testcaseElement.attributeValue("name"));
                    sb.append("\n##\n\n");
                    Element failureElement = testcaseElement.element("failure");
                    if (failureElement == null) {
                        sb.append("\tFailed for unknown reason\n\n");
                        continue;
                    }
                    String failedElementText = failureElement.getText();
                    for (String line : failedElementText.split("\n")) {
                        sb.append("\t");
                        sb.append(line);
                        sb.append("\n");
                    }
                    sb.append("\n\n");
                }
                if (sb.length() <= 0) continue;
                JenkinsResultsParserUtil.write(new File(this._getRecordedFilesBuildDir(), (String)entry.getKey() + ".txt"), sb.toString());
            }
        }
        catch (IOException | DocumentException throwable) {
            // empty catch block
        }
    }

    private void _recordGCLogs() {
        File sourceGCLogsDir = new File(System.getenv("BUILD_DIR"), "gc");
        if (!sourceGCLogsDir.exists()) {
            return;
        }
        File destinationGCLogsDir = new File(this._getRecordedFilesBuildDir(), "gc");
        for (File sourceGCLogFile : sourceGCLogsDir.listFiles()) {
            try {
                JenkinsResultsParserUtil.copy(sourceGCLogFile, new File(destinationGCLogsDir, sourceGCLogFile.getName() + ".txt"));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
    }

    private void _recordGradlePluginsFiles() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this._getPortalGitWorkingDirectory();
        File gradlePluginsFile = new File(portalGitWorkingDirectory.getWorkingDirectory(), "tmp/gradle_plugins.tar");
        if (!gradlePluginsFile.exists()) {
            return;
        }
        try {
            JenkinsResultsParserUtil.copy(gradlePluginsFile, new File(this._getRecordedFilesBuildDir(), "gradle_plugins.tar"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private void _recordJenkinsConsole() {
        File jenkinsConsoleFile = new File(this._getRecordedFilesBuildDir(), "jenkins-console.txt");
        try {
            JenkinsResultsParserUtil.write(jenkinsConsoleFile, this._build.getConsoleText());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private void _recordJenkinsReport() {
        if (!(this._build instanceof TopLevelBuild)) {
            return;
        }
        TopLevelBuild topLevelBuild = (TopLevelBuild)this._build;
        Element jenkinsReportElement = topLevelBuild.getJenkinsReportElement();
        File jenkinsReportFile = new File(this._getRecordedFilesBuildDir(), "jenkins-report.html");
        try {
            JenkinsResultsParserUtil.write(jenkinsReportFile, StringEscapeUtils.unescapeXml((String)Dom4JUtil.format(jenkinsReportElement, true)));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private void _recordJobSummary() {
        if (!(this._build instanceof TopLevelBuild)) {
            return;
        }
        TopLevelBuild topLevelBuild = (TopLevelBuild)this._build;
        File jobSummaryFile = new File(topLevelBuild.getJobSummaryDir(), "index.html");
        if (!jobSummaryFile.exists()) {
            return;
        }
        try {
            JenkinsResultsParserUtil.copy(jobSummaryFile, new File(this._getRecordedFilesBuildDir(), "job-summary/index.html"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private void _recordJStacks() {
        File sourceJStacksDir = new File(System.getenv("BUILD_DIR"), "jstacks");
        if (!sourceJStacksDir.exists()) {
            return;
        }
        File destinationJStacksDir = new File(this._getRecordedFilesBuildDir(), "jstacks");
        for (File sourceJStackFile : sourceJStacksDir.listFiles()) {
            try {
                JenkinsResultsParserUtil.copy(sourceJStackFile, new File(destinationJStacksDir, sourceJStackFile.getName() + ".txt"));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
    }

    private void _recordLiferayLogs() {
        for (File liferayBundlesDir : this._getLiferayBundlesDirs()) {
            Matcher matcher;
            File liferayLogsDir = new File(liferayBundlesDir, "logs");
            if (!liferayLogsDir.exists()) continue;
            StringBuilder sb = new StringBuilder();
            for (File liferayLogFile : JenkinsResultsParserUtil.findFiles(liferayLogsDir, "liferay\\..*\\.log")) {
                try {
                    sb.append(JenkinsResultsParserUtil.read(liferayLogFile));
                    sb.append("\n");
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
            int liferayLogMaxSizeInMB = this._getLiferayLogMaxSize();
            if (sb.length() > liferayLogMaxSizeInMB) {
                sb.setLength(liferayLogMaxSizeInMB);
            }
            if (!(matcher = _bundlesDirNamePattern.matcher(liferayBundlesDir.getName())).find()) continue;
            File liferayLogFile = new File(this._getRecordedFilesBuildDir(), JenkinsResultsParserUtil.combine("liferay-log", matcher.group("bundlesSuffix"), ".txt"));
            try {
                JenkinsResultsParserUtil.write(liferayLogFile, sb.toString());
            }
            catch (IOException iOException) {}
        }
    }

    private void _recordLiferayOSGiLogs() {
        for (File liferayBundlesDir : this._getLiferayBundlesDirs()) {
            Matcher matcher;
            File liferayOSGiStateDir = new File(liferayBundlesDir, "osgi/state");
            if (!liferayOSGiStateDir.exists()) continue;
            StringBuilder sb = new StringBuilder();
            for (File liferayOSGiLogFile : JenkinsResultsParserUtil.findFiles(liferayOSGiStateDir.getParentFile(), ".*\\.log")) {
                try {
                    sb.append(JenkinsResultsParserUtil.read(liferayOSGiLogFile));
                    sb.append("\n");
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
            int liferayLogMaxSize = this._getLiferayLogMaxSize();
            if (sb.length() > liferayLogMaxSize) {
                sb.setLength(liferayLogMaxSize);
            }
            String liferayOSGiLogFileContent = sb.toString();
            if ((liferayOSGiLogFileContent = liferayOSGiLogFileContent.trim()).length() == 0 || !(matcher = _bundlesDirNamePattern.matcher(liferayBundlesDir.getName())).find()) continue;
            File liferayOSGiLogFile = new File(this._getRecordedFilesBuildDir(), JenkinsResultsParserUtil.combine("liferay-osgi-log", matcher.group("bundlesSuffix"), ".txt"));
            try {
                JenkinsResultsParserUtil.write(liferayOSGiLogFile, liferayOSGiLogFileContent);
            }
            catch (IOException iOException) {}
        }
    }

    private void _recordPlaywrightReportFile() {
        File playwrightReportFile;
        File playwrightReportFile2;
        PortalGitWorkingDirectory portalGitWorkingDirectory = this._getPortalGitWorkingDirectory();
        if (portalGitWorkingDirectory != null && (playwrightReportFile2 = new File(portalGitWorkingDirectory.getWorkingDirectory(), "modules/test/playwright/playwright-report/index.html")).exists()) {
            this._copyToRecordedFilesBuildDir(playwrightReportFile2.getParentFile());
            return;
        }
        GitWorkingDirectory qaWebsitesGitWorkingDirectory = this._getQAWebsitesGitWorkingDirectory();
        if (qaWebsitesGitWorkingDirectory != null && (playwrightReportFile = new File(qaWebsitesGitWorkingDirectory.getWorkingDirectory(), "playwright/playwright-report/index.html")).exists()) {
            this._copyToRecordedFilesBuildDir(playwrightReportFile.getParentFile());
        }
    }

    private void _recordPoshiReportFiles() {
        GitWorkingDirectory qaWebsitesGitWorkingDirectory;
        PortalGitWorkingDirectory portalGitWorkingDirectory = this._getPortalGitWorkingDirectory();
        ArrayList<File> testResultsDirs = new ArrayList<File>();
        if (portalGitWorkingDirectory != null) {
            File workspaceTestResultsDir;
            File testResultsDir = new File(portalGitWorkingDirectory.getWorkingDirectory(), "portal-web/test-results");
            if (testResultsDir.exists()) {
                testResultsDirs.add(testResultsDir);
            }
            if ((workspaceTestResultsDir = new File(portalGitWorkingDirectory.getWorkingDirectory(), JenkinsResultsParserUtil.combine("workspaces/", System.getenv("TEST_WORKSPACE_NAME"), "/poshi/test-results"))).exists()) {
                testResultsDirs.add(workspaceTestResultsDir);
            }
        }
        if (testResultsDirs.isEmpty() && (qaWebsitesGitWorkingDirectory = this._getQAWebsitesGitWorkingDirectory()) != null) {
            testResultsDirs.addAll(JenkinsResultsParserUtil.findDirs(qaWebsitesGitWorkingDirectory.getWorkingDirectory(), "test-results"));
        }
        if (testResultsDirs.isEmpty()) {
            return;
        }
        for (File testResultsDir : testResultsDirs) {
            List<File> poshiReportIndexFiles = JenkinsResultsParserUtil.findFiles(testResultsDir, "index.html");
            for (File poshiReportIndexFile : poshiReportIndexFiles) {
                File sourcePoshiReportDir = poshiReportIndexFile.getParentFile();
                File poshiReportDir = new File(this._getRecordedFilesBuildDir(), sourcePoshiReportDir.getName());
                try {
                    JenkinsResultsParserUtil.copy(sourcePoshiReportDir, poshiReportDir);
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
                File indexFile = new File(poshiReportDir, "index.html");
                if (!indexFile.exists()) continue;
                try {
                    String content = JenkinsResultsParserUtil.read(indexFile);
                    for (File poshiReportJPGFile : JenkinsResultsParserUtil.findFiles(poshiReportDir, ".*\\.jpg")) {
                        String poshiReportJPGFileName = poshiReportJPGFile.getName();
                        if (content.contains("/" + poshiReportJPGFileName)) continue;
                        System.out.println("Removing unreferenced file " + poshiReportJPGFile);
                        JenkinsResultsParserUtil.delete(poshiReportJPGFile);
                    }
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
        }
    }

    private void _recordWarnings() {
        ArrayList<String> warnings = new ArrayList<String>();
        warnings.addAll(this._getPortalLogWarnings());
        warnings.addAll(this._getPoshiWarnings());
        if (warnings.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n");
        for (String warning : warnings) {
            sb.append("<pre>");
            sb.append(StringEscapeUtils.escapeHtml((String)warning));
            sb.append("</pre>\n");
        }
        sb.append("</html>");
        try {
            JenkinsResultsParserUtil.write(new File(this._getRecordedFilesBuildDir(), "warnings.html"), sb.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

