/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.BuildReportFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuildReport;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayCase;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayCaseType;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TestrayProductVersion;
import com.liferay.jenkins.results.parser.testray.TestrayProject;
import com.liferay.jenkins.results.parser.testray.TestrayRoutine;
import com.liferay.jenkins.results.parser.testray.TestrayRun;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class TestrayBuild
implements Comparable<TestrayBuild> {
    public static final String[] FIELD_NAMES = new String[]{"dateCreated", "dateModified", "description", "dueDate", "dueStatus {key name}", "githubCompareURLs", "gitHash", "id", "name", "productVersionToBuilds", "projectToBuilds", "routineToBuilds"};
    private static final Pattern _portalBranchPattern = Pattern.compile("Portal Branch: (?<portalBranch>[^;]+);");
    private static final Pattern _testrayAttachmentURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("https://.+/(?<startYearMonth>\\d{4}-\\d{2})/", "(?<topLevelMasterHostname>test-\\d+-\\d+)/", "(?<topLevelJobName>[^/]+)/(?<topLevelBuildNumber>\\d+)/.*"));
    private final JSONObject _jsonObject;
    private String _pullRequestSenderUsername;
    private Matcher _testrayAttachmentURLMatcher;
    private TestrayProductVersion _testrayProductVersion;
    private TestrayProject _testrayProject;
    private TestrayRoutine _testrayRoutine;
    private List<TestrayRun> _testrayRuns;
    private final TestrayServer _testrayServer;
    private TopLevelBuildReport _topLevelBuildReport;
    private TestrayCaseResult _topLevelTestrayCaseResult;

    @Override
    public int compareTo(TestrayBuild testrayBuild) {
        if (testrayBuild == null) {
            throw new NullPointerException("Testray build is null");
        }
        Long id = testrayBuild.getID();
        return id.compareTo(this.getID());
    }

    public String getDescription() {
        return this._jsonObject.optString("description");
    }

    public Date getDueDate() {
        String dueDateString = this._jsonObject.optString("dueDate");
        if (JenkinsResultsParserUtil.isNullOrEmpty(dueDateString)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
        try {
            return simpleDateFormat.parse(dueDateString);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public long getID() {
        return this._jsonObject.getLong("id");
    }

    public JSONObject getJSONObject() {
        return this._jsonObject;
    }

    public String getName() {
        return this._jsonObject.getString("name");
    }

    public String getPortalBranch() {
        Matcher matcher = _portalBranchPattern.matcher(this.getDescription());
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("portalBranch");
    }

    public String getPortalSHA() {
        return this._jsonObject.getString("gitHash");
    }

    public String getPullRequestSenderUsername() {
        if (!JenkinsResultsParserUtil.isNullOrEmpty(this._pullRequestSenderUsername)) {
            return this._pullRequestSenderUsername;
        }
        URL topLevelBuildURL = this.getTopLevelBuildURL();
        if (topLevelBuildURL == null) {
            this._pullRequestSenderUsername = "Unknown";
            return this._pullRequestSenderUsername;
        }
        try {
            TopLevelBuildReport topLevelBuildReport = BuildReportFactory.newTopLevelBuildReport(topLevelBuildURL);
            Map<String, String> buildParameters = topLevelBuildReport.getBuildParameters();
            this._pullRequestSenderUsername = buildParameters.get("GITHUB_SENDER_USERNAME");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._pullRequestSenderUsername = "Unknown";
        }
        return this._pullRequestSenderUsername;
    }

    public String getStartYearMonth() {
        Matcher matcher = this._getTestrayAttachmentURLMatcher();
        if (matcher == null) {
            return null;
        }
        return matcher.group("startYearMonth");
    }

    public TestrayCaseResult getTestrayCaseResultByName(String testCaseName) {
        TestrayCase testrayCase = this._testrayProject.getTestrayCaseByName(testCaseName);
        StringBuilder sb = new StringBuilder();
        sb.append("r_buildToCaseResult_c_buildId eq '");
        sb.append(this.getID());
        sb.append("' and r_caseToCaseResult_c_caseId eq '");
        sb.append(testrayCase.getID());
        sb.append("'");
        try {
            List<JSONObject> entityJSONObjects = this._testrayServer.requestGraphQL("caseResults", TestrayCaseResult.FIELD_NAMES, sb.toString(), null, 1L, 1);
            if (entityJSONObjects.isEmpty()) {
                return null;
            }
            return TestrayFactory.newTestrayCaseResult(this, entityJSONObjects.get(0));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public List<TestrayCaseResult> getTestrayCaseResults() {
        return this.getTestrayCaseResults(null, null);
    }

    public List<TestrayCaseResult> getTestrayCaseResults(TestrayCaseType testrayCaseType, TestrayRun testrayRun) {
        ArrayList<TestrayCaseResult> testrayCaseResults = new ArrayList<TestrayCaseResult>();
        StringBuilder sb = new StringBuilder();
        if (testrayRun != null && testrayRun.getID() > 0L) {
            sb.append("r_runToCaseResult_c_runId eq '");
            sb.append(testrayRun.getID());
            sb.append("' and ");
        }
        sb.append("r_buildToCaseResult_c_buildId eq '");
        sb.append(this.getID());
        sb.append("'");
        try {
            List<JSONObject> entityJSONObjects = this._testrayServer.requestGraphQL(true, "caseResults", TestrayCaseResult.FIELD_NAMES, sb.toString(), null, 0L, 1000);
            for (JSONObject entityJSONObject : entityJSONObjects) {
                TestrayCaseResult testrayCaseResult = TestrayFactory.newTestrayCaseResult(this, entityJSONObject);
                TestrayCase testrayCase = testrayCaseResult.getTestrayCase();
                if (testrayCaseType != null) {
                    if (!Objects.equals(testrayCaseType.getID(), testrayCase.getTestrayCaseTypeID())) continue;
                    testrayCaseResults.add(testrayCaseResult);
                    continue;
                }
                testrayCaseResults.add(testrayCaseResult);
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return testrayCaseResults;
    }

    public TestrayProductVersion getTestrayProductVersion() {
        if (this._testrayProductVersion != null || !this._jsonObject.has("productVersionToBuilds")) {
            return this._testrayProductVersion;
        }
        JSONObject productVersionJSONObject = this._jsonObject.getJSONObject("productVersionToBuilds");
        this._testrayProductVersion = this._testrayProject.getTestrayProductVersionByID(productVersionJSONObject.getLong("id"));
        return this._testrayProductVersion;
    }

    public TestrayProject getTestrayProject() {
        return this._testrayProject;
    }

    public TestrayRoutine getTestrayRoutine() {
        return this._testrayRoutine;
    }

    public synchronized List<TestrayRun> getTestrayRuns() {
        if (this._testrayRuns != null) {
            return this._testrayRuns;
        }
        this._testrayRuns = new ArrayList<TestrayRun>();
        StringBuilder sb = new StringBuilder();
        sb.append("/o/c/builds/");
        sb.append(this.getID());
        sb.append("/buildToRuns?pageSize=100");
        try {
            JSONObject responseJSONObject = new JSONObject(this._testrayServer.requestGet(sb.toString()));
            JSONArray itemsJSONArray = responseJSONObject.getJSONArray("items");
            for (int i = 0; i < itemsJSONArray.length(); ++i) {
                JSONObject itemJSONObject = itemsJSONArray.getJSONObject(i);
                this._testrayRuns.add(TestrayFactory.newTestrayRun(this, itemJSONObject));
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return this._testrayRuns;
    }

    public TestrayServer getTestrayServer() {
        return this._testrayServer;
    }

    public TopLevelBuildReport getTopLevelBuildReport() {
        if (this._topLevelBuildReport != null) {
            return this._topLevelBuildReport;
        }
        URL topLevelBuildReportURL = this.getTopLevelBuildReportURL();
        if (topLevelBuildReportURL == null) {
            return null;
        }
        this._topLevelBuildReport = BuildReportFactory.newTopLevelBuildReport(this);
        return this._topLevelBuildReport;
    }

    public URL getTopLevelBuildReportURL() {
        Matcher matcher = this._getTestrayAttachmentURLMatcher();
        if (matcher == null) {
            return null;
        }
        try {
            URL url = new URL(JenkinsResultsParserUtil.combine("http://", matcher.group("topLevelMasterHostname"), "/userContent/jobs/", matcher.group("topLevelJobName"), "/builds/", matcher.group("topLevelBuildNumber"), "/build-report.json.gz"));
            if (JenkinsResultsParserUtil.exists(url)) {
                return url;
            }
            url = new URL(matcher.group());
            if (JenkinsResultsParserUtil.exists(url)) {
                return url;
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public URL getTopLevelBuildURL() {
        Matcher matcher = this._getTestrayAttachmentURLMatcher();
        if (matcher == null) {
            return null;
        }
        try {
            return new URL(JenkinsResultsParserUtil.combine("https://", matcher.group("topLevelMasterHostname"), ".liferay.com/job/", matcher.group("topLevelJobName"), "/", matcher.group("topLevelBuildNumber"), "/"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public TestrayCaseResult getTopLevelTestrayCaseResult() {
        if (this._topLevelTestrayCaseResult != null) {
            return this._topLevelTestrayCaseResult;
        }
        this._topLevelTestrayCaseResult = this.getTestrayCaseResultByName("Top Level Build");
        return this._topLevelTestrayCaseResult;
    }

    public URL getURL() {
        try {
            return new URL(JenkinsResultsParserUtil.combine(String.valueOf(this._testrayRoutine.getURL()), "/build/", String.valueOf(this.getID())));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    protected TestrayBuild(TestrayRoutine testrayRoutine, JSONObject jsonObject) {
        this._testrayRoutine = testrayRoutine;
        this._testrayProject = testrayRoutine.getTestrayProject();
        this._testrayServer = testrayRoutine.getTestrayServer();
        this._jsonObject = jsonObject;
    }

    protected TestrayBuild(TestrayServer testrayServer, JSONObject jsonObject) {
        this._testrayServer = testrayServer;
        this._jsonObject = jsonObject;
    }

    protected List<TestrayCaseResult> getTestrayCaseResults(int maxCount) {
        ArrayList<TestrayCaseResult> testrayCaseResults = new ArrayList<TestrayCaseResult>();
        StringBuilder sb = new StringBuilder();
        sb.append("r_buildToCaseResult_c_buildId eq '");
        sb.append(this.getID());
        sb.append("'");
        try {
            List<JSONObject> entityJSONObjects = this._testrayServer.requestGraphQL("caseResults", TestrayCaseResult.FIELD_NAMES, sb.toString(), null, maxCount, 0);
            for (JSONObject entityJSONObject : entityJSONObjects) {
                testrayCaseResults.add(TestrayFactory.newTestrayCaseResult(this, entityJSONObject));
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return testrayCaseResults;
    }

    private Matcher _getTestrayAttachmentURLMatcher() {
        if (this._testrayAttachmentURLMatcher != null) {
            return this._testrayAttachmentURLMatcher;
        }
        for (TestrayCaseResult testrayCaseResult : this.getTestrayCaseResults(5)) {
            if (testrayCaseResult == null) continue;
            for (TestrayAttachment testrayAttachment : testrayCaseResult.getTestrayAttachments()) {
                Matcher testrayAttachmentURLMatcher = _testrayAttachmentURLPattern.matcher(String.valueOf(testrayAttachment.getURL()));
                if (!testrayAttachmentURLMatcher.find()) continue;
                this._testrayAttachmentURLMatcher = testrayAttachmentURLMatcher;
                return this._testrayAttachmentURLMatcher;
            }
        }
        return null;
    }
}

