/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCase;
import com.liferay.jenkins.results.parser.testray.TestrayComponent;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TestrayProject;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import com.liferay.jenkins.results.parser.testray.TestrayTeam;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TestrayCaseResult {
    public static final String[] FIELD_NAMES = new String[]{"attachments", "buildToCaseResult", "caseToCaseResult", "componentToCaseResult", "dateCreated", "dateModified", "dueStatus { key name }", "errors", "id", "startDate"};
    protected Map<String, TestrayAttachment> testrayAttachments;
    private static final String[] _DID_NOT_RUN_ERRORS = new String[]{"Aborted prior to running test", "Failed prior to running test", "Failed for unknown reason", "timed out after 2 hours"};
    private static final double _MAX_JARO_WINKLER_DISTANCE = 0.8;
    private ErrorType _errorType;
    private final JSONObject _jsonObject;
    private TestrayBuild _testrayBuild;
    private TestrayCase _testrayCase;
    private TestrayComponent _testrayComponent;
    private final TestrayServer _testrayServer;
    private TopLevelBuild _topLevelBuild;

    public TestrayAttachment getBuildResultTestrayAttachment() {
        this.initTestrayAttachments();
        return this.testrayAttachments.get("Build Result (Top Level)");
    }

    public String getCaseID() {
        TestrayComponent testrayComponent = this.getTestrayComponent();
        if (testrayComponent == null) {
            return null;
        }
        return String.valueOf(testrayComponent.getID());
    }

    public String getComponentName() {
        TestrayComponent testrayComponent = this.getTestrayComponent();
        if (testrayComponent == null) {
            return null;
        }
        return testrayComponent.getName();
    }

    public long getDuration() {
        return this._jsonObject.optLong("duration");
    }

    public String getErrors() {
        return this._jsonObject.optString("errors");
    }

    public ErrorType getErrorType() {
        if (this._errorType != null) {
            return this._errorType;
        }
        for (String didNotRunErrors : _DID_NOT_RUN_ERRORS) {
            String errors = this.getErrors();
            if (!errors.contains(didNotRunErrors)) continue;
            this._errorType = ErrorType.DID_NOT_RUN;
            return this._errorType;
        }
        for (TestrayCaseResult previousTestrayCaseResult : this.getTestrayCaseResultHistory(5)) {
            if (Objects.equals(this.getID(), previousTestrayCaseResult.getID()) || !this._isSimilarError(previousTestrayCaseResult) || Objects.equals(this.getPullRequestSenderUsername(), previousTestrayCaseResult.getPullRequestSenderUsername())) continue;
            this._errorType = ErrorType.COMMON;
            return this._errorType;
        }
        this._errorType = ErrorType.UNIQUE;
        return this._errorType;
    }

    public URL getHistoryURL() {
        try {
            return new URL(this.getURL() + "/history");
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public long getID() {
        return this._jsonObject.optLong("id");
    }

    public JSONObject getJSONObject() {
        return this._jsonObject;
    }

    public String getName() {
        TestrayCase testrayCase = this.getTestrayCase();
        if (testrayCase == null) {
            return null;
        }
        return testrayCase.getName();
    }

    public int getPriority() {
        TestrayCase testrayCase = this.getTestrayCase();
        if (testrayCase == null) {
            return 0;
        }
        return testrayCase.getPriority();
    }

    public String getPullRequestSenderUsername() {
        TestrayBuild testrayBuild = this.getTestrayBuild();
        return testrayBuild.getPullRequestSenderUsername();
    }

    public Status getStatus() {
        JSONObject dueStatusJSONObject = this._jsonObject.getJSONObject("dueStatus");
        return Status.valueOf(dueStatusJSONObject.getString("key"));
    }

    public String getSubcomponentNames() {
        return "";
    }

    public String getTeamName() {
        if (this._testrayComponent == null) {
            return null;
        }
        TestrayTeam testrayTeam = this._testrayComponent.getTestrayTeam();
        return testrayTeam.getName();
    }

    public List<TestrayAttachment> getTestrayAttachments() {
        this.initTestrayAttachments();
        return new ArrayList<TestrayAttachment>(this.testrayAttachments.values());
    }

    public TestrayBuild getTestrayBuild() {
        if (this._testrayBuild != null) {
            return this._testrayBuild;
        }
        JSONObject buildJSONObject = this._jsonObject.getJSONObject("buildToCaseResult");
        if (buildJSONObject != null) {
            this._testrayBuild = this._testrayServer.getTestrayBuildByID(buildJSONObject.getLong("id"));
        }
        return this._testrayBuild;
    }

    public TestrayCase getTestrayCase() {
        if (this._testrayCase != null) {
            return this._testrayCase;
        }
        JSONObject caseJSONObject = this._jsonObject.optJSONObject("caseToCaseResult");
        if (caseJSONObject != null) {
            TestrayBuild testrayBuild = this.getTestrayBuild();
            this._testrayCase = TestrayFactory.newTestrayCase(testrayBuild.getTestrayProject(), caseJSONObject);
        }
        return this._testrayCase;
    }

    public List<TestrayCaseResult> getTestrayCaseResultHistory(int maxCount) {
        ArrayList<TestrayCaseResult> testrayCaseResults = new ArrayList<TestrayCaseResult>();
        StringBuilder sb = new StringBuilder();
        TestrayCase testrayCase = this.getTestrayCase();
        sb.append("r_caseToCaseResult_c_caseId eq '");
        sb.append(testrayCase.getID());
        sb.append("'");
        TestrayServer testrayServer = this.getTestrayServer();
        try {
            List<JSONObject> entityJSONObjects = testrayServer.requestGraphQL("caseResults", FIELD_NAMES, sb.toString(), "dateCreated:desc", maxCount, 5);
            for (JSONObject entityJSONObject : entityJSONObjects) {
                testrayCaseResults.add(TestrayFactory.newTestrayCaseResult(testrayServer, entityJSONObject));
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return testrayCaseResults;
    }

    public TestrayComponent getTestrayComponent() {
        if (this._testrayComponent != null) {
            return this._testrayComponent;
        }
        JSONObject componentJSONObject = this._jsonObject.optJSONObject("componentToCaseResult");
        if (componentJSONObject != null) {
            TestrayBuild testrayBuild = this.getTestrayBuild();
            TestrayProject testrayProject = testrayBuild.getTestrayProject();
            this._testrayComponent = testrayProject.getTestrayComponentByID(componentJSONObject.getLong("id"));
        }
        return this._testrayComponent;
    }

    public TestrayProject getTestrayProject() {
        TestrayBuild testrayBuild = this.getTestrayBuild();
        return testrayBuild.getTestrayProject();
    }

    public TestrayServer getTestrayServer() {
        return this._testrayServer;
    }

    public TopLevelBuild getTopLevelBuild() {
        return this._topLevelBuild;
    }

    public String getType() {
        TestrayCase testrayCase = this.getTestrayCase();
        if (testrayCase == null) {
            return null;
        }
        return testrayCase.getType();
    }

    public URL getURL() {
        TestrayBuild testrayBuild = this.getTestrayBuild();
        try {
            return new URL(testrayBuild.getURL() + "/case-result/" + this.getID());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public String[] getWarnings() {
        return null;
    }

    protected TestrayCaseResult(TestrayBuild testrayBuild, JSONObject jsonObject) {
        this._testrayBuild = testrayBuild;
        this._jsonObject = jsonObject;
        this._testrayServer = testrayBuild.getTestrayServer();
    }

    protected TestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild) {
        this._testrayBuild = testrayBuild;
        this._topLevelBuild = topLevelBuild;
        this._testrayServer = testrayBuild.getTestrayServer();
        this._jsonObject = new JSONObject();
    }

    protected TestrayCaseResult(TestrayServer testrayServer, JSONObject jsonObject) {
        this._testrayServer = testrayServer;
        this._jsonObject = jsonObject;
    }

    protected synchronized void initTestrayAttachments() {
        JSONArray attachmentsJSONArray;
        if (this.testrayAttachments != null) {
            return;
        }
        this.testrayAttachments = new TreeMap<String, TestrayAttachment>();
        String attachments = this._jsonObject.getString("attachments");
        try {
            attachmentsJSONArray = new JSONArray(attachments);
        }
        catch (JSONException jsonException) {
            return;
        }
        for (int i = 0; i < attachmentsJSONArray.length(); ++i) {
            URL url;
            JSONObject attachmentJSONObject = attachmentsJSONArray.getJSONObject(i);
            try {
                url = new URL(attachmentJSONObject.getString("url"));
            }
            catch (MalformedURLException malformedURLException) {
                url = null;
            }
            TestrayAttachment testrayAttachment = TestrayFactory.newTestrayAttachment(this, attachmentJSONObject.getString("name"), attachmentJSONObject.getString("value"), url);
            this.testrayAttachments.put(testrayAttachment.getName(), testrayAttachment);
        }
    }

    private boolean _isSimilarError(TestrayCaseResult previousTestrayCaseResult) {
        String thisErrors = this.getErrors();
        String previousErrors = previousTestrayCaseResult.getErrors();
        try {
            double jaroWinklerDistance = StringUtils.getJaroWinklerDistance((CharSequence)thisErrors, (CharSequence)previousErrors);
            return jaroWinklerDistance > 0.8;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Objects.equals(thisErrors, previousErrors);
        }
    }

    public static enum Status {
        BLOCKED(4, "blocked"),
        DIDNOTRUN(6, "dnr"),
        FAILED(3, "failed"),
        INPROGRESS(1, "in-progress"),
        PASSED(2, "passed"),
        TESTFIX(7, "test-fix"),
        UNTESTED(1, "untested");

        private static Map<Integer, Status> _statuses;
        private final Integer _id;
        private final String _name;

        public static Status get(Integer id) {
            return _statuses.get(id);
        }

        public static List<Status> getFailedStatuses() {
            return Arrays.asList(BLOCKED, DIDNOTRUN, FAILED, INPROGRESS, TESTFIX, UNTESTED);
        }

        public Integer getID() {
            return this._id;
        }

        public String getName() {
            return this._name;
        }

        private Status(Integer id, String name) {
            this._id = id;
            this._name = name;
        }

        static {
            _statuses = new HashMap<Integer, Status>();
            for (Status status : Status.values()) {
                _statuses.put(status.getID(), status);
            }
        }
    }

    public static enum ErrorType {
        COMMON("Common"),
        DID_NOT_RUN("Did not run"),
        UNIQUE("Unique");

        private final String _name;

        public String toString() {
            return this._name;
        }

        private ErrorType(String name) {
            this._name = name;
        }
    }
}

