/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.TestrayCase;
import com.liferay.jenkins.results.parser.testray.TestrayComponent;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TestrayProductVersion;
import com.liferay.jenkins.results.parser.testray.TestrayRoutine;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import com.liferay.jenkins.results.parser.testray.TestrayTeam;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.JSONObject;

public class TestrayProject {
    public static final String[] FIELD_NAMES = new String[]{"dateCreated", "dateModified", "description", "id", "name"};
    private final JSONObject _jsonObject;
    private Map<String, TestrayCase> _testrayCases;
    private List<TestrayComponent> _testrayComponents;
    private final TestrayServer _testrayServer;
    private List<TestrayTeam> _testrayTeams;

    public TestrayProductVersion createTestrayProductVersion(String testrayProductVersionName) {
        TestrayProductVersion testrayProductVersion = this.getTestrayProductVersionByName(testrayProductVersionName);
        if (testrayProductVersion != null) {
            return testrayProductVersion;
        }
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("name", (Object)testrayProductVersionName).put("r_projectToProductVersions_c_projectId", this.getID());
        try {
            return TestrayFactory.newTestrayProductVersion(this, new JSONObject(this._testrayServer.requestPost("/o/c/productversions", requestJSONObject.toString())));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public TestrayRoutine createTestrayRoutine(String testrayRoutineName) {
        TestrayRoutine testrayRoutine = this.getTestrayRoutineByName(testrayRoutineName);
        if (testrayRoutine != null) {
            return testrayRoutine;
        }
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("name", (Object)testrayRoutineName).put("r_routineToProjects_c_projectId", this.getID());
        try {
            return TestrayFactory.newTestrayRoutine(this, new JSONObject(this._testrayServer.requestPost("/o/c/routines", requestJSONObject.toString())));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public String getDescription() {
        return this._jsonObject.optString("description");
    }

    public long getID() {
        return this._jsonObject.getLong("id");
    }

    public JSONObject getJSONObject() {
        return this._jsonObject;
    }

    public String getName() {
        return this._jsonObject.getString("name");
    }

    public TestrayCase getTestrayCaseByName(String testCaseName) {
        this._initTestrayCases();
        return this._testrayCases.get(testCaseName);
    }

    public List<TestrayCase> getTestrayCases() {
        this._initTestrayCases();
        return new ArrayList<TestrayCase>(this._testrayCases.values());
    }

    public TestrayComponent getTestrayComponentByID(long componentID) {
        for (TestrayComponent testrayComponent : this.getTestrayComponents()) {
            if (!Objects.equals(componentID, testrayComponent.getID())) continue;
            return testrayComponent;
        }
        return null;
    }

    public TestrayComponent getTestrayComponentByName(String componentName) {
        for (TestrayComponent testrayComponent : this.getTestrayComponents()) {
            if (!Objects.equals(componentName, testrayComponent.getName())) continue;
            return testrayComponent;
        }
        return null;
    }

    public List<TestrayComponent> getTestrayComponents() {
        if (this._testrayComponents != null) {
            return this._testrayComponents;
        }
        this._testrayComponents = new ArrayList<TestrayComponent>();
        String filter = JenkinsResultsParserUtil.combine("r_projectToComponents_c_projectId eq '", String.valueOf(this.getID()), "'");
        try {
            List<JSONObject> entityJSONObjects = this._testrayServer.requestGraphQL("components", TestrayComponent.FIELD_NAMES, filter, null);
            for (JSONObject entityJSONObject : entityJSONObjects) {
                this._testrayComponents.add(TestrayFactory.newTestrayComponent(this, entityJSONObject));
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return this._testrayComponents;
    }

    public TestrayProductVersion getTestrayProductVersionByID(long productVersionID) {
        String filter = JenkinsResultsParserUtil.combine("id eq '", String.valueOf(productVersionID), "' and ", "r_projectToProductVersions_c_projectId eq '", String.valueOf(this.getID()), "'");
        try {
            List<JSONObject> entityJSONObjects = this._testrayServer.requestGraphQL("productVersions", TestrayProductVersion.FIELD_NAMES, filter, null, 1L, 1);
            if (entityJSONObjects.isEmpty()) {
                return null;
            }
            return TestrayFactory.newTestrayProductVersion(this, entityJSONObjects.get(0));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public TestrayProductVersion getTestrayProductVersionByName(String productVersionName) {
        String filter = JenkinsResultsParserUtil.combine("name eq '", productVersionName, "' and ", "r_projectToProductVersions_c_projectId eq '", String.valueOf(this.getID()), "'");
        try {
            List<JSONObject> entityJSONObjects = this._testrayServer.requestGraphQL("productVersions", TestrayProductVersion.FIELD_NAMES, filter, null, 1L, 1);
            if (entityJSONObjects.isEmpty()) {
                return null;
            }
            return TestrayFactory.newTestrayProductVersion(this, entityJSONObjects.get(0));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public TestrayRoutine getTestrayRoutineByID(long routineID) {
        TestrayRoutine testrayRoutine = this._testrayServer.getTestrayRoutineByID(routineID);
        if (testrayRoutine != null) {
            return testrayRoutine;
        }
        String filter = JenkinsResultsParserUtil.combine("id eq '", String.valueOf(routineID), "'");
        try {
            List<JSONObject> entityJSONObjects = this._testrayServer.requestGraphQL("routines", TestrayRoutine.FIELD_NAMES, filter, null, 1L, 1);
            if (entityJSONObjects.isEmpty()) {
                return null;
            }
            return TestrayFactory.newTestrayRoutine(this, entityJSONObjects.get(0));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public TestrayRoutine getTestrayRoutineByName(String routineName) {
        String filter = JenkinsResultsParserUtil.combine("name eq '", routineName, "' and ", "r_routineToProjects_c_projectId eq '", String.valueOf(this.getID()), "'");
        try {
            List<JSONObject> entityJSONObjects = this._testrayServer.requestGraphQL("routines", TestrayRoutine.FIELD_NAMES, filter, null, 1L, 1);
            if (entityJSONObjects.isEmpty()) {
                return null;
            }
            return TestrayFactory.newTestrayRoutine(this, entityJSONObjects.get(0));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public TestrayServer getTestrayServer() {
        return this._testrayServer;
    }

    public TestrayTeam getTestrayTeamByID(long componentID) {
        for (TestrayTeam testrayTeam : this.getTestrayTeams()) {
            if (componentID != testrayTeam.getID()) continue;
            return testrayTeam;
        }
        return null;
    }

    public TestrayTeam getTestrayTeamByName(String teamName) {
        for (TestrayTeam testrayTeam : this.getTestrayTeams()) {
            if (!Objects.equals(teamName, testrayTeam.getName())) continue;
            return testrayTeam;
        }
        return null;
    }

    public List<TestrayTeam> getTestrayTeams() {
        if (this._testrayTeams != null) {
            return this._testrayTeams;
        }
        this._testrayTeams = new ArrayList<TestrayTeam>();
        String filter = JenkinsResultsParserUtil.combine("r_projectToTeams_c_projectId eq '", String.valueOf(this.getID()), "'");
        try {
            List<JSONObject> entityJSONObjects = this._testrayServer.requestGraphQL("teams", TestrayTeam.FIELD_NAMES, filter, null);
            for (JSONObject entityJSONObject : entityJSONObjects) {
                this._testrayTeams.add(TestrayFactory.newTestrayTeam(this, entityJSONObject));
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return this._testrayTeams;
    }

    public URL getURL() {
        try {
            return new URL(JenkinsResultsParserUtil.combine(String.valueOf(this._testrayServer.getURL()), "/#/project/", String.valueOf(this.getID()), "/routines"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    protected TestrayProject(TestrayServer testrayServer, JSONObject jsonObject) {
        this._testrayServer = testrayServer;
        this._jsonObject = jsonObject;
    }

    private synchronized void _initTestrayCases() {
        if (this._testrayCases != null) {
            return;
        }
        this._testrayCases = new HashMap<String, TestrayCase>();
        String filter = JenkinsResultsParserUtil.combine("r_projectToCases_c_projectId eq '", String.valueOf(this.getID()), "'");
        try {
            List<JSONObject> entityJSONObjects = this._testrayServer.requestGraphQL("cases", TestrayCase.FIELD_NAMES, filter, null);
            for (JSONObject entityJSONObject : entityJSONObjects) {
                TestrayCase testrayCase = TestrayFactory.newTestrayCase(this, entityJSONObject);
                this._testrayCases.put(testrayCase.getName(), testrayCase);
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

