/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TestrayProductVersion;
import com.liferay.jenkins.results.parser.testray.TestrayProject;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class TestrayRoutine {
    public static final String[] FIELD_NAMES = new String[]{"dateCreated", "dateModified", "id", "name", "routineToProjects"};
    protected URL url;
    private static final Pattern _testrayRoutineURLPattern = Pattern.compile("(?<serverURL>https://[^/]+)/#/project/(?<projectID>\\d+)/routines/(?<routineID>\\d+)");
    private JSONObject _jsonObject;
    private TestrayProject _testrayProject;
    private TestrayServer _testrayServer;

    public TestrayBuild createTestrayBuild(TestrayProductVersion testrayProductVersion, String buildName) {
        TestrayBuild testrayBuild = this.getTestrayBuildByName(buildName, new String[0]);
        if (testrayBuild != null) {
            return testrayBuild;
        }
        return this.createTestrayBuild(testrayProductVersion, buildName, null, null, null);
    }

    public TestrayBuild createTestrayBuild(TestrayProductVersion testrayProductVersion, String buildName, Date buildDate, String buildDescription, String buildSHA) {
        TestrayBuild testrayBuild = this.getTestrayBuildByName(buildName, new String[0]);
        if (testrayBuild != null) {
            return testrayBuild;
        }
        JSONObject requestJSONObject = new JSONObject();
        if (buildDate == null) {
            buildDate = new Date();
        }
        if (buildDescription != null && buildDescription.length() >= 280) {
            buildDescription = buildDescription.substring(0, 280);
        }
        requestJSONObject.put("description", (Object)buildDescription).put("dueDate", (Object)JenkinsResultsParserUtil.toDateString(buildDate, "yyy-MM-dd'T'HH:mm:ss.SSS'Z'", "America/Los_Angeles")).put("dueStatus", (Object)"ACTIVATED").put("gitHash", (Object)buildSHA).put("name", (Object)buildName).put("r_productVersionToBuilds_c_productVersionId", testrayProductVersion.getID()).put("r_projectToBuilds_c_projectId", this._testrayProject.getID()).put("r_routineToBuilds_c_routineId", this.getID());
        try {
            JSONObject responseJSONObject = new JSONObject(this._testrayServer.requestPost("/o/c/builds", requestJSONObject.toString()));
            return this.getTestrayBuildByID(responseJSONObject.getLong("id"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(requestJSONObject.toString(), ioException);
        }
    }

    public long getID() {
        return this._jsonObject.getLong("id");
    }

    public JSONObject getJSONObject() {
        return this._jsonObject;
    }

    public String getName() {
        return this._jsonObject.getString("name");
    }

    public TestrayBuild getTestrayBuildByID(long buildID) {
        TestrayBuild testrayBuild = this._testrayServer.getTestrayBuildByID(buildID);
        if (testrayBuild != null) {
            return testrayBuild;
        }
        String filter = JenkinsResultsParserUtil.combine("id eq '", String.valueOf(buildID), "' and ", "r_routineToBuilds_c_routineId eq '", String.valueOf(this.getID()), "'");
        try {
            List<JSONObject> entityJSONObjects = this._testrayServer.requestGraphQL("builds", TestrayBuild.FIELD_NAMES, filter, null, 1L, 1);
            if (entityJSONObjects.isEmpty()) {
                return null;
            }
            return TestrayFactory.newTestrayBuild(this, entityJSONObjects.get(0));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public TestrayBuild getTestrayBuildByName(String buildName, String ... names) {
        String filter = JenkinsResultsParserUtil.combine("name eq '", buildName, "' and ", "r_routineToBuilds_c_routineId eq '", String.valueOf(this.getID()), "'");
        try {
            List<JSONObject> entityJSONObjects = this._testrayServer.requestGraphQL("builds", TestrayBuild.FIELD_NAMES, filter, null, 1L, 1);
            if (entityJSONObjects.isEmpty()) {
                return null;
            }
            return TestrayFactory.newTestrayBuild(this, entityJSONObjects.get(0));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public List<TestrayBuild> getTestrayBuilds() {
        return this.getTestrayBuilds(200, new String[0]);
    }

    public List<TestrayBuild> getTestrayBuilds(int maxSize, String ... nameFilters) {
        ArrayList<TestrayBuild> testrayBuilds = new ArrayList<TestrayBuild>();
        StringBuilder sb = new StringBuilder();
        sb.append("r_routineToBuilds_c_routineId eq '");
        sb.append(this.getID());
        sb.append("'");
        if (nameFilters != null && nameFilters.length > 0) {
            sb.append(" and (");
            for (int i = 0; i < nameFilters.length; ++i) {
                sb.append("contains(name, '");
                sb.append(nameFilters[i]);
                sb.append("')");
                if (i >= nameFilters.length - 1) continue;
                sb.append(" or ");
            }
            sb.append(")");
        }
        try {
            List<JSONObject> entityJSONObjects = this._testrayServer.requestGraphQL("builds", TestrayBuild.FIELD_NAMES, sb.toString(), "dateCreated:desc", maxSize, 0);
            for (JSONObject entityJSONObject : entityJSONObjects) {
                testrayBuilds.add(TestrayFactory.newTestrayBuild(this, entityJSONObject));
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return testrayBuilds;
    }

    public TestrayProject getTestrayProject() {
        if (this._testrayProject != null) {
            return this._testrayProject;
        }
        JSONObject projectJSONObject = this._jsonObject.getJSONObject("routineToProjects");
        this._testrayProject = this._testrayServer.getTestrayProjectByID(projectJSONObject.getLong("id"));
        return this._testrayProject;
    }

    public TestrayServer getTestrayServer() {
        return this._testrayServer;
    }

    public URL getURL() {
        if (this.url != null) {
            return this.url;
        }
        try {
            this.url = new URL(JenkinsResultsParserUtil.combine(String.valueOf(this._testrayProject.getURL()), "/", String.valueOf(this.getID())));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        return this.url;
    }

    public void setJSONObject(JSONObject jsonObject) {
        this._jsonObject = jsonObject;
    }

    protected TestrayRoutine(TestrayProject testrayProject, JSONObject jsonObject) {
        this._testrayProject = testrayProject;
        this._testrayServer = testrayProject.getTestrayServer();
        this._jsonObject = jsonObject;
    }

    protected TestrayRoutine(TestrayServer testrayServer, JSONObject jsonObject) {
        this._testrayServer = testrayServer;
        this._jsonObject = jsonObject;
    }

    protected TestrayRoutine(URL url) {
        this.setURL(url);
    }

    protected void setTestrayProject(TestrayProject testrayProject) {
        this._testrayProject = testrayProject;
    }

    protected void setTestrayServer(TestrayServer testrayServer) {
        this._testrayServer = testrayServer;
    }

    protected void setURL(URL url) {
        this.url = url;
        Matcher matcher = _testrayRoutineURLPattern.matcher(url.toString());
        if (!matcher.find()) {
            throw new RuntimeException("Invalid routine URL " + url);
        }
        TestrayServer testrayServer = TestrayFactory.newTestrayServer(matcher.group("serverURL"));
        this.setTestrayServer(testrayServer);
        String filter = JenkinsResultsParserUtil.combine("id eq '", matcher.group("routineID"), "'");
        try {
            List<JSONObject> entityJSONObjects = testrayServer.requestGraphQL("routines", FIELD_NAMES, filter, null, 1L, 1);
            if (entityJSONObjects.isEmpty()) {
                return;
            }
            this.setJSONObject(entityJSONObjects.get(0));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

