/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class TestrayRun {
    protected List<Factor> factors;
    private static final String _PROPERTY_KEY_FACTOR_NAME = "testray.environment.factor.name";
    private static final String _PROPERTY_KEY_FACTOR_VALUE = "testray.environment.factor.value";
    private static final Pattern _factorNamePattern = Pattern.compile("testray.environment.factor.name\\[(?<nameKey>[^\\]]+)\\]");
    private static final Pattern _factorValuePattern = Pattern.compile("testray.environment.factor.value\\[(?<nameKey>[^\\]]+)\\](\\[(?<valueKey>[^\\]]+)\\])?");
    private final JSONObject _jsonObject;
    private final Properties _properties = new Properties();
    private final TestrayBuild _testrayBuild;

    public List<Factor> getFactors() {
        return this.factors;
    }

    public long getID() {
        if (this._jsonObject == null) {
            return 0L;
        }
        return this._jsonObject.getLong("id");
    }

    public String getRunIDString() {
        if (this._jsonObject != null && this._jsonObject.has("name")) {
            return this._jsonObject.getString("name");
        }
        ArrayList<String> factorValues = new ArrayList<String>();
        for (Factor factor : this.getFactors()) {
            factorValues.add(factor.getValue());
        }
        return JenkinsResultsParserUtil.join("|", factorValues);
    }

    public TestrayBuild getTestrayBuild() {
        return this._testrayBuild;
    }

    protected TestrayRun(TestrayBuild testrayBuild, JSONObject jsonObject) {
        this._testrayBuild = testrayBuild;
        this._jsonObject = jsonObject;
        try {
            this._properties.putAll((Map<?, ?>)JenkinsResultsParserUtil.getBuildProperties());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        this.initializeFactorsByJSONObject(jsonObject);
    }

    protected TestrayRun(TestrayBuild testrayBuild, String batchName, List<File> propertiesFiles) {
        this._testrayBuild = testrayBuild;
        try {
            this._properties.putAll((Map<?, ?>)JenkinsResultsParserUtil.getBuildProperties());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        for (int i = propertiesFiles.size() - 1; i >= 0; --i) {
            this._properties.putAll((Map<?, ?>)JenkinsResultsParserUtil.getProperties(propertiesFiles.get(i)));
        }
        this.initializeFactorsByBatchName(batchName);
        JSONObject jsonObject = null;
        String runIDString = this.getRunIDString();
        for (TestrayRun testrayRun : testrayBuild.getTestrayRuns()) {
            String testrayRunIDString = testrayRun.getRunIDString();
            if (!Objects.equals(runIDString.toLowerCase(), testrayRunIDString.toLowerCase())) continue;
            jsonObject = testrayRun.getJSONObject();
            break;
        }
        this._jsonObject = jsonObject;
    }

    protected JSONObject getJSONObject() {
        return this._jsonObject;
    }

    protected Properties getProperties() {
        return this._properties;
    }

    protected void initializeFactorsByBatchName(String batchName) {
        this.factors = new ArrayList<Factor>();
        if (JenkinsResultsParserUtil.isNullOrEmpty(batchName)) {
            return;
        }
        for (String factorNameKey : this._getFactorNameKeys()) {
            String factoryName = this._getFactorName(factorNameKey);
            String factoryValue = this._getFactorValue(batchName, factorNameKey);
            if (JenkinsResultsParserUtil.isNullOrEmpty(factoryName) || JenkinsResultsParserUtil.isNullOrEmpty(factoryValue)) continue;
            this.factors.add(new Factor(factoryName, factoryValue));
        }
    }

    protected void initializeFactorsByJSONObject(JSONObject jsonObject) {
        this.factors = new ArrayList<Factor>();
        if (jsonObject == null) {
            return;
        }
        String runIDString = jsonObject.optString("name");
        if (JenkinsResultsParserUtil.isNullOrEmpty(runIDString)) {
            return;
        }
        block0: for (String factorValue : runIDString.split("\\|")) {
            for (String propertyName : this._properties.stringPropertyNames()) {
                Matcher factorValueMatcher = _factorValuePattern.matcher(propertyName);
                if (!factorValueMatcher.find() || !factorValue.equals(this._properties.getProperty(propertyName))) continue;
                String factorName = this._getFactorName(factorValueMatcher.group("nameKey"));
                this.factors.add(new Factor(factorName, factorValue));
                continue block0;
            }
        }
    }

    private String _getFactorName(String factorNameKey) {
        String factorName = JenkinsResultsParserUtil.getProperty(this._properties, JenkinsResultsParserUtil.combine(_PROPERTY_KEY_FACTOR_NAME, "[", factorNameKey, "]"));
        if (!JenkinsResultsParserUtil.isNullOrEmpty(factorName)) {
            return factorName;
        }
        return null;
    }

    private Set<String> _getFactorNameKeys() {
        TreeSet<String> factorNameKeys = new TreeSet<String>();
        for (String propertyName : this._properties.stringPropertyNames()) {
            Matcher matcher = _factorNamePattern.matcher(propertyName);
            if (!matcher.find()) continue;
            factorNameKeys.add(matcher.group("nameKey"));
        }
        return factorNameKeys;
    }

    private String _getFactorValue(String batchName, String factorNameKey) {
        String matchingValueKey = null;
        String matchingPropertyName = null;
        for (String propertyName : this._properties.stringPropertyNames()) {
            String valueKey;
            String nameKey;
            Matcher matcher = _factorValuePattern.matcher(propertyName);
            if (!matcher.find() || !(nameKey = matcher.group("nameKey")).equals(factorNameKey) || (valueKey = matcher.group("valueKey")) == null || !batchName.contains(valueKey) || matchingValueKey != null && valueKey.length() <= matchingValueKey.length()) continue;
            matchingValueKey = valueKey;
            matchingPropertyName = propertyName;
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(matchingPropertyName)) {
            return JenkinsResultsParserUtil.getProperty(this._properties, matchingPropertyName);
        }
        String factorValue = JenkinsResultsParserUtil.getProperty(this._properties, JenkinsResultsParserUtil.combine(_PROPERTY_KEY_FACTOR_VALUE, "[", factorNameKey, "]"));
        if (JenkinsResultsParserUtil.isNullOrEmpty(factorValue)) {
            return null;
        }
        return factorValue;
    }

    public static class Factor {
        private final String _name;
        private final String _value;

        public Factor(String name, String value) {
            this._name = name;
            this._value = value;
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this.getName() + "=" + this.getValue();
        }
    }
}

