/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.google.cloud.storage.Blob;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.TestrayS3Bucket;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class TestrayS3Object {
    private final Blob _blob;
    private final TestrayS3Bucket _testrayS3Bucket;
    private final URL _url;

    public void delete() {
        this._blob.delete(new Blob.BlobSourceOption[0]);
    }

    public void downloadTo(File file) {
        this.downloadTo(file, false);
    }

    public void downloadTo(File file, boolean replaceExisting) {
        if (replaceExisting || !file.exists()) {
            File parentDir = file.getParentFile();
            parentDir.mkdirs();
            System.out.println("Downloading " + this.getURL() + " to " + file);
            this._blob.downloadTo(file.toPath());
        }
    }

    public boolean exists() {
        return this._blob.exists(new Blob.BlobSourceOption[0]);
    }

    public String getKey() {
        return this._blob.getName();
    }

    public TestrayS3Bucket getTestrayS3Bucket() {
        return this._testrayS3Bucket;
    }

    public URL getURL() {
        return this._url;
    }

    public String getURLString() {
        return JenkinsResultsParserUtil.fixURL(String.valueOf(this._url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue() {
        String string;
        if (!this.exists()) {
            return null;
        }
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        try {
            string = new String(this._blob.getContent(new Blob.BlobSourceOption[0]), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
            System.out.println(JenkinsResultsParserUtil.combine(this.getURLString(), " in ", JenkinsResultsParserUtil.toDurationString(duration)));
            throw throwable;
        }
        long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
        System.out.println(JenkinsResultsParserUtil.combine(this.getURLString(), " in ", JenkinsResultsParserUtil.toDurationString(duration)));
        return string;
    }

    public String toString() {
        return this.getURLString();
    }

    protected TestrayS3Object(TestrayS3Bucket testrayS3Bucket, Blob blob) {
        this._testrayS3Bucket = testrayS3Bucket;
        this._blob = blob;
        try {
            this._url = new URL(JenkinsResultsParserUtil.combine(testrayS3Bucket.getTestrayS3BaseURL(), "/", this.getKey()));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }
}

