/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.NotificationUtil;
import com.liferay.jenkins.results.parser.TestrayResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseType;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TestrayProject;
import com.liferay.jenkins.results.parser.testray.TestrayRoutine;
import com.liferay.jenkins.results.parser.testray.TestrayS3Bucket;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.json.JSONObject;

public class TestrayServer {
    private static final int _MILLIS_REQUEST_TIMEOUT_DEFAULT = 60000;
    private static final Map<Long, TestrayBuild> _testrayBuilds = new HashMap<Long, TestrayBuild>();
    private static final Map<Long, TestrayProject> _testrayProjects = new HashMap<Long, TestrayProject>();
    private static final Map<Long, TestrayRoutine> _testrayRoutines = new HashMap<Long, TestrayRoutine>();
    private static final Pattern _urlPathPattern = Pattern.compile("/+(?<urlPath>.*)");
    private static final Pattern _urlPattern = Pattern.compile("(?<url>https?://.*)/+");
    private JenkinsResultsParserUtil.HTTPAuthorization _httpAuthorization;
    private final Map<Long, TestrayCaseType> _testrayCaseTypesID = new HashMap<Long, TestrayCaseType>();
    private final Map<String, TestrayCaseType> _testrayCaseTypesName = new HashMap<String, TestrayCaseType>();
    private final URL _url;

    public TestrayProject createTestrayProject(String projectName) {
        TestrayProject testrayProject = this.getTestrayProjectByName(projectName);
        if (testrayProject != null) {
            return testrayProject;
        }
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("name", (Object)projectName);
        try {
            JSONObject responseJSONObject = new JSONObject(this.requestPost("/o/c/projects", requestJSONObject.toString()));
            return this.getTestrayProjectByID(responseJSONObject.getLong("id"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(requestJSONObject.toString(), ioException);
        }
    }

    public JenkinsResultsParserUtil.HTTPAuthorization getHTTPAuthorization() {
        return this._httpAuthorization;
    }

    public TestrayBuild getTestrayBuildByID(long buildID) {
        if (_testrayBuilds.containsKey(buildID)) {
            return _testrayBuilds.get(buildID);
        }
        try {
            List<JSONObject> entityJSONObjects = this.requestGraphQL("builds", TestrayBuild.FIELD_NAMES, "id eq '" + buildID + "'", null, 1L, 1);
            if (entityJSONObjects.isEmpty()) {
                return null;
            }
            JSONObject entityJSONObject = entityJSONObjects.get(0);
            JSONObject projectJSONObject = entityJSONObject.getJSONObject("projectToBuilds");
            TestrayProject testrayProject = this.getTestrayProjectByID(projectJSONObject.getLong("id"));
            JSONObject routineJSONObject = entityJSONObject.getJSONObject("routineToBuilds");
            TestrayRoutine testrayRoutine = testrayProject.getTestrayRoutineByID(routineJSONObject.getLong("id"));
            TestrayBuild testrayBuild = TestrayFactory.newTestrayBuild(testrayRoutine, entityJSONObject);
            _testrayBuilds.put(testrayBuild.getID(), testrayBuild);
            return testrayBuild;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public TestrayCaseType getTestrayCaseTypeByID(long testrayCaseTypeID) {
        TestrayCaseType testrayCaseType = this._testrayCaseTypesID.get(testrayCaseTypeID);
        if (testrayCaseType != null) {
            return testrayCaseType;
        }
        try {
            List<JSONObject> entityJSONObjects = this.requestGraphQL("caseTypes", TestrayCaseType.FIELD_NAMES, "id eq '" + testrayCaseTypeID + "'", null, 1L, 1);
            if (entityJSONObjects.isEmpty()) {
                return null;
            }
            testrayCaseType = TestrayFactory.newTestrayCaseType(this, entityJSONObjects.get(0));
            this._testrayCaseTypesID.put(testrayCaseType.getID(), testrayCaseType);
            this._testrayCaseTypesName.put(testrayCaseType.getName(), testrayCaseType);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return this._testrayCaseTypesID.get(testrayCaseTypeID);
    }

    public TestrayCaseType getTestrayCaseTypeByName(String testrayCaseTypeName) {
        TestrayCaseType testrayCaseType = this._testrayCaseTypesName.get(testrayCaseTypeName);
        if (testrayCaseType != null) {
            return testrayCaseType;
        }
        try {
            List<JSONObject> entityJSONObjects = this.requestGraphQL("caseTypes", TestrayCaseType.FIELD_NAMES, "name eq '" + testrayCaseTypeName + "'", null, 1L, 1);
            if (entityJSONObjects.isEmpty()) {
                return null;
            }
            testrayCaseType = TestrayFactory.newTestrayCaseType(this, entityJSONObjects.get(0));
            this._testrayCaseTypesID.put(testrayCaseType.getID(), testrayCaseType);
            this._testrayCaseTypesName.put(testrayCaseType.getName(), testrayCaseType);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return this._testrayCaseTypesName.get(testrayCaseTypeName);
    }

    public TestrayProject getTestrayProjectByID(long projectID) {
        if (_testrayProjects.containsKey(projectID)) {
            return _testrayProjects.get(projectID);
        }
        try {
            List<JSONObject> entityJSONObjects = this.requestGraphQL("projects", TestrayProject.FIELD_NAMES, "id eq '" + projectID + "'", null, 1L, 1);
            if (entityJSONObjects.isEmpty()) {
                return null;
            }
            TestrayProject testrayProject = TestrayFactory.newTestrayProject(this, entityJSONObjects.get(0));
            _testrayProjects.put(testrayProject.getID(), testrayProject);
            return testrayProject;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public TestrayProject getTestrayProjectByName(String projectName) {
        for (TestrayProject testrayProject : _testrayProjects.values()) {
            if (!Objects.equals(testrayProject.getName(), projectName)) continue;
            return testrayProject;
        }
        try {
            TestrayProject testrayProject;
            List<JSONObject> entityJSONObjects = this.requestGraphQL("projects", TestrayProject.FIELD_NAMES, "name eq '" + projectName + "'", null, 1L, 1);
            if (entityJSONObjects.isEmpty()) {
                return null;
            }
            testrayProject = TestrayFactory.newTestrayProject(this, entityJSONObjects.get(0));
            _testrayProjects.put(testrayProject.getID(), testrayProject);
            return testrayProject;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public List<TestrayProject> getTestrayProjects() {
        ArrayList<TestrayProject> testrayProjects = new ArrayList<TestrayProject>();
        try {
            for (JSONObject entityJSONObject : this.requestGraphQL("projects", TestrayProject.FIELD_NAMES, null, null)) {
                TestrayProject testrayProject = TestrayFactory.newTestrayProject(this, entityJSONObject);
                _testrayProjects.put(testrayProject.getID(), testrayProject);
                testrayProjects.add(testrayProject);
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return testrayProjects;
    }

    public TestrayRoutine getTestrayRoutineByID(long routineId) {
        if (_testrayRoutines.containsKey(routineId)) {
            return _testrayRoutines.get(routineId);
        }
        try {
            List<JSONObject> entityJSONObjects = this.requestGraphQL("routines", TestrayRoutine.FIELD_NAMES, "id eq '" + routineId + "'", null, 1L, 1);
            if (entityJSONObjects.isEmpty()) {
                return null;
            }
            JSONObject entityJSONObject = entityJSONObjects.get(0);
            JSONObject projectJSONObject = entityJSONObject.getJSONObject("routineToProjects");
            TestrayProject testrayProject = this.getTestrayProjectByID(projectJSONObject.getLong("id"));
            TestrayRoutine testrayRoutine = TestrayFactory.newTestrayRoutine(testrayProject, entityJSONObject);
            _testrayRoutines.put(testrayRoutine.getID(), testrayRoutine);
            return testrayRoutine;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public URL getURL() {
        return this._url;
    }

    public void importCaseResults(TopLevelBuild topLevelBuild) {
        TestrayResultsParserUtil.processTestrayResultFiles(this.getResultsDir());
        if (TestrayS3Bucket.hasGoogleApplicationCredentials()) {
            this._importCaseResultsToGCP(topLevelBuild);
        }
    }

    public String requestGet(String urlPath) throws IOException {
        try {
            return JenkinsResultsParserUtil.toString(this.getTestrayURL(urlPath), true, 2, JenkinsResultsParserUtil.HttpRequestMethod.GET, null, 5, 60000, this.getHTTPAuthorization(), true);
        }
        catch (IOException ioException) {
            this._sendCommunicationFailureNotification(ioException.getMessage());
            throw ioException;
        }
    }

    public String requestPost(boolean checkCache, String urlPath, String requestData) throws IOException {
        try {
            return JenkinsResultsParserUtil.toString(this.getTestrayURL(urlPath), checkCache, 2, JenkinsResultsParserUtil.HttpRequestMethod.POST, requestData, 5, 60000, this.getHTTPAuthorization(), false);
        }
        catch (IOException ioException) {
            this._sendCommunicationFailureNotification(ioException.getMessage());
            throw ioException;
        }
    }

    public String requestPost(String urlPath, String requestData) throws IOException {
        return this.requestPost(false, urlPath, requestData);
    }

    public void setHTTPAuthorization(JenkinsResultsParserUtil.HTTPAuthorization httpAuthorization) {
        this._httpAuthorization = httpAuthorization;
    }

    public void writeCaseResult(String fileName, String fileContent) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(fileName) || JenkinsResultsParserUtil.isNullOrEmpty(fileContent)) {
            return;
        }
        try {
            JenkinsResultsParserUtil.write(new File(this.getResultsDir(), fileName), fileContent);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected TestrayServer(String urlString) {
        try {
            Matcher matcher = _urlPattern.matcher(urlString);
            if (matcher.find()) {
                urlString = matcher.group("url");
            }
            this._url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Invalid Testray server URL " + urlString, malformedURLException);
        }
    }

    protected File getResultsDir() {
        String workspace = System.getenv("WORKSPACE");
        if (JenkinsResultsParserUtil.isNullOrEmpty(workspace)) {
            throw new RuntimeException("Please set WORKSPACE");
        }
        return new File(workspace, "testray/results");
    }

    protected String getTestrayURL(String urlPath) {
        Matcher matcher = _urlPathPattern.matcher(urlPath);
        if (matcher.find()) {
            urlPath = matcher.group("urlPath");
        }
        return this.getURL() + "/" + urlPath;
    }

    /*
     * Exception decompiling
     */
    protected List<JSONObject> requestGraphQL(boolean checkCache, String entityName, String[] entityFields, String filter, String sort, long maxCount, int pageSize) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected List<JSONObject> requestGraphQL(String entityName, String[] entityFields, String filter, String sort) throws IOException {
        return this.requestGraphQL(entityName, entityFields, filter, sort, 0L, 0);
    }

    protected List<JSONObject> requestGraphQL(String entityName, String[] entityFields, String filter, String sort, long maxCount, int pageSize) throws IOException {
        return this.requestGraphQL(false, entityName, entityFields, filter, sort, maxCount, pageSize);
    }

    private void _importCaseResultsToGCP(TopLevelBuild topLevelBuild) {
        if (!TestrayS3Bucket.hasGoogleApplicationCredentials()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        JenkinsMaster jenkinsMaster = topLevelBuild.getJenkinsMaster();
        sb.append(jenkinsMaster.getName());
        sb.append("-");
        String jobName = topLevelBuild.getJobName();
        sb.append(jobName.replaceAll("[\\(\\)]", "_"));
        sb.append("-");
        sb.append(topLevelBuild.getBuildNumber());
        sb.append("-results.tar.gz");
        File resultsDir = this.getResultsDir();
        File gcpResultsDir = new File(resultsDir.getParentFile(), "gcp-results");
        try {
            JenkinsResultsParserUtil.copy(resultsDir, gcpResultsDir);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        TestrayS3Bucket testrayS3Bucket = TestrayS3Bucket.getInstance();
        for (File gcpResultFile : JenkinsResultsParserUtil.findFiles(gcpResultsDir, ".*.xml")) {
            try {
                Document document = Dom4JUtil.parse(JenkinsResultsParserUtil.read(gcpResultFile));
                Element rootElement = document.getRootElement();
                for (Element testcaseElement : rootElement.elements("testcase")) {
                    Element propertiesElement = testcaseElement.element("properties");
                    for (Element propertyElement : propertiesElement.elements("property")) {
                        String propertyName = propertyElement.attributeValue("name");
                        if (propertyName == null || !propertyName.equals("testray.testcase.warnings")) continue;
                        for (Element element : propertyElement.elements()) {
                            propertyElement.remove(element);
                        }
                    }
                }
                String gcpResultFileContent = Dom4JUtil.format(rootElement, false);
                gcpResultFileContent = gcpResultFileContent.replaceAll("(<property name=\"testray.testcase.warnings\" value=\"\\d+\")>\\s+<\\/property>", "$1/>");
                gcpResultFileContent = gcpResultFileContent.replaceAll(this.getURL() + "/?reports/production/logs", testrayS3Bucket.getTestrayS3BaseURL());
                JenkinsResultsParserUtil.write(gcpResultFile, gcpResultFileContent);
            }
            catch (IOException | DocumentException throwable) {}
        }
        File resultsTarGzFile = new File(gcpResultsDir.getParentFile(), sb.toString());
        JenkinsResultsParserUtil.tarGzip(gcpResultsDir, resultsTarGzFile);
        testrayS3Bucket.createTestrayS3Object("inbox/" + resultsTarGzFile.getName(), resultsTarGzFile);
    }

    private void _sendCommunicationFailureNotification(String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append("\n");
        sb.append(System.getenv("TOP_LEVEL_BUILD_URL"));
        NotificationUtil.sendSlackNotification(sb.toString(), "#ci-notifications", ":testray:", "Testray communication failure", "Liferay CI");
    }
}

