/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.json.storage.service.impl;

import com.liferay.json.storage.model.JSONStorageEntry;
import com.liferay.json.storage.model.JSONStorageEntryTable;
import com.liferay.json.storage.service.base.JSONStorageEntryLocalServiceBaseImpl;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.query.OrderByStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONDeserializer;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONSerializable;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.json.storage.model.JSONStorageEntry"}, service={AopService.class})
public class JSONStorageEntryLocalServiceImpl
extends JSONStorageEntryLocalServiceBaseImpl {
    @Reference
    private JSONFactory _jsonFactory;

    public void addJSONStorageEntries(long companyId, long classNameId, long classPK, String json) {
        this._updateJSONStorageEntries(companyId, classNameId, classPK, json, Collections.emptyList());
    }

    public void deleteJSONStorageEntries(long classNameId, long classPK) {
        this.jsonStorageEntryPersistence.removeByCN_CPK(classNameId, classPK);
    }

    public List<Long> getClassPKs(long companyId, long classNameId, Object[] pathParts, Object value, int start, int end) {
        OrderByStep orderByStep = this._getOrderByStep(DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{JSONStorageEntryTable.INSTANCE.classPK}), companyId, classNameId, pathParts, value);
        return (List)this.jsonStorageEntryPersistence.dslQuery(orderByStep.orderBy(new OrderByExpression[]{JSONStorageEntryTable.INSTANCE.classPK.ascending()}).limit(start, end));
    }

    public int getClassPKsCount(long companyId, long classNameId, Object[] pathParts, Object value) {
        OrderByStep orderByStep = this._getOrderByStep(DSLQueryFactoryUtil.countDistinct((Expression)JSONStorageEntryTable.INSTANCE.classPK), companyId, classNameId, pathParts, value);
        return this.jsonStorageEntryPersistence.dslQueryCount((DSLQuery)orderByStep);
    }

    public String getJSON(long classNameId, long classPK) {
        JSONSerializable jsonSerializable = this._getJSONSerializable(this.jsonStorageEntryPersistence.findByCN_CPK(classNameId, classPK));
        if (jsonSerializable == null) {
            return null;
        }
        return jsonSerializable.toJSONString();
    }

    public JSONArray getJSONArray(long classNameId, long classPK) {
        JSONSerializable jsonSerializable = this._getJSONSerializable(this.jsonStorageEntryPersistence.findByCN_CPK(classNameId, classPK));
        if (jsonSerializable == null) {
            return null;
        }
        return (JSONArray)jsonSerializable;
    }

    public JSONObject getJSONObject(long classNameId, long classPK) {
        JSONSerializable jsonSerializable = this._getJSONSerializable(this.jsonStorageEntryPersistence.findByCN_CPK(classNameId, classPK));
        if (jsonSerializable == null) {
            return null;
        }
        return (JSONObject)jsonSerializable;
    }

    public JSONSerializable getJSONSerializable(long classNameId, long classPK) {
        return this._getJSONSerializable(this.jsonStorageEntryPersistence.findByCN_CPK(classNameId, classPK));
    }

    public void updateJSONStorageEntries(long companyId, long classNameId, long classPK, String json) {
        this._updateJSONStorageEntries(companyId, classNameId, classPK, json, this.jsonStorageEntryPersistence.findByCN_CPK(classNameId, classPK));
    }

    private JSONSerializable _getJSONSerializable(List<JSONStorageEntry> jsonStorageEntries) {
        HashMap<Long, JSONSerializable> map = new HashMap<Long, JSONSerializable>();
        for (JSONStorageEntry jsonStorageEntry : jsonStorageEntries) {
            JSONArray jsonArray = null;
            JSONObject jsonObject = null;
            if (jsonStorageEntry.getIndex() == -1) {
                jsonObject = (JSONObject)map.computeIfAbsent(jsonStorageEntry.getParentJSONStorageEntryId(), key -> this._jsonFactory.createJSONObject());
            } else {
                jsonArray = (JSONArray)map.computeIfAbsent(jsonStorageEntry.getParentJSONStorageEntryId(), key -> this._jsonFactory.createJSONArray());
            }
            int type = jsonStorageEntry.getType();
            if (type == 2) continue;
            Object value = null;
            if (type == 1) {
                value = map.computeIfAbsent(jsonStorageEntry.getPrimaryKey(), key -> this._jsonFactory.createJSONArray());
            } else if (type == 4) {
                value = map.computeIfAbsent(jsonStorageEntry.getPrimaryKey(), key -> this._jsonFactory.createJSONObject());
            } else if (type == 5) {
                value = jsonStorageEntry.getValueLong();
            } else if (type == 6) {
                value = String.valueOf(jsonStorageEntry.getValueLong());
            } else if (type == 7) {
                JSONDeserializer jsonDeserializer = this._jsonFactory.createJSONDeserializer();
                value = jsonDeserializer.deserialize(jsonStorageEntry.getValueString());
            }
            if (jsonArray == null) {
                jsonObject.put(jsonStorageEntry.getKey(), value);
                continue;
            }
            jsonArray.put(value);
        }
        return (JSONSerializable)map.get(0L);
    }

    private OrderByStep _getOrderByStep(FromStep fromStep, long companyId, long classNameId, Object[] pathParts, Object value) {
        JoinStep joinStep = fromStep.from((Table)JSONStorageEntryTable.INSTANCE);
        Predicate predicate = JSONStorageEntryTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)JSONStorageEntryTable.INSTANCE.classNameId.eq((Object)classNameId));
        Long valueLong = null;
        if (value instanceof Integer || value instanceof Long) {
            Number number = (Number)value;
            valueLong = number.longValue();
        } else {
            valueLong = this._parseLong(value);
        }
        if (valueLong != null) {
            predicate = predicate.and((Expression)JSONStorageEntryTable.INSTANCE.type.in((Object[])new Integer[]{5, 6})).and((Expression)JSONStorageEntryTable.INSTANCE.valueLong.eq((Object)valueLong));
        } else {
            JSONSerializer jsonSerializer = this._jsonFactory.createJSONSerializer();
            predicate = predicate.and((Expression)JSONStorageEntryTable.INSTANCE.type.eq((Object)7)).and((Expression)DSLFunctionFactoryUtil.castClobText((Expression)JSONStorageEntryTable.INSTANCE.valueString).eq((Object)jsonSerializer.serialize(value)));
        }
        if (ArrayUtil.isEmpty((Object[])pathParts)) {
            return joinStep.where(predicate);
        }
        Object pathPart = pathParts[pathParts.length - 1];
        if (pathPart instanceof String) {
            predicate = predicate.and((Expression)JSONStorageEntryTable.INSTANCE.key.eq((Object)((String)pathPart)));
        } else if (pathPart instanceof Integer) {
            predicate = predicate.and((Expression)JSONStorageEntryTable.INSTANCE.index.eq((Object)((Integer)pathPart)));
        }
        JSONStorageEntryTable previousJSONStorageEntryTable = JSONStorageEntryTable.INSTANCE;
        Object previousPathPart = pathPart;
        for (int i = pathParts.length - 2; i >= 0; --i) {
            JSONStorageEntryTable aliasJSONStorageEntryTable = (JSONStorageEntryTable)JSONStorageEntryTable.INSTANCE.as("aliasJSONStorageEntryTable" + i);
            joinStep = joinStep.innerJoinON((Table)aliasJSONStorageEntryTable, aliasJSONStorageEntryTable.jsonStorageEntryId.eq((Expression)previousJSONStorageEntryTable.parentJSONStorageEntryId));
            pathPart = pathParts[i];
            if (pathPart instanceof String) {
                String key = (String)pathPart;
                predicate = predicate.and((Expression)aliasJSONStorageEntryTable.key.eq((Object)key));
            } else if (pathPart instanceof Integer) {
                Integer index = (Integer)pathPart;
                predicate = predicate.and((Expression)aliasJSONStorageEntryTable.index.eq((Object)index));
            }
            if (previousPathPart instanceof String) {
                predicate = predicate.and((Expression)aliasJSONStorageEntryTable.type.eq((Object)4));
            } else if (previousPathPart instanceof Integer) {
                predicate = predicate.and((Expression)aliasJSONStorageEntryTable.type.eq((Object)1));
            }
            previousJSONStorageEntryTable = aliasJSONStorageEntryTable;
            previousPathPart = pathPart;
        }
        return joinStep.where(predicate);
    }

    private Long _parseLong(Object object) {
        if (!(object instanceof String)) {
            return null;
        }
        String value = (String)object;
        int length = value.length();
        if (length <= 0) {
            return null;
        }
        int pos = 0;
        long limit = -9223372036854775807L;
        boolean negative = false;
        char c = value.charAt(0);
        if (c < '0') {
            if (c == '-') {
                limit = Long.MIN_VALUE;
                negative = true;
            } else if (c != '+') {
                return null;
            }
            if (length == 1) {
                return null;
            }
            ++pos;
        }
        long smallLimit = limit / 10L;
        long result = 0L;
        while (pos < length) {
            if (result < smallLimit) {
                return null;
            }
            if ((c = value.charAt(pos++)) < '0' || c > '9') {
                return null;
            }
            int number = c - 48;
            if ((result *= 10L) < limit + (long)number) {
                return null;
            }
            result -= (long)number;
        }
        if (negative) {
            return result;
        }
        return -result;
    }

    private void _removeChildJSONStorageEntries(Map<Long, List<JSONStorageEntry>> jsonStorageEntriesMap, JSONStorageEntry jsonStorageEntry) {
        List<JSONStorageEntry> jsonStorageEntries = jsonStorageEntriesMap.get(jsonStorageEntry.getPrimaryKey());
        if (jsonStorageEntries == null) {
            return;
        }
        LinkedList<JSONStorageEntry> queue = new LinkedList<JSONStorageEntry>(jsonStorageEntries);
        while ((jsonStorageEntry = (JSONStorageEntry)queue.poll()) != null) {
            jsonStorageEntries = jsonStorageEntriesMap.get(jsonStorageEntry.getPrimaryKey());
            if (jsonStorageEntries != null) {
                queue.addAll(jsonStorageEntries);
            }
            this.jsonStorageEntryPersistence.remove((BaseModel)jsonStorageEntry);
        }
    }

    private void _updateEmptyJSONStorageEntry(long companyId, long classNameId, long classPK, long parentJSONStorageEntryId, int index, List<JSONStorageEntry> jsonStorageEntries, Map<Long, List<JSONStorageEntry>> jsonStorageEntriesMap) {
        JSONStorageEntry jsonStorageEntry = null;
        if (jsonStorageEntries != null && !jsonStorageEntries.isEmpty()) {
            jsonStorageEntry = jsonStorageEntries.get(0);
            for (int i = 1; i < jsonStorageEntries.size(); ++i) {
                this.jsonStorageEntryPersistence.remove((BaseModel)jsonStorageEntries.get(i));
                this._removeChildJSONStorageEntries(jsonStorageEntriesMap, jsonStorageEntries.get(i));
            }
        }
        if (jsonStorageEntry == null) {
            jsonStorageEntry = this.jsonStorageEntryPersistence.create(this.counterLocalService.increment(JSONStorageEntry.class.getName()));
            jsonStorageEntry.setCompanyId(companyId);
            jsonStorageEntry.setClassNameId(classNameId);
            jsonStorageEntry.setClassPK(classPK);
            jsonStorageEntry.setParentJSONStorageEntryId(parentJSONStorageEntryId);
        }
        if (jsonStorageEntry.isNew() || index != jsonStorageEntry.getIndex() || !Objects.equals("", jsonStorageEntry.getKey()) || jsonStorageEntry.getType() != 2 || !Objects.equals("", jsonStorageEntry.getValue())) {
            jsonStorageEntry.setIndex(index);
            jsonStorageEntry.setKey("");
            jsonStorageEntry.setType(2);
            jsonStorageEntry.setValue(null);
            jsonStorageEntry = (JSONStorageEntry)this.jsonStorageEntryPersistence.update((BaseModel)jsonStorageEntry);
            this._removeChildJSONStorageEntries(jsonStorageEntriesMap, jsonStorageEntry);
        }
    }

    private void _updateJSONArray(long companyId, long classNameId, long classPK, Map<Long, List<JSONStorageEntry>> jsonStorageEntriesMap, List<?> jsonArrayList, long parentJSONStorageEntryId) {
        int i;
        List<JSONStorageEntry> jsonStorageEntries = jsonStorageEntriesMap.get(parentJSONStorageEntryId);
        int length = jsonArrayList.size();
        for (i = 0; i < length; ++i) {
            Object value = jsonArrayList.get(i);
            JSONStorageEntry jsonStorageEntry = null;
            if (jsonStorageEntries != null && i < jsonStorageEntries.size()) {
                jsonStorageEntry = jsonStorageEntries.get(i);
            }
            this._updateJSONStorageEntry(companyId, classNameId, classPK, parentJSONStorageEntryId, i, "", value, jsonStorageEntriesMap, jsonStorageEntry);
        }
        if (length == 0) {
            this._updateEmptyJSONStorageEntry(companyId, classNameId, classPK, parentJSONStorageEntryId, 0, jsonStorageEntries, jsonStorageEntriesMap);
        } else if (jsonStorageEntries != null) {
            for (i = length; i < jsonStorageEntries.size(); ++i) {
                JSONStorageEntry jsonStorageEntry = jsonStorageEntries.get(i);
                this.jsonStorageEntryPersistence.remove((BaseModel)jsonStorageEntry);
                this._removeChildJSONStorageEntries(jsonStorageEntriesMap, jsonStorageEntry);
            }
        }
    }

    private void _updateJSONObject(long companyId, long classNameId, long classPK, Map<Long, List<JSONStorageEntry>> jsonStorageEntriesMap, Map<String, Object> objects, long parentJSONStorageEntryId) {
        List<JSONStorageEntry> jsonStorageEntries = jsonStorageEntriesMap.get(parentJSONStorageEntryId);
        Set<String> set = objects.keySet();
        for (Map.Entry<String, Object> entry : objects.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            JSONStorageEntry jsonStorageEntry = null;
            if (jsonStorageEntries != null) {
                for (JSONStorageEntry currentJSONStorageEntry : jsonStorageEntries) {
                    if (!key.equals(currentJSONStorageEntry.getKey())) continue;
                    jsonStorageEntry = currentJSONStorageEntry;
                    break;
                }
            }
            this._updateJSONStorageEntry(companyId, classNameId, classPK, parentJSONStorageEntryId, -1, key, value, jsonStorageEntriesMap, jsonStorageEntry);
        }
        if (set.isEmpty()) {
            this._updateEmptyJSONStorageEntry(companyId, classNameId, classPK, parentJSONStorageEntryId, -1, jsonStorageEntries, jsonStorageEntriesMap);
        } else if (jsonStorageEntries != null) {
            for (JSONStorageEntry jsonStorageEntry : jsonStorageEntries) {
                if (set.contains(jsonStorageEntry.getKey())) continue;
                this.jsonStorageEntryPersistence.remove((BaseModel)jsonStorageEntry);
                this._removeChildJSONStorageEntries(jsonStorageEntriesMap, jsonStorageEntry);
            }
        }
    }

    private void _updateJSONStorageEntries(long companyId, long classNameId, long classPK, String json, List<JSONStorageEntry> jsonStorageEntries) {
        HashMap<Long, List<JSONStorageEntry>> jsonStorageEntriesMap = new HashMap<Long, List<JSONStorageEntry>>();
        for (JSONStorageEntry jsonStorageEntry : jsonStorageEntries) {
            List values = jsonStorageEntriesMap.computeIfAbsent(jsonStorageEntry.getParentJSONStorageEntryId(), key -> new ArrayList());
            values.add(jsonStorageEntry);
        }
        JSONDeserializer jsonDeserializer = this._jsonFactory.createJSONDeserializer();
        Object object = jsonDeserializer.deserialize(json);
        if (object instanceof List) {
            this._updateJSONArray(companyId, classNameId, classPK, jsonStorageEntriesMap, (List)object, 0L);
        } else if (object instanceof Map) {
            this._updateJSONObject(companyId, classNameId, classPK, jsonStorageEntriesMap, (Map)object, 0L);
        } else {
            throw new IllegalArgumentException("Invalid JSON: " + json);
        }
    }

    private void _updateJSONStorageEntry(long companyId, long classNameId, long classPK, long parentJSONStorageEntryId, int index, String key, Object value, Map<Long, List<JSONStorageEntry>> jsonStorageEntriesMap, JSONStorageEntry jsonStorageEntry) {
        if (jsonStorageEntry == null) {
            jsonStorageEntry = this.jsonStorageEntryPersistence.create(this.counterLocalService.increment(JSONStorageEntry.class.getName()));
            jsonStorageEntry.setCompanyId(companyId);
            jsonStorageEntry.setClassNameId(classNameId);
            jsonStorageEntry.setClassPK(classPK);
            jsonStorageEntry.setParentJSONStorageEntryId(parentJSONStorageEntryId);
            jsonStorageEntry.setIndex(index);
            jsonStorageEntry.setKey(key);
        }
        int type = 3;
        if (value instanceof List) {
            type = 1;
            this._updateJSONArray(companyId, classNameId, classPK, jsonStorageEntriesMap, (List)value, jsonStorageEntry.getPrimaryKey());
        } else if (value instanceof Map) {
            type = 4;
            this._updateJSONObject(companyId, classNameId, classPK, jsonStorageEntriesMap, (Map)value, jsonStorageEntry.getPrimaryKey());
        } else if (value != null) {
            Long valueLong = null;
            if (value instanceof Integer || value instanceof Long) {
                type = 5;
                Number number = (Number)value;
                valueLong = number.longValue();
            } else {
                type = 6;
                valueLong = this._parseLong(value);
            }
            if (valueLong != null) {
                value = valueLong;
            } else if (value != null) {
                type = 7;
                JSONSerializer jsonSerializer = this._jsonFactory.createJSONSerializer();
                value = jsonSerializer.serialize(value);
            }
        }
        if (jsonStorageEntry.isNew() || index != jsonStorageEntry.getIndex() || !Objects.equals(key, jsonStorageEntry.getKey()) || type != jsonStorageEntry.getType() || (type == 5 || type == 6 || type == 7) && !Objects.equals(value, jsonStorageEntry.getValue())) {
            jsonStorageEntry.setIndex(index);
            jsonStorageEntry.setKey(key);
            jsonStorageEntry.setType(type);
            jsonStorageEntry.setValue(value);
            jsonStorageEntry = (JSONStorageEntry)this.jsonStorageEntryPersistence.update((BaseModel)jsonStorageEntry);
            if (type != 1 && type != 4) {
                this._removeChildJSONStorageEntries(jsonStorageEntriesMap, jsonStorageEntry);
            }
        }
    }
}

