/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.responsive;

import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.ColumnLayoutStructureItem;
import com.liferay.layout.util.structure.CommonStylesUtil;
import com.liferay.layout.util.structure.ContainerStyledLayoutStructureItem;
import com.liferay.layout.util.structure.RowStyledLayoutStructureItem;
import com.liferay.layout.util.structure.StyledLayoutStructureItem;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ResponsiveLayoutStructureUtil {
    private static final ViewportSize[] _sortedViewportSizes = ViewportSize.values();
    private static final ViewportSize[] _viewportSizes = ViewportSize.values();

    @Deprecated
    public static String getColumnCssClass(ColumnLayoutStructureItem columnLayoutStructureItem) {
        return ResponsiveLayoutStructureUtil.getColumnCssClass(columnLayoutStructureItem, null);
    }

    public static String getColumnCssClass(ColumnLayoutStructureItem columnLayoutStructureItem, RowStyledLayoutStructureItem rowStyledLayoutStructureItem) {
        StringBundler sb = new StringBundler();
        sb.append("col-lg-");
        sb.append(columnLayoutStructureItem.getSize());
        Map<String, JSONObject> columnViewportConfigurationJSONObjects = columnLayoutStructureItem.getViewportConfigurationJSONObjects();
        for (ViewportSize viewportSize : _viewportSizes) {
            if (Objects.equals((Object)viewportSize, (Object)ViewportSize.DESKTOP)) continue;
            int columnSize = GetterUtil.getInteger((Object)ResponsiveLayoutStructureUtil.getResponsivePropertyValue(viewportSize, columnViewportConfigurationJSONObjects, "size", columnLayoutStructureItem.getSize()));
            sb.append(" col");
            sb.append(viewportSize.getCssClassPrefix());
            sb.append(columnSize);
        }
        if (rowStyledLayoutStructureItem != null && Objects.equals(rowStyledLayoutStructureItem.getVerticalAlignment(), "middle")) {
            sb.append("d-flex flex-column ");
        }
        return sb.toString();
    }

    public static String getResponsiveCssClassValues(StyledLayoutStructureItem styledLayoutStructureItem) throws Exception {
        StringBundler sb = new StringBundler();
        HashSet<String> propertiesWithResponsiveValues = new HashSet<String>();
        JSONObject itemConfigJSONObject = styledLayoutStructureItem.getItemConfigJSONObject();
        for (ViewportSize viewportSize : _sortedViewportSizes) {
            if (Objects.equals((Object)viewportSize, (Object)ViewportSize.DESKTOP)) continue;
            JSONObject stylesJSONObject = ResponsiveLayoutStructureUtil._getStylesJSONObject(itemConfigJSONObject, viewportSize);
            for (String key : CommonStylesUtil.getResponsiveStyleNames()) {
                ContainerStyledLayoutStructureItem containerStyledLayoutStructureItem;
                String value = stylesJSONObject.getString(key);
                if (Validator.isNull((String)value)) {
                    if (!propertiesWithResponsiveValues.contains(key)) continue;
                    value = GetterUtil.getString((Object)CommonStylesUtil.getDefaultStyleValue(key));
                }
                propertiesWithResponsiveValues.add(key);
                if (styledLayoutStructureItem instanceof ContainerStyledLayoutStructureItem && Objects.equals((containerStyledLayoutStructureItem = (ContainerStyledLayoutStructureItem)styledLayoutStructureItem).getWidthType(), "fixed") && (Objects.equals(key, "marginLeft") || Objects.equals(key, "marginRight"))) continue;
                String cssClass = StringUtil.replace((String)CommonStylesUtil.getResponsiveTemplate(key), (String)"{", (String)"}", (Map)HashMapBuilder.put((Object)"value", (Object)value).put((Object)"viewport", (Object)viewportSize.getCssClassPrefix()).build());
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(cssClass);
            }
        }
        return sb.toString();
    }

    public static Object getResponsivePropertyValue(ViewportSize currentViewportSize, Map<String, JSONObject> viewportConfigurationJSONObjects, String propertyName, Object defaultValue) {
        JSONObject viewportConfigurationJSONObject = viewportConfigurationJSONObjects.getOrDefault(currentViewportSize.getViewportSizeId(), JSONFactoryUtil.createJSONObject());
        if (viewportConfigurationJSONObject.has(propertyName)) {
            return viewportConfigurationJSONObject.get(propertyName);
        }
        for (ViewportSize viewportSize : _sortedViewportSizes) {
            if (viewportSize.getOrder() >= currentViewportSize.getOrder() || !(viewportConfigurationJSONObject = viewportConfigurationJSONObjects.getOrDefault(viewportSize.getViewportSizeId(), JSONFactoryUtil.createJSONObject())).has(propertyName)) continue;
            return viewportConfigurationJSONObject.get(propertyName);
        }
        return defaultValue;
    }

    public static String getRowCssClass(RowStyledLayoutStructureItem rowStyledLayoutStructureItem) {
        StringBundler sb = new StringBundler();
        sb.append("align-items-lg-");
        sb.append(ResponsiveLayoutStructureUtil._getVerticalAlignmentCssClass(rowStyledLayoutStructureItem.getVerticalAlignment()));
        Map<String, JSONObject> rowViewportConfigurationJSONObjects = rowStyledLayoutStructureItem.getViewportConfigurationJSONObjects();
        for (ViewportSize viewportSize : _viewportSizes) {
            if (Objects.equals((Object)viewportSize, (Object)ViewportSize.DESKTOP)) continue;
            String verticalAlignment = GetterUtil.getString((Object)ResponsiveLayoutStructureUtil.getResponsivePropertyValue(viewportSize, rowViewportConfigurationJSONObjects, "verticalAlignment", rowStyledLayoutStructureItem.getVerticalAlignment()));
            sb.append(" align-items");
            sb.append(viewportSize.getCssClassPrefix());
            sb.append(ResponsiveLayoutStructureUtil._getVerticalAlignmentCssClass(verticalAlignment));
        }
        sb.append(" ");
        if (rowStyledLayoutStructureItem.isReverseOrder() && rowStyledLayoutStructureItem.getModulesPerRow() > 1) {
            sb.append("flex-lg-row-reverse");
        } else if (rowStyledLayoutStructureItem.isReverseOrder() && rowStyledLayoutStructureItem.getModulesPerRow() == 1) {
            sb.append("flex-lg-column-reverse");
        } else {
            sb.append("flex-lg-row");
        }
        for (ViewportSize viewportSize : _viewportSizes) {
            if (Objects.equals((Object)viewportSize, (Object)ViewportSize.DESKTOP)) continue;
            boolean reverseOrder = GetterUtil.getBoolean((Object)ResponsiveLayoutStructureUtil.getResponsivePropertyValue(viewportSize, rowViewportConfigurationJSONObjects, "reverseOrder", rowStyledLayoutStructureItem.isReverseOrder()));
            int modulesPerRow = GetterUtil.getInteger((Object)ResponsiveLayoutStructureUtil.getResponsivePropertyValue(viewportSize, rowViewportConfigurationJSONObjects, "modulesPerRow", rowStyledLayoutStructureItem.getModulesPerRow()));
            sb.append(" ");
            if (reverseOrder) {
                sb.append("flex");
                sb.append(viewportSize.getCssClassPrefix());
                if (modulesPerRow > 1) {
                    sb.append("row-reverse");
                    continue;
                }
                if (modulesPerRow != 1) continue;
                sb.append("column-reverse");
                continue;
            }
            sb.append("flex");
            sb.append(viewportSize.getCssClassPrefix());
            sb.append("row");
        }
        if (!rowStyledLayoutStructureItem.isGutters()) {
            sb.append(" no-gutters");
        }
        return sb.toString();
    }

    private static JSONObject _getStylesJSONObject(JSONObject itemConfigJSONObject, ViewportSize currentViewportSize) {
        JSONObject stylesJSONObject = JSONFactoryUtil.createJSONObject();
        for (ViewportSize viewportSize : _sortedViewportSizes) {
            if (viewportSize.getOrder() > currentViewportSize.getOrder()) continue;
            JSONObject jsonObject = null;
            if (Objects.equals((Object)viewportSize, (Object)ViewportSize.DESKTOP)) {
                jsonObject = itemConfigJSONObject.getJSONObject("styles");
            } else {
                JSONObject viewportJSONObject = itemConfigJSONObject.getJSONObject(viewportSize.getViewportSizeId());
                if (viewportJSONObject == null) continue;
                jsonObject = viewportJSONObject.getJSONObject("styles");
            }
            Set keys = jsonObject.keySet();
            for (String key : keys) {
                if (jsonObject.isNull(key) || !Validator.isNotNull((Object)jsonObject.get(key)) || !Validator.isNull((Object)stylesJSONObject.get(key))) continue;
                stylesJSONObject.put(key, jsonObject.get(key));
            }
        }
        return stylesJSONObject;
    }

    private static String _getVerticalAlignmentCssClass(String verticalAlignment) {
        if (Objects.equals(verticalAlignment, "bottom")) {
            return "end";
        }
        if (Objects.equals(verticalAlignment, "middle")) {
            return "center";
        }
        return "start";
    }

    static {
        Comparator<ViewportSize> comparator = Comparator.comparingInt(ViewportSize::getOrder);
        Arrays.sort(_sortedViewportSizes, comparator.reversed());
    }
}

