/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.LanguageResources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class CommonStylesUtil {
    private static List<String> _availableStyleNames;
    private static final Map<Locale, JSONArray> _commonStyles;
    private static Map<String, String> _cssTemplates;
    private static Map<String, Object> _defaultValues;
    private static List<String> _responsiveStyleNames;
    private static Map<String, String> _responsiveTemplates;

    public static List<String> getAvailableStyleNames() {
        if (_availableStyleNames != null) {
            return _availableStyleNames;
        }
        ArrayList<String> availableStyleNames = new ArrayList<String>();
        JSONArray jsonArray = CommonStylesUtil.getCommonStylesJSONArray();
        Iterator iterator = jsonArray.iterator();
        iterator.forEachRemaining(jsonObject -> {
            JSONArray stylesJSONArray = jsonObject.getJSONArray("styles");
            Iterator stylesIterator = stylesJSONArray.iterator();
            stylesIterator.forEachRemaining(styleJSONObject -> availableStyleNames.add(styleJSONObject.getString("name")));
        });
        Collections.sort(availableStyleNames);
        _availableStyleNames = availableStyleNames;
        return _availableStyleNames;
    }

    public static JSONArray getCommonStylesJSONArray() {
        try {
            return CommonStylesUtil.getCommonStylesJSONArray(LanguageResources.getResourceBundle((Locale)LocaleUtil.getDefault()));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static JSONArray getCommonStylesJSONArray(ResourceBundle resourceBundle) throws Exception {
        JSONArray commonStylesJSONArray = null;
        if (resourceBundle != null) {
            commonStylesJSONArray = _commonStyles.get(resourceBundle.getLocale());
        }
        if (commonStylesJSONArray != null) {
            return commonStylesJSONArray;
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)new String(FileUtil.getBytes(CommonStylesUtil.class, (String)"common-styles.json")));
        Iterator iterator = jsonArray.iterator();
        iterator.forEachRemaining(jsonObject -> {
            jsonObject.put("label", LanguageUtil.get((ResourceBundle)resourceBundle, (String)jsonObject.getString("label")));
            JSONArray stylesJSONArray = jsonObject.getJSONArray("styles");
            Iterator stylesIterator = stylesJSONArray.iterator();
            stylesIterator.forEachRemaining(styleJSONObject -> {
                styleJSONObject.put("label", LanguageUtil.get((ResourceBundle)resourceBundle, (String)styleJSONObject.getString("label")));
                JSONArray validValuesJSONArray = styleJSONObject.getJSONArray("validValues");
                if (validValuesJSONArray != null) {
                    Iterator validValuesIterator = validValuesJSONArray.iterator();
                    validValuesIterator.forEachRemaining(validValueJSONObject -> validValueJSONObject.put("label", LanguageUtil.get((ResourceBundle)resourceBundle, (String)validValueJSONObject.getString("label"))));
                }
            });
        });
        if (resourceBundle != null) {
            _commonStyles.put(resourceBundle.getLocale(), jsonArray);
        }
        return jsonArray;
    }

    public static String getCSSTemplate(String propertyKey) {
        if (_cssTemplates != null) {
            return _cssTemplates.get(propertyKey);
        }
        CommonStylesUtil._loadCSSTemplates();
        return _cssTemplates.get(propertyKey);
    }

    public static Object getDefaultStyleValue(String name) {
        if (_defaultValues != null) {
            return _defaultValues.get(name);
        }
        Map<String, Object> defaultValues = CommonStylesUtil.getDefaultStyleValues();
        return defaultValues.get(name);
    }

    public static Map<String, Object> getDefaultStyleValues() {
        if (_defaultValues != null) {
            return _defaultValues;
        }
        HashMap<String, Object> defaultValues = new HashMap<String, Object>();
        JSONArray jsonArray = CommonStylesUtil.getCommonStylesJSONArray();
        Iterator iterator = jsonArray.iterator();
        iterator.forEachRemaining(jsonObject -> {
            JSONArray stylesJSONArray = jsonObject.getJSONArray("styles");
            Iterator stylesIterator = stylesJSONArray.iterator();
            stylesIterator.forEachRemaining(styleJSONObject -> defaultValues.put(styleJSONObject.getString("name"), styleJSONObject.get("defaultValue")));
        });
        _defaultValues = defaultValues;
        return _defaultValues;
    }

    public static List<String> getResponsiveStyleNames() {
        if (_responsiveStyleNames != null) {
            return _responsiveStyleNames;
        }
        ArrayList<String> responsiveStyleNames = new ArrayList<String>();
        for (String availableStyleName : CommonStylesUtil.getAvailableStyleNames()) {
            if (!CommonStylesUtil.isResponsive(availableStyleName)) continue;
            responsiveStyleNames.add(availableStyleName);
        }
        _responsiveStyleNames = responsiveStyleNames;
        return _responsiveStyleNames;
    }

    public static String getResponsiveTemplate(String propertyKey) {
        if (_responsiveTemplates != null) {
            return _responsiveTemplates.get(propertyKey);
        }
        CommonStylesUtil._loadResponsiveTemplates();
        return _responsiveTemplates.get(propertyKey);
    }

    public static boolean isResponsive(String propertyKey) {
        if (_responsiveTemplates != null) {
            return Validator.isNotNull((String)_responsiveTemplates.get(propertyKey));
        }
        CommonStylesUtil._loadResponsiveTemplates();
        return Validator.isNotNull((String)_responsiveTemplates.get(propertyKey));
    }

    private static void _loadCSSTemplates() {
        HashMap<String, String> cssTemplates = new HashMap<String, String>();
        JSONArray jsonArray = CommonStylesUtil.getCommonStylesJSONArray();
        Iterator iterator = jsonArray.iterator();
        iterator.forEachRemaining(jsonObject -> {
            JSONArray stylesJSONArray = jsonObject.getJSONArray("styles");
            Iterator stylesIterator = stylesJSONArray.iterator();
            stylesIterator.forEachRemaining(styleJSONObject -> cssTemplates.put(styleJSONObject.getString("name"), styleJSONObject.getString("cssTemplate", "")));
        });
        _cssTemplates = cssTemplates;
    }

    private static void _loadResponsiveTemplates() {
        HashMap<String, String> responsiveTemplates = new HashMap<String, String>();
        JSONArray jsonArray = CommonStylesUtil.getCommonStylesJSONArray();
        Iterator iterator = jsonArray.iterator();
        iterator.forEachRemaining(jsonObject -> {
            JSONArray stylesJSONArray = jsonObject.getJSONArray("styles");
            Iterator stylesIterator = stylesJSONArray.iterator();
            stylesIterator.forEachRemaining(styleJSONObject -> {
                boolean responsive = styleJSONObject.getBoolean("responsive");
                if (responsive) {
                    responsiveTemplates.put(styleJSONObject.getString("name"), styleJSONObject.getString("responsiveTemplate", ""));
                }
            });
        });
        _responsiveTemplates = responsiveTemplates;
    }

    static {
        _commonStyles = new HashMap<Locale, JSONArray>();
    }
}

