/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.CommonStylesUtil;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class StyledLayoutStructureItem
extends LayoutStructureItem {
    protected JSONObject stylesJSONObject = JSONFactoryUtil.createJSONObject();
    protected Map<String, JSONObject> viewportStyleJSONObjects = new HashMap<String, JSONObject>();
    private static final Log _log = LogFactoryUtil.getLog(StyledLayoutStructureItem.class);
    private static final ViewportSize[] _viewportSizes = ViewportSize.values();
    private Set<String> _cssClasses;
    private String _customCSS;
    private final Map<String, String> _customCSSViewports = new HashMap<String, String>();

    public StyledLayoutStructureItem(String parentItemId) {
        super(parentItemId);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StyledLayoutStructureItem)) {
            return false;
        }
        StyledLayoutStructureItem styledLayoutStructureItem = (StyledLayoutStructureItem)object;
        JSONObject stylesJSONObject = styledLayoutStructureItem.stylesJSONObject;
        for (String key : this.stylesJSONObject.keySet()) {
            if (Objects.deepEquals(GetterUtil.getString((Object)this.stylesJSONObject.get(key)), GetterUtil.getString((Object)stylesJSONObject.get(key)))) continue;
            return false;
        }
        return super.equals(object);
    }

    public String getAlign() {
        return GetterUtil.getString((Object)this._getStyleProperty("align"));
    }

    public String getBackgroundColor() {
        return this._getColor("backgroundColor");
    }

    public String getBackgroundColorCssClass() {
        return this._getColorCssClass("backgroundColor");
    }

    public JSONObject getBackgroundImageJSONObject() {
        return (JSONObject)this._getStyleProperty("backgroundImage");
    }

    public String getBorderColor() {
        return this._getColor("borderColor");
    }

    public String getBorderColorCssClass() {
        return this._getColorCssClass("borderColor");
    }

    public String getBorderRadius() {
        return GetterUtil.getString((Object)this._getStyleProperty("borderRadius"));
    }

    public String getBorderWidth() {
        return this._getStringStyleProperty("borderWidth");
    }

    public String getContentDisplay() {
        return "";
    }

    public Set<String> getCssClasses() {
        return this._cssClasses;
    }

    public String getCustomCSS() {
        return this._customCSS;
    }

    public Map<String, String> getCustomCSSViewports() {
        return this._customCSSViewports;
    }

    public String getDisplay() {
        return this._getStringStyleProperty("display");
    }

    public String getFlexWrap() {
        return GetterUtil.getString((Object)this._getStyleProperty("flexWrap"));
    }

    public String getFontFamily() {
        return GetterUtil.getString((Object)this._getStyleProperty("fontFamily"));
    }

    public String getFontSize() {
        return GetterUtil.getString((Object)this._getStyleProperty("fontSize"));
    }

    public String getFontWeight() {
        return GetterUtil.getString((Object)this._getStyleProperty("fontWeight"));
    }

    public String getHeight() {
        return GetterUtil.getString((Object)this._getStyleProperty("height"));
    }

    @Override
    public JSONObject getItemConfigJSONObject() {
        JSONObject jsonObject = JSONUtil.put((String)"cssClasses", (Object)JSONFactoryUtil.createJSONArray(this._cssClasses)).put("customCSS", this._customCSS).put("styles", this.stylesJSONObject);
        for (ViewportSize viewportSize : _viewportSizes) {
            if (viewportSize.equals((Object)ViewportSize.DESKTOP)) continue;
            jsonObject.put(viewportSize.getViewportSizeId(), JSONUtil.put((String)"customCSS", (Object)this._customCSSViewports.get(viewportSize.getViewportSizeId())).put("styles", this.viewportStyleJSONObjects.getOrDefault(viewportSize.getViewportSizeId(), JSONFactoryUtil.createJSONObject())));
        }
        return jsonObject;
    }

    public String getJustify() {
        return GetterUtil.getString((Object)this._getStyleProperty("justify"));
    }

    public String getMarginBottom() {
        return this._getStringStyleProperty("marginBottom");
    }

    public String getMarginLeft() {
        return this._getStringStyleProperty("marginLeft");
    }

    public String getMarginRight() {
        return this._getStringStyleProperty("marginRight");
    }

    public String getMarginTop() {
        return this._getStringStyleProperty("marginTop");
    }

    public String getMaxHeight() {
        return GetterUtil.getString((Object)this._getStyleProperty("maxHeight"));
    }

    public String getMaxWidth() {
        return GetterUtil.getString((Object)this._getStyleProperty("maxWidth"));
    }

    public String getMinHeight() {
        return GetterUtil.getString((Object)this._getStyleProperty("minHeight"));
    }

    public String getMinWidth() {
        return GetterUtil.getString((Object)this._getStyleProperty("minWidth"));
    }

    public String getOpacity() {
        return this._getStringStyleProperty("opacity");
    }

    public String getOverflow() {
        return GetterUtil.getString((Object)this._getStyleProperty("overflow"));
    }

    public String getPaddingBottom() {
        return this._getStringStyleProperty("paddingBottom");
    }

    public String getPaddingLeft() {
        return this._getStringStyleProperty("paddingLeft");
    }

    public String getPaddingRight() {
        return this._getStringStyleProperty("paddingRight");
    }

    public String getPaddingTop() {
        return this._getStringStyleProperty("paddingTop");
    }

    public String getShadow() {
        return GetterUtil.getString((Object)this._getStyleProperty("shadow"));
    }

    public String getTextAlignCssClass() {
        return GetterUtil.getString((Object)this._getStyleProperty("textAlign"));
    }

    public String getTextColor() {
        return this._getColor("textColor");
    }

    public String getTextColorCssClass() {
        return this._getColorCssClass("textColor");
    }

    public String getWidth() {
        return GetterUtil.getString((Object)this._getStyleProperty("width"));
    }

    @Override
    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this.getItemId());
    }

    public void setCssClasses(Set<String> cssClasses) {
        this._cssClasses = cssClasses;
    }

    public void setCustomCSS(String customCSS) {
        this._customCSS = customCSS;
    }

    public void setCustomCSSViewport(String viewportSizeId, String customCSS) {
        this._customCSSViewports.put(viewportSizeId, customCSS);
    }

    @Override
    public void updateItemConfig(JSONObject itemConfigJSONObject) {
        if (itemConfigJSONObject.has("cssClasses")) {
            LinkedHashSet<String> cssClasses = new LinkedHashSet<String>();
            JSONUtil.addToStringCollection(cssClasses, (JSONArray)itemConfigJSONObject.getJSONArray("cssClasses"));
            this.setCssClasses(cssClasses);
        }
        if (itemConfigJSONObject.has("customCSS")) {
            this.setCustomCSS(itemConfigJSONObject.getString("customCSS"));
        }
        try {
            this._updateItemConfigValues(this.stylesJSONObject, itemConfigJSONObject);
            if (itemConfigJSONObject.has("styles")) {
                JSONObject newStylesJSONObject = itemConfigJSONObject.getJSONObject("styles");
                this._updateItemConfigValues(this.stylesJSONObject, newStylesJSONObject);
            }
            for (JSONObject viewportSize : _viewportSizes) {
                if (viewportSize.equals((Object)ViewportSize.DESKTOP)) continue;
                this._updateCustomCSSViewports(itemConfigJSONObject, (ViewportSize)viewportSize);
                this._updateViewportStyleJSONObjects(itemConfigJSONObject, (ViewportSize)viewportSize);
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get available style names", (Throwable)exception);
        }
    }

    private String _getColor(String property) {
        JSONObject configJSONObject = this.getItemConfigJSONObject();
        Object configColorObject = configJSONObject.get(property);
        Object styleColorObject = this.stylesJSONObject.get(property);
        if (styleColorObject == null && configColorObject != null) {
            if (configColorObject instanceof String) {
                return GetterUtil.getString((Object)configColorObject);
            }
            JSONObject configColorJSONObject = configJSONObject.getJSONObject(property);
            return configColorJSONObject.getString("rgbValue", "");
        }
        if (styleColorObject != null && styleColorObject instanceof String) {
            return GetterUtil.getString((Object)styleColorObject);
        }
        if (styleColorObject != null && styleColorObject instanceof JSONObject) {
            JSONObject styleColorJSONObject = this.stylesJSONObject.getJSONObject(property);
            return styleColorJSONObject.getString("rgbValue", "");
        }
        return "";
    }

    private String _getColorCssClass(String property) {
        JSONObject configJSONObject = this.getItemConfigJSONObject();
        JSONObject configColorJSONObject = configJSONObject.getJSONObject(property);
        JSONObject styleColorJSONObject = this.stylesJSONObject.getJSONObject(property);
        if (!(styleColorJSONObject != null && styleColorJSONObject.has("cssClass") || configColorJSONObject == null)) {
            return configColorJSONObject.getString("cssClass", configColorJSONObject.getString("color", ""));
        }
        if (styleColorJSONObject == null) {
            String styleColor = this.stylesJSONObject.getString(property);
            if (!styleColor.startsWith("#")) {
                return styleColor;
            }
            return "";
        }
        return styleColorJSONObject.getString("cssClass", styleColorJSONObject.getString("color", ""));
    }

    private String _getStringStyleProperty(String propertyKey) {
        Object object = this._getStyleProperty(propertyKey);
        if (Validator.isNull((Object)object)) {
            return "";
        }
        return String.valueOf(object);
    }

    private Object _getStyleProperty(String propertyKey) {
        JSONObject configJSONObject = this.getItemConfigJSONObject();
        Object configValue = configJSONObject.get(propertyKey);
        Object styleValue = this.stylesJSONObject.get(propertyKey);
        if (configValue != null && styleValue == null) {
            return configValue;
        }
        if (styleValue != null) {
            return styleValue;
        }
        return CommonStylesUtil.getDefaultStyleValue(propertyKey);
    }

    private void _updateCustomCSSViewports(JSONObject itemConfigJSONObject, ViewportSize viewportSize) {
        JSONObject viewportItemConfigJSONObject = itemConfigJSONObject.getJSONObject(viewportSize.getViewportSizeId());
        if (viewportItemConfigJSONObject != null && viewportItemConfigJSONObject.has("customCSS")) {
            this._customCSSViewports.put(viewportSize.getViewportSizeId(), viewportItemConfigJSONObject.getString("customCSS"));
        }
    }

    private void _updateItemConfigValues(JSONObject currentJSONObject, JSONObject newJSONObject) throws Exception {
        List<String> availableStyleNames = CommonStylesUtil.getAvailableStyleNames();
        for (String styleName : availableStyleNames) {
            if (!newJSONObject.has(styleName)) continue;
            Object styleValue = newJSONObject.get(styleName);
            if (Objects.equals(styleValue, CommonStylesUtil.getDefaultStyleValue(styleName))) {
                currentJSONObject.remove(styleName);
                continue;
            }
            currentJSONObject.put(styleName, styleValue);
        }
    }

    private void _updateViewportStyleJSONObjects(JSONObject itemConfigJSONObject, ViewportSize viewportSize) {
        List<String> availableStyleNames = CommonStylesUtil.getAvailableStyleNames();
        JSONObject viewportItemConfigJSONObject = itemConfigJSONObject.getJSONObject(viewportSize.getViewportSizeId());
        if (ListUtil.isEmpty(availableStyleNames) || viewportItemConfigJSONObject == null) {
            return;
        }
        JSONObject newStylesJSONObject = viewportItemConfigJSONObject.getJSONObject("styles");
        if (newStylesJSONObject == null || newStylesJSONObject.length() == 0) {
            return;
        }
        JSONObject currentViewportStyleJSONObject = this.viewportStyleJSONObjects.getOrDefault(viewportSize.getViewportSizeId(), JSONFactoryUtil.createJSONObject());
        for (String styleName : availableStyleNames) {
            if (!newStylesJSONObject.has(styleName)) continue;
            currentViewportStyleJSONObject.put(styleName, newStylesJSONObject.get(styleName));
        }
        this.viewportStyleJSONObjects.put(viewportSize.getViewportSizeId(), currentViewportStyleJSONObject);
    }
}

