/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.layout.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the LayoutLocalization service. Represents a row in the &quot;LayoutLocalization&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.layout.model.impl.LayoutLocalizationModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.layout.model.impl.LayoutLocalizationImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutLocalization
 * @generated
 */
@ProviderType
public interface LayoutLocalizationModel
	extends BaseModel<LayoutLocalization>, CTModel<LayoutLocalization>,
			MVCCModel, ShardedModel, StagedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a layout localization model instance should use the {@link LayoutLocalization} interface instead.
	 */

	/**
	 * Returns the primary key of this layout localization.
	 *
	 * @return the primary key of this layout localization
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this layout localization.
	 *
	 * @param primaryKey the primary key of this layout localization
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this layout localization.
	 *
	 * @return the mvcc version of this layout localization
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this layout localization.
	 *
	 * @param mvccVersion the mvcc version of this layout localization
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this layout localization.
	 *
	 * @return the ct collection ID of this layout localization
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this layout localization.
	 *
	 * @param ctCollectionId the ct collection ID of this layout localization
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the uuid of this layout localization.
	 *
	 * @return the uuid of this layout localization
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this layout localization.
	 *
	 * @param uuid the uuid of this layout localization
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the layout localization ID of this layout localization.
	 *
	 * @return the layout localization ID of this layout localization
	 */
	public long getLayoutLocalizationId();

	/**
	 * Sets the layout localization ID of this layout localization.
	 *
	 * @param layoutLocalizationId the layout localization ID of this layout localization
	 */
	public void setLayoutLocalizationId(long layoutLocalizationId);

	/**
	 * Returns the group ID of this layout localization.
	 *
	 * @return the group ID of this layout localization
	 */
	public long getGroupId();

	/**
	 * Sets the group ID of this layout localization.
	 *
	 * @param groupId the group ID of this layout localization
	 */
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this layout localization.
	 *
	 * @return the company ID of this layout localization
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this layout localization.
	 *
	 * @param companyId the company ID of this layout localization
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the create date of this layout localization.
	 *
	 * @return the create date of this layout localization
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this layout localization.
	 *
	 * @param createDate the create date of this layout localization
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this layout localization.
	 *
	 * @return the modified date of this layout localization
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this layout localization.
	 *
	 * @param modifiedDate the modified date of this layout localization
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the content of this layout localization.
	 *
	 * @return the content of this layout localization
	 */
	@AutoEscape
	public String getContent();

	/**
	 * Sets the content of this layout localization.
	 *
	 * @param content the content of this layout localization
	 */
	public void setContent(String content);

	/**
	 * Returns the language ID of this layout localization.
	 *
	 * @return the language ID of this layout localization
	 */
	@AutoEscape
	public String getLanguageId();

	/**
	 * Sets the language ID of this layout localization.
	 *
	 * @param languageId the language ID of this layout localization
	 */
	public void setLanguageId(String languageId);

	/**
	 * Returns the plid of this layout localization.
	 *
	 * @return the plid of this layout localization
	 */
	public long getPlid();

	/**
	 * Sets the plid of this layout localization.
	 *
	 * @param plid the plid of this layout localization
	 */
	public void setPlid(long plid);

	/**
	 * Returns the last publish date of this layout localization.
	 *
	 * @return the last publish date of this layout localization
	 */
	public Date getLastPublishDate();

	/**
	 * Sets the last publish date of this layout localization.
	 *
	 * @param lastPublishDate the last publish date of this layout localization
	 */
	public void setLastPublishDate(Date lastPublishDate);

	@Override
	public LayoutLocalization cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}