/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLocalServiceUtil;
import com.liferay.layout.util.structure.StyledLayoutStructureItem;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;

public class FragmentStyledLayoutStructureItem
extends StyledLayoutStructureItem {
    private static final Log _log = LogFactoryUtil.getLog(FragmentStyledLayoutStructureItem.class);
    private long _fragmentEntryLinkId;
    private boolean _indexed = true;

    public FragmentStyledLayoutStructureItem(String parentItemId) {
        super(parentItemId);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FragmentStyledLayoutStructureItem)) {
            return false;
        }
        FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)object;
        if (!Objects.equals(this._fragmentEntryLinkId, fragmentStyledLayoutStructureItem._fragmentEntryLinkId)) {
            return false;
        }
        return super.equals(object);
    }

    public String getFragmentEntryLinkCssClass(FragmentEntryLink fragmentEntryLink) {
        return this._normalizeCssClass("lfr-layout-structure-item-" + this._getFragmentEntryLinkIdentifier(fragmentEntryLink));
    }

    public long getFragmentEntryLinkId() {
        return this._fragmentEntryLinkId;
    }

    @Override
    public JSONObject getItemConfigJSONObject() {
        JSONObject jsonObject = super.getItemConfigJSONObject();
        JSONObject stylesJSONObject = jsonObject.getJSONObject("styles");
        if (stylesJSONObject == null) {
            stylesJSONObject = JSONFactoryUtil.createJSONObject();
        }
        return jsonObject.put("fragmentEntryLinkId", String.valueOf(this._fragmentEntryLinkId)).put("indexed", () -> {
            if (this._indexed) {
                return null;
            }
            return false;
        }).put("styles", stylesJSONObject);
    }

    @Override
    public String getItemType() {
        return "fragment";
    }

    @Override
    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this.getItemId());
    }

    public boolean isIndexed() {
        return this._indexed;
    }

    public void setFragmentEntryLinkId(long fragmentEntryLinkId) {
        this._fragmentEntryLinkId = fragmentEntryLinkId;
    }

    public void setIndexed(boolean indexed) {
        this._indexed = indexed;
    }

    @Override
    public void updateItemConfig(JSONObject itemConfigJSONObject) {
        super.updateItemConfig(itemConfigJSONObject);
        if (itemConfigJSONObject.has("indexed")) {
            this.setIndexed(itemConfigJSONObject.getBoolean("indexed"));
        }
        if (itemConfigJSONObject.has("fragmentEntryLinkId")) {
            this.setFragmentEntryLinkId(itemConfigJSONObject.getLong("fragmentEntryLinkId"));
        }
    }

    private JSONObject _createJSONObject(String value) {
        try {
            return JSONFactoryUtil.createJSONObject((String)value);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return JSONFactoryUtil.createJSONObject();
        }
    }

    private String _getFragmentEntryLinkIdentifier(FragmentEntryLink fragmentEntryLink) {
        String rendererKey = fragmentEntryLink.getRendererKey();
        if (Validator.isNotNull((String)rendererKey)) {
            return rendererKey;
        }
        JSONObject jsonObject = this._createJSONObject(fragmentEntryLink.getEditableValues());
        String portletId = jsonObject.getString("portletId");
        if (Validator.isNotNull((String)portletId)) {
            return PortletIdCodec.decodePortletName((String)portletId);
        }
        FragmentEntry fragmentEntry = FragmentEntryLocalServiceUtil.fetchFragmentEntry((long)fragmentEntryLink.getFragmentEntryId());
        if (fragmentEntry != null) {
            return fragmentEntry.getFragmentEntryKey();
        }
        return "";
    }

    private String _normalizeCssClass(String cssClass) {
        cssClass = StringUtil.toLowerCase((String)cssClass);
        return cssClass.replaceAll("[^A-Za-z0-9-]", "-");
    }
}

