/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.layout.util.structure.CollectionItemLayoutStructureItem;
import com.liferay.layout.util.structure.CollectionStyledLayoutStructureItem;
import com.liferay.layout.util.structure.ColumnLayoutStructureItem;
import com.liferay.layout.util.structure.ContainerStyledLayoutStructureItem;
import com.liferay.layout.util.structure.DropZoneLayoutStructureItem;
import com.liferay.layout.util.structure.FormStyledLayoutStructureItem;
import com.liferay.layout.util.structure.FragmentDropZoneLayoutStructureItem;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.util.structure.RootLayoutStructureItem;
import com.liferay.layout.util.structure.RowStyledLayoutStructureItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LayoutStructureItemUtil {
    public static LayoutStructureItem create(String itemType, String parentItemId) {
        if (Objects.equals(itemType, "collection")) {
            return new CollectionStyledLayoutStructureItem(parentItemId);
        }
        if (Objects.equals(itemType, "collection-item")) {
            return new CollectionItemLayoutStructureItem(parentItemId);
        }
        if (Objects.equals(itemType, "column")) {
            return new ColumnLayoutStructureItem(parentItemId);
        }
        if (Objects.equals(itemType, "container")) {
            return new ContainerStyledLayoutStructureItem(parentItemId);
        }
        if (Objects.equals(itemType, "drop-zone")) {
            return new DropZoneLayoutStructureItem(parentItemId);
        }
        if (Objects.equals(itemType, "form")) {
            return new FormStyledLayoutStructureItem(parentItemId);
        }
        if (Objects.equals(itemType, "fragment")) {
            return new FragmentStyledLayoutStructureItem(parentItemId);
        }
        if (Objects.equals(itemType, "fragment-drop-zone")) {
            return new FragmentDropZoneLayoutStructureItem(parentItemId);
        }
        if (Objects.equals(itemType, "root")) {
            return new RootLayoutStructureItem();
        }
        if (Objects.equals(itemType, "row")) {
            return new RowStyledLayoutStructureItem(parentItemId);
        }
        return null;
    }

    public static LayoutStructureItem getAncestor(String itemId, String itemType, LayoutStructure layoutStructure) {
        LayoutStructureItem layoutStructureItem = layoutStructure.getLayoutStructureItem(itemId);
        LayoutStructureItem parentLayoutStructureItem = layoutStructure.getLayoutStructureItem(layoutStructureItem.getParentItemId());
        if (parentLayoutStructureItem == null) {
            return null;
        }
        if (Objects.equals(parentLayoutStructureItem.getItemType(), itemType)) {
            return parentLayoutStructureItem;
        }
        if (Objects.equals(parentLayoutStructureItem.getItemType(), "root")) {
            return null;
        }
        return LayoutStructureItemUtil.getAncestor(parentLayoutStructureItem.getItemId(), itemType, layoutStructure);
    }

    public static List<String> getChildrenItemIds(String itemId, LayoutStructure layoutStructure) {
        ArrayList<String> childrenItemIds = new ArrayList<String>();
        LayoutStructureItem layoutStructureItem = layoutStructure.getLayoutStructureItem(itemId);
        if (layoutStructureItem == null) {
            return childrenItemIds;
        }
        for (String childItemId : layoutStructureItem.getChildrenItemIds()) {
            childrenItemIds.add(childItemId);
            LayoutStructureItem childLayoutStructureItem = layoutStructure.getLayoutStructureItem(childItemId);
            childrenItemIds.addAll(LayoutStructureItemUtil.getChildrenItemIds(childLayoutStructureItem.getItemId(), layoutStructure));
        }
        return childrenItemIds;
    }

    public static boolean hasAncestor(String itemId, String itemType, LayoutStructure layoutStructure) {
        LayoutStructureItem layoutStructureItem = layoutStructure.getLayoutStructureItem(itemId);
        LayoutStructureItem parentLayoutStructureItem = layoutStructure.getLayoutStructureItem(layoutStructureItem.getParentItemId());
        if (parentLayoutStructureItem == null) {
            return false;
        }
        if (Objects.equals(parentLayoutStructureItem.getItemType(), itemType)) {
            return true;
        }
        if (Objects.equals(parentLayoutStructureItem.getItemType(), "root")) {
            return false;
        }
        return LayoutStructureItemUtil.hasAncestor(parentLayoutStructureItem.getItemId(), itemType, layoutStructure);
    }
}

