/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.StyledLayoutStructureItem;
import com.liferay.layout.util.structure.collection.EmptyCollectionOptions;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CollectionStyledLayoutStructureItem
extends StyledLayoutStructureItem {
    private static final ViewportSize[] _viewportSizes = ViewportSize.values();
    private String _align = "";
    private JSONObject _collectionJSONObject;
    private boolean _displayAllItems;
    private boolean _displayAllPages = true;
    private EmptyCollectionOptions _emptyCollectionOptions;
    private String _flexWrap = "";
    private boolean _gutters = true;
    private String _justify = "";
    private String _listItemStyle;
    private String _listStyle;
    private int _numberOfColumns = 1;
    private int _numberOfItems = 5;
    private int _numberOfItemsPerPage = 20;
    private int _numberOfPages = 5;
    private String _paginationType = "numeric";
    private boolean _showAllItems;
    private String _templateKey;
    private String _verticalAlignment = "start";
    private final Map<String, JSONObject> _viewportConfigurationJSONObjects = new HashMap<String, JSONObject>();

    public CollectionStyledLayoutStructureItem(String parentItemId) {
        super(parentItemId);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CollectionStyledLayoutStructureItem)) {
            return false;
        }
        CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem = (CollectionStyledLayoutStructureItem)object;
        if (!(Objects.equals(this._collectionJSONObject, collectionStyledLayoutStructureItem._collectionJSONObject) && Objects.equals(this._displayAllItems, collectionStyledLayoutStructureItem._displayAllItems) && Objects.equals(this._displayAllPages, collectionStyledLayoutStructureItem._displayAllPages) && Objects.equals(this._emptyCollectionOptions, collectionStyledLayoutStructureItem._emptyCollectionOptions) && Objects.equals(this._gutters, collectionStyledLayoutStructureItem._gutters) && Objects.equals(this._listStyle, collectionStyledLayoutStructureItem._listStyle) && Objects.equals(this._numberOfColumns, collectionStyledLayoutStructureItem._numberOfColumns) && Objects.equals(this._numberOfItems, collectionStyledLayoutStructureItem._numberOfItems) && Objects.equals(this._numberOfItemsPerPage, collectionStyledLayoutStructureItem._numberOfItemsPerPage) && Objects.equals(this._numberOfPages, collectionStyledLayoutStructureItem._numberOfPages) && Objects.equals(this._paginationType, collectionStyledLayoutStructureItem._paginationType) && Objects.equals(this._showAllItems, collectionStyledLayoutStructureItem._showAllItems) && Objects.equals(this._verticalAlignment, collectionStyledLayoutStructureItem._verticalAlignment))) {
            return false;
        }
        return super.equals(object);
    }

    public String getAlign() {
        return this._align;
    }

    public JSONObject getCollectionJSONObject() {
        return this._collectionJSONObject;
    }

    public EmptyCollectionOptions getEmptyCollectionOptions() {
        return this._emptyCollectionOptions;
    }

    public String getFlexWrap() {
        return this._flexWrap;
    }

    @Override
    public JSONObject getItemConfigJSONObject() {
        JSONObject jsonObject = super.getItemConfigJSONObject();
        jsonObject = jsonObject.put("align", () -> {
            if (Validator.isBlank((String)this._align)) {
                return null;
            }
            return this._align;
        }).put("collection", this._collectionJSONObject).put("displayAllItems", this._displayAllItems).put("displayAllPages", this._displayAllPages).put("emptyCollectionOptions", () -> {
            if (this._emptyCollectionOptions == null) {
                return null;
            }
            return this._emptyCollectionOptions.toJSONObject();
        }).put("flexWrap", () -> {
            if (Validator.isBlank((String)this._flexWrap)) {
                return null;
            }
            return this._flexWrap;
        }).put("gutters", this._gutters).put("justify", () -> {
            if (Validator.isBlank((String)this._justify)) {
                return null;
            }
            return this._justify;
        }).put("listItemStyle", this._listItemStyle).put("listStyle", this._listStyle).put("numberOfColumns", this._numberOfColumns).put("numberOfItems", this._numberOfItems).put("numberOfItemsPerPage", this._numberOfItemsPerPage).put("numberOfPages", this._numberOfPages).put("paginationType", this._paginationType).put("showAllItems", this._showAllItems).put("templateKey", this._templateKey).put("verticalAlignment", () -> {
            if (Objects.equals(this._verticalAlignment, "start")) {
                return null;
            }
            return this._verticalAlignment;
        });
        for (ViewportSize viewportSize : _viewportSizes) {
            if (viewportSize.equals((Object)ViewportSize.DESKTOP)) continue;
            JSONObject currentViewportConfigurationJSONObject = JSONFactoryUtil.createJSONObject();
            if (jsonObject.has(viewportSize.getViewportSizeId())) {
                currentViewportConfigurationJSONObject = jsonObject.getJSONObject(viewportSize.getViewportSizeId());
            }
            JSONObject viewportConfigurationJSONObject = this._viewportConfigurationJSONObjects.getOrDefault(viewportSize.getViewportSizeId(), JSONFactoryUtil.createJSONObject());
            currentViewportConfigurationJSONObject.put("numberOfColumns", viewportConfigurationJSONObject.get("numberOfColumns"));
            jsonObject.put(viewportSize.getViewportSizeId(), currentViewportConfigurationJSONObject);
        }
        return jsonObject;
    }

    @Override
    public String getItemType() {
        return "collection";
    }

    public String getJustify() {
        return this._justify;
    }

    public String getListItemStyle() {
        return this._listItemStyle;
    }

    public String getListStyle() {
        return this._listStyle;
    }

    public int getNumberOfColumns() {
        return this._numberOfColumns;
    }

    public int getNumberOfItems() {
        return this._numberOfItems;
    }

    public int getNumberOfItemsPerPage() {
        return this._numberOfItemsPerPage;
    }

    public int getNumberOfPages() {
        return this._numberOfPages;
    }

    public String getPaginationType() {
        return this._paginationType;
    }

    public String getTemplateKey() {
        return this._templateKey;
    }

    public String getVerticalAlignment() {
        return this._verticalAlignment;
    }

    public Map<String, JSONObject> getViewportConfigurationJSONObjects() {
        return this._viewportConfigurationJSONObjects;
    }

    @Override
    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this.getItemId());
    }

    public boolean isDisplayAllItems() {
        return this._displayAllItems;
    }

    public boolean isDisplayAllPages() {
        return this._displayAllPages;
    }

    public boolean isGutters() {
        return this._gutters;
    }

    @Deprecated
    public boolean isShowAllItems() {
        return this._showAllItems;
    }

    public void setAlign(String align) {
        this._align = align;
    }

    public void setCollectionJSONObject(JSONObject collectionJSONObject) {
        this._collectionJSONObject = collectionJSONObject;
    }

    public void setDisplayAllItems(Boolean displayAllItems) {
        this._displayAllItems = displayAllItems == null ? false : displayAllItems;
    }

    public void setDisplayAllPages(Boolean displayAllPages) {
        this._displayAllPages = displayAllPages == null ? true : displayAllPages;
    }

    public void setEmptyCollectionOptions(EmptyCollectionOptions emptyCollectionOptions) {
        this._emptyCollectionOptions = emptyCollectionOptions;
    }

    public void setFlexWrap(String flexWrap) {
        this._flexWrap = flexWrap;
    }

    public void setGutters(boolean gutters) {
        this._gutters = gutters;
    }

    public void setJustify(String justify) {
        this._justify = justify;
    }

    public void setListItemStyle(String listItemStyle) {
        this._listItemStyle = listItemStyle;
    }

    public void setListStyle(String listStyle) {
        this._listStyle = listStyle;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this._numberOfColumns = numberOfColumns;
    }

    public void setNumberOfItems(int numberOfItems) {
        this._numberOfItems = numberOfItems;
    }

    public void setNumberOfItemsPerPage(int numberOfItemsPerPage) {
        this._numberOfItemsPerPage = numberOfItemsPerPage;
    }

    public void setNumberOfPages(int numberOfPages) {
        this._numberOfPages = numberOfPages;
    }

    public void setPaginationType(String paginationType) {
        this._paginationType = paginationType;
    }

    @Deprecated
    public void setShowAllItems(Boolean showAllItems) {
        this._showAllItems = showAllItems == null ? false : showAllItems;
    }

    public void setTemplateKey(String templateKey) {
        this._templateKey = templateKey;
    }

    public void setVerticalAlignment(String verticalAlignment) {
        this._verticalAlignment = verticalAlignment;
    }

    public void setViewportConfiguration(String viewportSizeId, JSONObject configurationJSONObject) {
        this._viewportConfigurationJSONObjects.put(viewportSizeId, this._viewportConfigurationJSONObjects.getOrDefault(viewportSizeId, JSONFactoryUtil.createJSONObject()).put("numberOfColumns", () -> {
            if (configurationJSONObject.has("numberOfColumns")) {
                return configurationJSONObject.getInt("numberOfColumns");
            }
            return null;
        }));
    }

    @Override
    public void updateItemConfig(JSONObject itemConfigJSONObject) {
        super.updateItemConfig(itemConfigJSONObject);
        if (itemConfigJSONObject.has("align")) {
            this.setAlign(itemConfigJSONObject.getString("align"));
        }
        if (itemConfigJSONObject.has("collection")) {
            this.setCollectionJSONObject(itemConfigJSONObject.getJSONObject("collection"));
        }
        if (itemConfigJSONObject.has("displayAllItems")) {
            this.setDisplayAllItems(itemConfigJSONObject.getBoolean("displayAllItems"));
        }
        if (itemConfigJSONObject.has("displayAllPages")) {
            this.setDisplayAllPages(itemConfigJSONObject.getBoolean("displayAllPages"));
        }
        if (itemConfigJSONObject.has("emptyCollectionOptions")) {
            this.setEmptyCollectionOptions(EmptyCollectionOptions.of(itemConfigJSONObject.getJSONObject("emptyCollectionOptions")));
        }
        if (itemConfigJSONObject.has("flexWrap")) {
            this.setFlexWrap(itemConfigJSONObject.getString("flexWrap"));
        }
        if (itemConfigJSONObject.has("gutters")) {
            this.setGutters(itemConfigJSONObject.getBoolean("gutters"));
        }
        if (itemConfigJSONObject.has("justify")) {
            this.setJustify(itemConfigJSONObject.getString("justify"));
        }
        if (itemConfigJSONObject.has("showAllItems")) {
            this.setShowAllItems(itemConfigJSONObject.getBoolean("showAllItems"));
        }
        if (itemConfigJSONObject.has("listItemStyle")) {
            this.setListItemStyle(itemConfigJSONObject.getString("listItemStyle"));
        }
        if (itemConfigJSONObject.has("listStyle")) {
            this.setListStyle(itemConfigJSONObject.getString("listStyle"));
        }
        if (itemConfigJSONObject.has("numberOfColumns")) {
            this.setNumberOfColumns(itemConfigJSONObject.getInt("numberOfColumns"));
        }
        if (itemConfigJSONObject.has("numberOfItems")) {
            this.setNumberOfItems(itemConfigJSONObject.getInt("numberOfItems"));
        }
        if (itemConfigJSONObject.has("numberOfItemsPerPage")) {
            this.setNumberOfItemsPerPage(itemConfigJSONObject.getInt("numberOfItemsPerPage"));
        }
        if (itemConfigJSONObject.has("numberOfPages")) {
            this.setNumberOfPages(itemConfigJSONObject.getInt("numberOfPages"));
        }
        if (itemConfigJSONObject.has("paginationType")) {
            this.setPaginationType(itemConfigJSONObject.getString("paginationType"));
        }
        if (itemConfigJSONObject.has("templateKey")) {
            this.setTemplateKey(itemConfigJSONObject.getString("templateKey"));
        }
        if (itemConfigJSONObject.has("verticalAlignment")) {
            this.setVerticalAlignment(itemConfigJSONObject.getString("verticalAlignment"));
        }
        for (ViewportSize viewportSize : _viewportSizes) {
            if (viewportSize.equals((Object)ViewportSize.DESKTOP) || !itemConfigJSONObject.has(viewportSize.getViewportSizeId())) continue;
            this.setViewportConfiguration(viewportSize.getViewportSizeId(), itemConfigJSONObject.getJSONObject(viewportSize.getViewportSizeId()));
        }
    }
}

