/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util;

import com.liferay.info.pagination.Pagination;
import com.liferay.portal.util.PropsValues;
import java.util.Objects;

public class CollectionPaginationUtil {
    public static final String PAGINATION_TYPE_NONE = "none";
    public static final String PAGINATION_TYPE_NUMERIC = "numeric";
    public static final String PAGINATION_TYPE_REGULAR = "regular";
    public static final String PAGINATION_TYPE_SIMPLE = "simple";

    public static Pagination getPagination(int activePage, boolean displayAllItems, int numberOfItems, int numberOfItemsPerPage, String paginationType) {
        if (CollectionPaginationUtil.isPaginationEnabled(paginationType)) {
            if (numberOfItemsPerPage <= 0 || numberOfItemsPerPage > PropsValues.SEARCH_CONTAINER_PAGE_MAX_DELTA) {
                numberOfItemsPerPage = PropsValues.SEARCH_CONTAINER_PAGE_MAX_DELTA;
            }
            if (activePage < 1) {
                activePage = 1;
            }
            int start = (activePage - 1) * numberOfItemsPerPage;
            return Pagination.of((int)(start + numberOfItemsPerPage), (int)start);
        }
        if (displayAllItems) {
            return Pagination.of((int)-1, (int)-1);
        }
        return Pagination.of((int)numberOfItems, (int)0);
    }

    public static int getTotalNumberOfItems(int count, boolean displayAllPages, boolean displayAllItems, int numberOfItems, int numberOfItemsPerPage, int numberOfPages, String paginationType) {
        if (!CollectionPaginationUtil.isPaginationEnabled(paginationType)) {
            if (displayAllItems) {
                return count;
            }
            return Math.min(count, numberOfItems);
        }
        if (displayAllPages || numberOfPages <= 0) {
            return count;
        }
        if (numberOfItemsPerPage <= 0 || numberOfItemsPerPage > PropsValues.SEARCH_CONTAINER_PAGE_MAX_DELTA) {
            numberOfItemsPerPage = PropsValues.SEARCH_CONTAINER_PAGE_MAX_DELTA;
        }
        return Math.min(count, numberOfPages * numberOfItemsPerPage);
    }

    public static boolean isPaginationEnabled(String paginationType) {
        return Objects.equals(paginationType, PAGINATION_TYPE_NUMERIC) || Objects.equals(paginationType, PAGINATION_TYPE_REGULAR) || Objects.equals(paginationType, PAGINATION_TYPE_SIMPLE);
    }
}

