/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ColumnLayoutStructureItem
extends LayoutStructureItem {
    private static final ViewportSize[] _viewportSizes = ViewportSize.values();
    private int _size;
    private final Map<String, JSONObject> _viewportConfigurationJSONObjects = new HashMap<String, JSONObject>();

    public ColumnLayoutStructureItem(String parentItemId) {
        super(parentItemId);
    }

    public ColumnLayoutStructureItem(String itemId, String parentItemId) {
        super(itemId, parentItemId);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ColumnLayoutStructureItem)) {
            return false;
        }
        ColumnLayoutStructureItem columnLayoutStructureItem = (ColumnLayoutStructureItem)object;
        if (!Objects.equals(this._size, columnLayoutStructureItem._size)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public JSONObject getItemConfigJSONObject() {
        JSONObject jsonObject = JSONUtil.put((String)"size", (Object)this._size);
        for (ViewportSize viewportSize : _viewportSizes) {
            if (viewportSize.equals((Object)ViewportSize.DESKTOP)) continue;
            jsonObject.put(viewportSize.getViewportSizeId(), JSONUtil.put((String)"size", () -> {
                JSONObject viewportConfigurationJSONObject = this._viewportConfigurationJSONObjects.getOrDefault(viewportSize.getViewportSizeId(), JSONFactoryUtil.createJSONObject());
                return viewportConfigurationJSONObject.get("size");
            }));
        }
        return jsonObject;
    }

    @Override
    public String getItemType() {
        return "column";
    }

    public int getSize() {
        return this._size;
    }

    public Map<String, JSONObject> getViewportConfigurationJSONObjects() {
        return this._viewportConfigurationJSONObjects;
    }

    @Override
    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this.getItemId());
    }

    public void setSize(int size) {
        this._size = size;
    }

    public void setViewportConfiguration(String viewportSizeId, JSONObject configurationJSONObject) {
        this._viewportConfigurationJSONObjects.put(viewportSizeId, this._viewportConfigurationJSONObjects.getOrDefault(viewportSizeId, JSONFactoryUtil.createJSONObject()).put("size", () -> {
            if (configurationJSONObject.has("size")) {
                return configurationJSONObject.getInt("size");
            }
            return null;
        }));
    }

    @Override
    public void updateItemConfig(JSONObject itemConfigJSONObject) {
        if (itemConfigJSONObject.has("size")) {
            this.setSize(itemConfigJSONObject.getInt("size"));
        }
        for (ViewportSize viewportSize : _viewportSizes) {
            if (viewportSize.equals((Object)ViewportSize.DESKTOP) || !itemConfigJSONObject.has(viewportSize.getViewportSizeId())) continue;
            this.setViewportConfiguration(viewportSize.getViewportSizeId(), itemConfigJSONObject.getJSONObject(viewportSize.getViewportSizeId()));
        }
    }
}

