/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;

public class LayoutStructureRule {
    private JSONArray _actionsJSONArray;
    private JSONArray _conditionsJSONArray;
    private String _conditionType = "all";
    private String _id;
    private String _name;

    public static LayoutStructureRule of(JSONObject jsonObject) {
        return new LayoutStructureRule(jsonObject.getJSONArray("actions"), jsonObject.getJSONArray("conditions"), jsonObject.getString("conditionType"), jsonObject.getString("id"), jsonObject.getString("name"));
    }

    public LayoutStructureRule(JSONArray actionsJSONArray, JSONArray conditionsJSONArray, String conditionType, String id, String name) {
        this._actionsJSONArray = actionsJSONArray;
        this._conditionsJSONArray = conditionsJSONArray;
        if (Validator.isNotNull((String)conditionType)) {
            this._conditionType = conditionType;
        }
        this._id = id;
        this._name = name;
    }

    public LayoutStructureRule(String id, String name) {
        this(JSONFactoryUtil.createJSONArray(), JSONFactoryUtil.createJSONArray(), null, id, name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LayoutStructureRule)) {
            return false;
        }
        LayoutStructureRule layoutStructureRule = (LayoutStructureRule)object;
        return Objects.equals(this._id, layoutStructureRule._id) && Objects.equals(this._name, layoutStructureRule._name);
    }

    public JSONArray getActionsJSONArray() {
        return this._actionsJSONArray;
    }

    public JSONArray getConditionsJSONArray() {
        return this._conditionsJSONArray;
    }

    public String getConditionType() {
        if (Validator.isNull((String)this._conditionType)) {
            return "all";
        }
        return this._conditionType;
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this.getId());
    }

    public void setActionsJSONArray(JSONArray actionsJSONArray) {
        this._actionsJSONArray = actionsJSONArray;
    }

    public void setConditionsJSONArray(JSONArray conditionsJSONArray) {
        this._conditionsJSONArray = conditionsJSONArray;
    }

    public void setConditionType(String conditionType) {
        this._conditionType = conditionType;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setName(String name) {
        this._name = name;
    }

    public JSONObject toJSONObject() {
        return JSONUtil.put((String)"actions", (Object)this._actionsJSONArray).put("conditions", this._conditionsJSONArray).put("conditionType", this._conditionType).put("id", this.getId()).put("name", this.getName());
    }

    public String toString() {
        JSONObject jsonObject = this.toJSONObject();
        return jsonObject.toString();
    }
}

