/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.StyledLayoutStructureItem;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RowStyledLayoutStructureItem
extends StyledLayoutStructureItem {
    private static final ViewportSize[] _viewportSizes = ViewportSize.values();
    private boolean _gutters = true;
    private boolean _indexed = true;
    private Integer _modulesPerRow;
    private int _numberOfColumns;
    private boolean _reverseOrder;
    private String _verticalAlignment = "top";
    private final Map<String, JSONObject> _viewportConfigurationJSONObjects = new HashMap<String, JSONObject>();

    public RowStyledLayoutStructureItem(String parentItemId) {
        super(parentItemId);
    }

    public RowStyledLayoutStructureItem(String itemId, String parentItemId) {
        super(itemId, parentItemId);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RowStyledLayoutStructureItem)) {
            return false;
        }
        RowStyledLayoutStructureItem rowStyledLayoutStructureItem = (RowStyledLayoutStructureItem)object;
        if (!(Objects.equals(this._gutters, rowStyledLayoutStructureItem._gutters) && Objects.equals(this._modulesPerRow, rowStyledLayoutStructureItem._modulesPerRow) && Objects.equals(this._numberOfColumns, rowStyledLayoutStructureItem._numberOfColumns) && Objects.equals(this._reverseOrder, rowStyledLayoutStructureItem._reverseOrder) && Objects.equals(this._verticalAlignment, rowStyledLayoutStructureItem._verticalAlignment))) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public JSONObject getItemConfigJSONObject() {
        JSONObject jsonObject = super.getItemConfigJSONObject();
        jsonObject.put("gutters", this._gutters).put("indexed", () -> {
            if (this._indexed) {
                return null;
            }
            return false;
        }).put("modulesPerRow", this.getModulesPerRow()).put("numberOfColumns", this._numberOfColumns).put("reverseOrder", this._reverseOrder).put("verticalAlignment", () -> {
            if (Objects.equals(this._verticalAlignment, "top")) {
                return null;
            }
            return this._verticalAlignment;
        });
        for (ViewportSize viewportSize : _viewportSizes) {
            if (viewportSize.equals((Object)ViewportSize.DESKTOP)) continue;
            JSONObject currentViewportConfigurationJSONObject = JSONFactoryUtil.createJSONObject();
            if (jsonObject.has(viewportSize.getViewportSizeId())) {
                currentViewportConfigurationJSONObject = jsonObject.getJSONObject(viewportSize.getViewportSizeId());
            }
            JSONObject viewportConfigurationJSONObject = this._viewportConfigurationJSONObjects.getOrDefault(viewportSize.getViewportSizeId(), JSONFactoryUtil.createJSONObject());
            currentViewportConfigurationJSONObject.put("modulesPerRow", viewportConfigurationJSONObject.get("modulesPerRow")).put("reverseOrder", viewportConfigurationJSONObject.get("reverseOrder")).put("verticalAlignment", viewportConfigurationJSONObject.get("verticalAlignment"));
            jsonObject.put(viewportSize.getViewportSizeId(), currentViewportConfigurationJSONObject);
        }
        return jsonObject;
    }

    @Override
    public String getItemType() {
        return "row";
    }

    public int getModulesPerRow() {
        if (this._modulesPerRow == null) {
            return this._numberOfColumns;
        }
        return this._modulesPerRow;
    }

    public int getNumberOfColumns() {
        return this._numberOfColumns;
    }

    public String getVerticalAlignment() {
        return this._verticalAlignment;
    }

    public Map<String, JSONObject> getViewportConfigurationJSONObjects() {
        return this._viewportConfigurationJSONObjects;
    }

    @Override
    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this.getItemId());
    }

    public boolean isGutters() {
        return this._gutters;
    }

    public boolean isIndexed() {
        return this._indexed;
    }

    public boolean isReverseOrder() {
        return this._reverseOrder;
    }

    public void setGutters(boolean gutters) {
        this._gutters = gutters;
    }

    public void setIndexed(boolean indexed) {
        this._indexed = indexed;
    }

    public void setModulesPerRow(int modulesPerRow) {
        this._modulesPerRow = modulesPerRow;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this._numberOfColumns = numberOfColumns;
    }

    public void setReverseOrder(boolean reverseOrder) {
        this._reverseOrder = reverseOrder;
    }

    public void setVerticalAlignment(String verticalAlignment) {
        this._verticalAlignment = verticalAlignment;
    }

    public void setViewportConfiguration(String viewportSizeId, JSONObject configurationJSONObject) {
        this._viewportConfigurationJSONObjects.put(viewportSizeId, this._viewportConfigurationJSONObjects.getOrDefault(viewportSizeId, JSONFactoryUtil.createJSONObject()).put("modulesPerRow", () -> {
            if (configurationJSONObject.has("modulesPerRow")) {
                return configurationJSONObject.getInt("modulesPerRow");
            }
            return null;
        }).put("reverseOrder", () -> {
            if (configurationJSONObject.has("reverseOrder")) {
                return configurationJSONObject.getBoolean("reverseOrder");
            }
            return null;
        }).put("verticalAlignment", () -> {
            if (configurationJSONObject.has("verticalAlignment")) {
                return configurationJSONObject.getString("verticalAlignment");
            }
            return null;
        }));
    }

    @Override
    public void updateItemConfig(JSONObject itemConfigJSONObject) {
        super.updateItemConfig(itemConfigJSONObject);
        if (itemConfigJSONObject.has("gutters")) {
            this.setGutters(itemConfigJSONObject.getBoolean("gutters"));
        }
        if (itemConfigJSONObject.has("modulesPerRow")) {
            this.setModulesPerRow(itemConfigJSONObject.getInt("modulesPerRow"));
        }
        if (itemConfigJSONObject.has("indexed")) {
            this.setIndexed(itemConfigJSONObject.getBoolean("indexed"));
        }
        if (itemConfigJSONObject.has("numberOfColumns")) {
            this.setNumberOfColumns(itemConfigJSONObject.getInt("numberOfColumns"));
        }
        if (itemConfigJSONObject.has("reverseOrder")) {
            this.setReverseOrder(itemConfigJSONObject.getBoolean("reverseOrder"));
        }
        if (itemConfigJSONObject.has("verticalAlignment")) {
            this.setVerticalAlignment(itemConfigJSONObject.getString("verticalAlignment"));
        }
        for (ViewportSize viewportSize : _viewportSizes) {
            if (viewportSize.equals((Object)ViewportSize.DESKTOP) || !itemConfigJSONObject.has(viewportSize.getViewportSizeId())) continue;
            this.setViewportConfiguration(viewportSize.getViewportSizeId(), itemConfigJSONObject.getJSONObject(viewportSize.getViewportSizeId()));
        }
    }
}

