/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.CommonStylesUtil;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class StyledLayoutStructureItem
extends LayoutStructureItem {
    protected static final String LAYOUT_STRUCTURE_ITEM_CSS_CLASS_PREFIX = "lfr-layout-structure-item-";
    protected JSONObject stylesJSONObject = JSONFactoryUtil.createJSONObject();
    protected Map<String, JSONObject> viewportStyleJSONObjects = new HashMap<String, JSONObject>();
    private static final Log _log = LogFactoryUtil.getLog(StyledLayoutStructureItem.class);
    private static final ViewportSize[] _viewportSizes = ViewportSize.values();
    private Set<String> _cssClasses;
    private String _customCSS;
    private final Map<String, String> _customCSSViewports = new HashMap<String, String>();
    private String _name;

    public StyledLayoutStructureItem(String parentItemId) {
        super(parentItemId);
    }

    public StyledLayoutStructureItem(String itemId, String parentItemId) {
        super(itemId, parentItemId);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StyledLayoutStructureItem)) {
            return false;
        }
        StyledLayoutStructureItem styledLayoutStructureItem = (StyledLayoutStructureItem)object;
        JSONObject stylesJSONObject = styledLayoutStructureItem.stylesJSONObject;
        for (String key : this.stylesJSONObject.keySet()) {
            if (Objects.deepEquals(GetterUtil.getString((Object)this.stylesJSONObject.get(key)), GetterUtil.getString((Object)stylesJSONObject.get(key)))) continue;
            return false;
        }
        return super.equals(object);
    }

    public JSONObject getBackgroundImageJSONObject() {
        JSONObject jsonObject = this.stylesJSONObject.getJSONObject("backgroundImage");
        if (jsonObject == null) {
            return JSONFactoryUtil.createJSONObject();
        }
        return jsonObject;
    }

    public String getCssClass() {
        return LAYOUT_STRUCTURE_ITEM_CSS_CLASS_PREFIX + this.getItemType();
    }

    public Set<String> getCssClasses() {
        return this._cssClasses;
    }

    public String getCustomCSS() {
        return this._customCSS;
    }

    public Map<String, String> getCustomCSSViewports() {
        return this._customCSSViewports;
    }

    @Override
    public JSONObject getItemConfigJSONObject() {
        JSONObject jsonObject = JSONUtil.put((String)"cssClasses", (Object)JSONFactoryUtil.createJSONArray(this._cssClasses)).put("customCSS", this._customCSS).put("name", this._name).put("styles", this.stylesJSONObject);
        for (ViewportSize viewportSize : _viewportSizes) {
            if (viewportSize.equals((Object)ViewportSize.DESKTOP)) continue;
            jsonObject.put(viewportSize.getViewportSizeId(), JSONUtil.put((String)"customCSS", (Object)this._customCSSViewports.get(viewportSize.getViewportSizeId())).put("styles", this.viewportStyleJSONObjects.getOrDefault(viewportSize.getViewportSizeId(), JSONFactoryUtil.createJSONObject())));
        }
        return jsonObject;
    }

    public String getName() {
        return this._name;
    }

    public String getStyledCssClasses() {
        return StringUtil.merge(this.getCssClasses(), (String)" ");
    }

    public String getUniqueCssClass() {
        return LAYOUT_STRUCTURE_ITEM_CSS_CLASS_PREFIX + this.getItemId();
    }

    @Override
    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this.getItemId());
    }

    public void setCssClasses(Set<String> cssClasses) {
        this._cssClasses = cssClasses;
    }

    public void setCustomCSS(String customCSS) {
        this._customCSS = customCSS;
    }

    public void setCustomCSSViewport(String viewportSizeId, String customCSS) {
        this._customCSSViewports.put(viewportSizeId, customCSS);
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public void updateItemConfig(JSONObject itemConfigJSONObject) {
        if (itemConfigJSONObject.has("cssClasses")) {
            LinkedHashSet<String> cssClasses = new LinkedHashSet<String>();
            JSONUtil.addToStringCollection(cssClasses, (JSONArray)itemConfigJSONObject.getJSONArray("cssClasses"));
            this.setCssClasses(cssClasses);
        }
        if (itemConfigJSONObject.has("customCSS")) {
            this.setCustomCSS(itemConfigJSONObject.getString("customCSS"));
        }
        if (itemConfigJSONObject.has("name")) {
            this.setName(itemConfigJSONObject.getString("name"));
        }
        try {
            this._updateItemConfigValues(this.stylesJSONObject, itemConfigJSONObject);
            if (itemConfigJSONObject.has("styles")) {
                JSONObject newStylesJSONObject = itemConfigJSONObject.getJSONObject("styles");
                this._updateItemConfigValues(this.stylesJSONObject, newStylesJSONObject);
            }
            for (JSONObject viewportSize : _viewportSizes) {
                if (viewportSize.equals((Object)ViewportSize.DESKTOP)) continue;
                this._updateCustomCSSViewports(itemConfigJSONObject, (ViewportSize)viewportSize);
                this._updateViewportStyleJSONObjects(itemConfigJSONObject, (ViewportSize)viewportSize);
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get available style names", (Throwable)exception);
        }
    }

    private void _updateCustomCSSViewports(JSONObject itemConfigJSONObject, ViewportSize viewportSize) {
        JSONObject viewportItemConfigJSONObject = itemConfigJSONObject.getJSONObject(viewportSize.getViewportSizeId());
        if (viewportItemConfigJSONObject != null && viewportItemConfigJSONObject.has("customCSS")) {
            this._customCSSViewports.put(viewportSize.getViewportSizeId(), viewportItemConfigJSONObject.getString("customCSS"));
        }
    }

    private void _updateItemConfigValues(JSONObject currentJSONObject, JSONObject newJSONObject) throws Exception {
        List<String> availableStyleNames = CommonStylesUtil.getAvailableStyleNames();
        for (String styleName : availableStyleNames) {
            if (!newJSONObject.has(styleName)) continue;
            Object styleValue = newJSONObject.get(styleName);
            if (Objects.equals(styleValue, CommonStylesUtil.getDefaultStyleValue(styleName))) {
                currentJSONObject.remove(styleName);
                continue;
            }
            currentJSONObject.put(styleName, styleValue);
        }
    }

    private void _updateViewportStyleJSONObjects(JSONObject itemConfigJSONObject, ViewportSize viewportSize) {
        List<String> availableStyleNames = CommonStylesUtil.getAvailableStyleNames();
        JSONObject viewportItemConfigJSONObject = itemConfigJSONObject.getJSONObject(viewportSize.getViewportSizeId());
        if (ListUtil.isEmpty(availableStyleNames) || viewportItemConfigJSONObject == null) {
            return;
        }
        JSONObject newStylesJSONObject = viewportItemConfigJSONObject.getJSONObject("styles");
        if (newStylesJSONObject == null || newStylesJSONObject.length() == 0) {
            return;
        }
        JSONObject currentViewportStyleJSONObject = this.viewportStyleJSONObjects.getOrDefault(viewportSize.getViewportSizeId(), JSONFactoryUtil.createJSONObject());
        for (String styleName : availableStyleNames) {
            if (!newStylesJSONObject.has(styleName)) continue;
            currentViewportStyleJSONObject.put(styleName, newStylesJSONObject.get(styleName));
        }
        this.viewportStyleJSONObjects.put(viewportSize.getViewportSizeId(), currentViewportStyleJSONObject);
    }
}

