/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ColumnLayoutStructureItem
extends LayoutStructureItem {
    private int _size;
    private final Map<String, JSONObject> _viewportConfigurations = new HashMap<String, JSONObject>();

    public ColumnLayoutStructureItem(String parentItemId) {
        super(parentItemId);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ColumnLayoutStructureItem)) {
            return false;
        }
        ColumnLayoutStructureItem columnLayoutStructureItem = (ColumnLayoutStructureItem)object;
        if (!Objects.equals(this._size, columnLayoutStructureItem._size)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public JSONObject getItemConfigJSONObject() {
        JSONObject jsonObject = JSONUtil.put((String)"size", (Object)this._size);
        for (ViewportSize viewportSize : ViewportSize.values()) {
            if (viewportSize.equals((Object)ViewportSize.DESKTOP)) continue;
            JSONObject viewportConfigurationJSONObject = this._viewportConfigurations.getOrDefault(viewportSize.getViewportSizeId(), JSONFactoryUtil.createJSONObject());
            jsonObject.put(viewportSize.getViewportSizeId(), JSONUtil.put((String)"size", (Object)viewportConfigurationJSONObject.get("size")));
        }
        return jsonObject;
    }

    @Override
    public String getItemType() {
        return "column";
    }

    public int getSize() {
        return this._size;
    }

    public Map<String, JSONObject> getViewportConfigurations() {
        return this._viewportConfigurations;
    }

    @Deprecated
    public Map<String, JSONObject> getViewportSizeConfigurations() {
        return this.getViewportConfigurations();
    }

    @Override
    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this.getItemId());
    }

    public void setSize(int size) {
        this._size = size;
    }

    public void setViewportConfiguration(String viewportSizeId, JSONObject configurationJSONObject) {
        JSONObject currentConfigurationJSONObject = this._viewportConfigurations.getOrDefault(viewportSizeId, JSONFactoryUtil.createJSONObject());
        if (configurationJSONObject.has("size")) {
            currentConfigurationJSONObject.put("size", configurationJSONObject.getInt("size"));
        }
        this._viewportConfigurations.put(viewportSizeId, currentConfigurationJSONObject);
    }

    @Deprecated
    public void setViewportSizeConfiguration(String viewportSizeId, JSONObject configurationJSONObject) {
        this.setViewportConfiguration(viewportSizeId, configurationJSONObject);
    }

    @Override
    public void updateItemConfig(JSONObject itemConfigJSONObject) {
        if (itemConfigJSONObject.has("size")) {
            this.setSize(itemConfigJSONObject.getInt("size"));
        }
        for (ViewportSize viewportSize : ViewportSize.values()) {
            if (viewportSize.equals((Object)ViewportSize.DESKTOP) || !itemConfigJSONObject.has(viewportSize.getViewportSizeId())) continue;
            this.setViewportConfiguration(viewportSize.getViewportSizeId(), itemConfigJSONObject.getJSONObject(viewportSize.getViewportSizeId()));
        }
    }
}

