/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.responsive;

import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.ColumnLayoutStructureItem;
import com.liferay.layout.util.structure.CommonStylesUtil;
import com.liferay.layout.util.structure.ContainerStyledLayoutStructureItem;
import com.liferay.layout.util.structure.RowLayoutStructureItem;
import com.liferay.layout.util.structure.RowStyledLayoutStructureItem;
import com.liferay.layout.util.structure.StyledLayoutStructureItem;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ResponsiveLayoutStructureUtil {
    @Deprecated
    public static String getColumnCssClass(ColumnLayoutStructureItem columnLayoutStructureItem) {
        return ResponsiveLayoutStructureUtil.getColumnCssClass(columnLayoutStructureItem, null);
    }

    public static String getColumnCssClass(ColumnLayoutStructureItem columnLayoutStructureItem, RowStyledLayoutStructureItem rowStyledLayoutStructureItem) {
        StringBundler sb = new StringBundler();
        sb.append("col-lg-");
        sb.append(columnLayoutStructureItem.getSize());
        Map<String, JSONObject> columnViewportConfigurations = columnLayoutStructureItem.getViewportConfigurations();
        for (ViewportSize viewportSize : ViewportSize.values()) {
            if (Objects.equals((Object)viewportSize, (Object)ViewportSize.DESKTOP)) continue;
            int columnSize = GetterUtil.getInteger((Object)ResponsiveLayoutStructureUtil.getResponsivePropertyValue(viewportSize, columnViewportConfigurations, "size", columnLayoutStructureItem.getSize()));
            sb.append(" ");
            sb.append("col");
            sb.append(viewportSize.getCssClassPrefix());
            sb.append(columnSize);
        }
        if (rowStyledLayoutStructureItem != null && Objects.equals(rowStyledLayoutStructureItem.getVerticalAlignment(), "middle")) {
            sb.append("d-flex flex-column ");
        }
        return sb.toString();
    }

    @Deprecated
    public static String getColumnCssClass(RowLayoutStructureItem rowLayoutStructureItem, ColumnLayoutStructureItem columnLayoutStructureItem) {
        return ResponsiveLayoutStructureUtil.getColumnCssClass(columnLayoutStructureItem, null);
    }

    public static String getResponsiveCssClassValues(StyledLayoutStructureItem styledLayoutStructureItem) throws Exception {
        StringBundler sb = new StringBundler();
        JSONObject itemConfigJSONObject = styledLayoutStructureItem.getItemConfigJSONObject();
        for (ViewportSize viewportSize : ViewportSize.values()) {
            JSONObject viewportStylesJSONObject;
            JSONObject viewportItemConfigJSONObject;
            if (Objects.equals((Object)viewportSize, (Object)ViewportSize.DESKTOP) || (viewportItemConfigJSONObject = ResponsiveLayoutStructureUtil._getViewportItemConfigJSONObject(itemConfigJSONObject, viewportSize)) == null || (viewportStylesJSONObject = viewportItemConfigJSONObject.getJSONObject("styles")) == null) continue;
            Set keys = viewportStylesJSONObject.keySet();
            for (String key : keys) {
                ContainerStyledLayoutStructureItem containerStyledLayoutStructureItem;
                String value;
                if (!CommonStylesUtil.isResponsive(key) || Validator.isNull((String)(value = viewportStylesJSONObject.getString(key))) || styledLayoutStructureItem instanceof ContainerStyledLayoutStructureItem && Objects.equals((containerStyledLayoutStructureItem = (ContainerStyledLayoutStructureItem)styledLayoutStructureItem).getWidthType(), "fixed") && (Objects.equals(key, "marginLeft") || Objects.equals(key, "marginRight"))) continue;
                String cssClass = StringUtil.replace((String)CommonStylesUtil.getResponsiveTemplate(key), (String)"{", (String)"}", (Map)HashMapBuilder.put((Object)"value", (Object)value).put((Object)"viewport", (Object)viewportSize.getCssClassPrefix()).build());
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(cssClass);
            }
        }
        return sb.toString();
    }

    public static Object getResponsivePropertyValue(ViewportSize currentViewportSize, Map<String, JSONObject> viewportConfigurations, String propertyName, Object defaultValue) {
        JSONObject viewportConfigurationJSONObject = viewportConfigurations.getOrDefault(currentViewportSize.getViewportSizeId(), JSONFactoryUtil.createJSONObject());
        if (viewportConfigurationJSONObject.has(propertyName)) {
            return viewportConfigurationJSONObject.get(propertyName);
        }
        ViewportSize[] viewportSizes = ViewportSize.values();
        Comparator<ViewportSize> comparator = Comparator.comparingInt(ViewportSize::getOrder);
        Arrays.sort(viewportSizes, comparator.reversed());
        for (ViewportSize viewportSize : viewportSizes) {
            viewportConfigurationJSONObject = viewportConfigurations.getOrDefault(viewportSize.getViewportSizeId(), JSONFactoryUtil.createJSONObject());
            if (!viewportConfigurationJSONObject.has(propertyName) || viewportSize.getOrder() >= currentViewportSize.getOrder()) continue;
            return viewportConfigurationJSONObject.get(propertyName);
        }
        return defaultValue;
    }

    @Deprecated
    public static String getRowCssClass(RowLayoutStructureItem rowLayoutStructureItem) {
        return ResponsiveLayoutStructureUtil.getRowCssClass((RowStyledLayoutStructureItem)rowLayoutStructureItem);
    }

    public static String getRowCssClass(RowStyledLayoutStructureItem rowStyledLayoutStructureItem) {
        StringBundler sb = new StringBundler();
        String defaultVerticalAlignment = rowStyledLayoutStructureItem.getVerticalAlignment();
        if (Validator.isNotNull((String)defaultVerticalAlignment)) {
            sb.append("align-items-lg-");
            sb.append(ResponsiveLayoutStructureUtil._getVerticalAlignmentCssClass(defaultVerticalAlignment));
        }
        Map<String, JSONObject> rowViewportConfigurations = rowStyledLayoutStructureItem.getViewportConfigurations();
        for (ViewportSize viewportSize : ViewportSize.values()) {
            String verticalAlignment;
            if (Objects.equals((Object)viewportSize, (Object)ViewportSize.DESKTOP) || !Validator.isNotNull((String)(verticalAlignment = GetterUtil.getString((Object)ResponsiveLayoutStructureUtil.getResponsivePropertyValue(viewportSize, rowViewportConfigurations, "verticalAlignment", defaultVerticalAlignment))))) continue;
            sb.append(" ");
            sb.append("align-items");
            sb.append(viewportSize.getCssClassPrefix());
            sb.append(ResponsiveLayoutStructureUtil._getVerticalAlignmentCssClass(verticalAlignment));
        }
        sb.append(" ");
        if (rowStyledLayoutStructureItem.isReverseOrder() && rowStyledLayoutStructureItem.getModulesPerRow() > 1) {
            sb.append("flex-lg-row-reverse");
        } else if (rowStyledLayoutStructureItem.isReverseOrder() && rowStyledLayoutStructureItem.getModulesPerRow() == 1) {
            sb.append("flex-lg-column-reverse");
        } else {
            sb.append("flex-lg-row");
        }
        for (ViewportSize viewportSize : ViewportSize.values()) {
            if (Objects.equals((Object)viewportSize, (Object)ViewportSize.DESKTOP)) continue;
            boolean reverseOrder = GetterUtil.getBoolean((Object)ResponsiveLayoutStructureUtil.getResponsivePropertyValue(viewportSize, rowViewportConfigurations, "reverseOrder", rowStyledLayoutStructureItem.isReverseOrder()));
            int modulesPerRow = GetterUtil.getInteger((Object)ResponsiveLayoutStructureUtil.getResponsivePropertyValue(viewportSize, rowViewportConfigurations, "modulesPerRow", rowStyledLayoutStructureItem.getModulesPerRow()));
            sb.append(" ");
            if (reverseOrder) {
                sb.append("flex");
                sb.append(viewportSize.getCssClassPrefix());
                if (modulesPerRow > 1) {
                    sb.append("row-reverse");
                    continue;
                }
                if (modulesPerRow != 1) continue;
                sb.append("column-reverse");
                continue;
            }
            sb.append("flex");
            sb.append(viewportSize.getCssClassPrefix());
            sb.append("row");
        }
        if (!rowStyledLayoutStructureItem.isGutters()) {
            sb.append(" ");
            sb.append("no-gutters");
        }
        return sb.toString();
    }

    private static String _getVerticalAlignmentCssClass(String verticalAlignment) {
        if (Objects.equals(verticalAlignment, "bottom")) {
            return "end";
        }
        if (Objects.equals(verticalAlignment, "middle")) {
            return "center";
        }
        return "start";
    }

    private static JSONObject _getViewportItemConfigJSONObject(JSONObject itemConfigJSONObject, ViewportSize currentViewportSize) {
        JSONObject viewportItemConfigJSONObject;
        JSONObject stylesJSONObject;
        if (itemConfigJSONObject.has(currentViewportSize.getViewportSizeId()) && (stylesJSONObject = (viewportItemConfigJSONObject = itemConfigJSONObject.getJSONObject(currentViewportSize.getViewportSizeId())).getJSONObject("styles")) != null && stylesJSONObject.length() > 0) {
            return viewportItemConfigJSONObject;
        }
        ViewportSize[] viewportSizes = ViewportSize.values();
        Comparator<ViewportSize> comparator = Comparator.comparingInt(ViewportSize::getOrder);
        Arrays.sort(viewportSizes, comparator.reversed());
        for (ViewportSize viewportSize : viewportSizes) {
            JSONObject viewportItemConfigJSONObject2;
            JSONObject stylesJSONObject2;
            if (viewportSize.getOrder() >= currentViewportSize.getOrder() || !itemConfigJSONObject.has(viewportSize.getViewportSizeId()) || (stylesJSONObject2 = (viewportItemConfigJSONObject2 = itemConfigJSONObject.getJSONObject(viewportSize.getViewportSizeId())).getJSONObject("styles")) == null || stylesJSONObject2.length() <= 0) continue;
            return viewportItemConfigJSONObject2;
        }
        return itemConfigJSONObject;
    }
}

