/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class CommonStylesUtil {
    private static List<String> _availableStyleNames;
    private static final Map<Locale, JSONArray> _commonStyles;
    private static Map<String, Object> _defaultValues;
    private static Map<String, String> _responsiveTemplates;

    public static List<String> getAvailableStyleNames() throws Exception {
        if (_availableStyleNames != null) {
            return _availableStyleNames;
        }
        ArrayList<String> availableStyleNames = new ArrayList<String>();
        JSONArray jsonArray = CommonStylesUtil.getCommonStylesJSONArray(null);
        Iterator iterator = jsonArray.iterator();
        iterator.forEachRemaining(jsonObject -> {
            JSONArray stylesJSONArray = jsonObject.getJSONArray("styles");
            Iterator stylesIterator = stylesJSONArray.iterator();
            stylesIterator.forEachRemaining(styleJSONObject -> availableStyleNames.add(styleJSONObject.getString("name")));
        });
        _availableStyleNames = availableStyleNames;
        return _availableStyleNames;
    }

    public static JSONArray getCommonStylesJSONArray(ResourceBundle resourceBundle) throws Exception {
        JSONArray commonStylesJSONArray = null;
        if (resourceBundle != null) {
            commonStylesJSONArray = _commonStyles.get(resourceBundle.getLocale());
        }
        if (commonStylesJSONArray != null) {
            return commonStylesJSONArray;
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)new String(FileUtil.getBytes(CommonStylesUtil.class, (String)"common-styles.json")));
        Iterator iterator = jsonArray.iterator();
        iterator.forEachRemaining(jsonObject -> {
            jsonObject.put("label", LanguageUtil.get((ResourceBundle)resourceBundle, (String)jsonObject.getString("label")));
            JSONArray stylesJSONArray = jsonObject.getJSONArray("styles");
            Iterator stylesIterator = stylesJSONArray.iterator();
            stylesIterator.forEachRemaining(styleJSONObject -> {
                styleJSONObject.put("label", LanguageUtil.get((ResourceBundle)resourceBundle, (String)styleJSONObject.getString("label")));
                JSONArray validValuesJSONArray = styleJSONObject.getJSONArray("validValues");
                if (validValuesJSONArray != null) {
                    Iterator validValuesIterator = validValuesJSONArray.iterator();
                    validValuesIterator.forEachRemaining(validValueJSONObject -> validValueJSONObject.put("label", LanguageUtil.get((ResourceBundle)resourceBundle, (String)validValueJSONObject.getString("label"))));
                }
            });
        });
        if (resourceBundle != null) {
            _commonStyles.put(resourceBundle.getLocale(), jsonArray);
        }
        return jsonArray;
    }

    public static Object getDefaultStyleValue(String name) {
        if (_defaultValues != null) {
            return _defaultValues.get(name);
        }
        try {
            Map<String, Object> defaultValues = CommonStylesUtil.getDefaultStyleValues();
            return defaultValues.get(name);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to get default value for style " + name, exception);
        }
    }

    public static Map<String, Object> getDefaultStyleValues() throws Exception {
        if (_defaultValues != null) {
            return _defaultValues;
        }
        HashMap<String, Object> defaultValues = new HashMap<String, Object>();
        JSONArray jsonArray = CommonStylesUtil.getCommonStylesJSONArray(null);
        Iterator iterator = jsonArray.iterator();
        iterator.forEachRemaining(jsonObject -> {
            JSONArray stylesJSONArray = jsonObject.getJSONArray("styles");
            Iterator stylesIterator = stylesJSONArray.iterator();
            stylesIterator.forEachRemaining(styleJSONObject -> defaultValues.put(styleJSONObject.getString("name"), styleJSONObject.get("defaultValue")));
        });
        _defaultValues = defaultValues;
        return _defaultValues;
    }

    public static String getResponsiveTemplate(String propertyKey) throws Exception {
        if (_responsiveTemplates != null) {
            return _responsiveTemplates.get(propertyKey);
        }
        CommonStylesUtil._loadResponsiveTemplates();
        return _responsiveTemplates.get(propertyKey);
    }

    public static boolean isResponsive(String propertyKey) throws Exception {
        if (_responsiveTemplates != null) {
            return Validator.isNotNull((String)_responsiveTemplates.get(propertyKey));
        }
        CommonStylesUtil._loadResponsiveTemplates();
        return Validator.isNotNull((String)_responsiveTemplates.get(propertyKey));
    }

    private static void _loadResponsiveTemplates() throws Exception {
        HashMap<String, String> responsiveTemplates = new HashMap<String, String>();
        JSONArray jsonArray = CommonStylesUtil.getCommonStylesJSONArray(null);
        Iterator iterator = jsonArray.iterator();
        iterator.forEachRemaining(jsonObject -> {
            JSONArray stylesJSONArray = jsonObject.getJSONArray("styles");
            Iterator stylesIterator = stylesJSONArray.iterator();
            stylesIterator.forEachRemaining(styleJSONObject -> {
                boolean responsive = styleJSONObject.getBoolean("responsive");
                if (responsive) {
                    responsiveTemplates.put(styleJSONObject.getString("name"), styleJSONObject.getString("responsiveTemplate", ""));
                }
            });
        });
        _responsiveTemplates = responsiveTemplates;
    }

    static {
        _commonStyles = new HashMap<Locale, JSONArray>();
    }
}

