/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.CollectionItemLayoutStructureItem;
import com.liferay.layout.util.structure.CollectionStyledLayoutStructureItem;
import com.liferay.layout.util.structure.ColumnLayoutStructureItem;
import com.liferay.layout.util.structure.ContainerStyledLayoutStructureItem;
import com.liferay.layout.util.structure.DeletedLayoutStructureItem;
import com.liferay.layout.util.structure.DropZoneLayoutStructureItem;
import com.liferay.layout.util.structure.FragmentDropZoneLayoutStructureItem;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructureItemUtil;
import com.liferay.layout.util.structure.RootLayoutStructureItem;
import com.liferay.layout.util.structure.RowStyledLayoutStructureItem;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class LayoutStructure {
    private static final int[][] _COLUMN_SIZES = new int[][]{{12}, {6, 6}, {4, 4, 4}, {3, 3, 3, 3}, {2, 2, 4, 2, 2}, {2, 2, 2, 2, 2, 2}, {1, 1, 1, 6, 1, 1, 1}, {1, 1, 1, 3, 3, 1, 1, 1}, {1, 1, 1, 1, 4, 1, 1, 1, 1}, {1, 1, 1, 1, 2, 2, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};
    private static final int _MAX_COLUMNS = 12;
    private static final int[][][] _MODULE_SIZES = new int[][][]{new int[][]{{12}}, new int[][]{{12}}, new int[][]{{12}, {6, 6}}, new int[][]{{12}, {6, 6, 4, 4, 4}}, new int[][]{{12}, {6, 6}, {4, 4, 4}}};
    private static final Log _log = LogFactoryUtil.getLog(LayoutStructure.class);
    private final Map<String, DeletedLayoutStructureItem> _deletedLayoutStructureItems;
    private final Map<Long, LayoutStructureItem> _fragmentLayoutStructureItems;
    private final Map<String, LayoutStructureItem> _layoutStructureItems;
    private String _mainItemId;

    public static LayoutStructure of(String layoutStructure) {
        if (Validator.isNull((String)layoutStructure)) {
            return new LayoutStructure();
        }
        try {
            JSONObject layoutStructureJSONObject = JSONFactoryUtil.createJSONObject((String)layoutStructure);
            JSONObject rootItemsJSONObject = layoutStructureJSONObject.getJSONObject("rootItems");
            JSONObject itemsJSONObject = layoutStructureJSONObject.getJSONObject("items");
            HashMap<Long, LayoutStructureItem> fragmentLayoutStructureItems = new HashMap<Long, LayoutStructureItem>(itemsJSONObject.length());
            HashMap<String, LayoutStructureItem> layoutStructureItems = new HashMap<String, LayoutStructureItem>(itemsJSONObject.length());
            for (String key : itemsJSONObject.keySet()) {
                LayoutStructureItem layoutStructureItem = LayoutStructureItem.of(itemsJSONObject.getJSONObject(key));
                layoutStructureItems.put(key, layoutStructureItem);
                if (!(layoutStructureItem instanceof FragmentStyledLayoutStructureItem)) continue;
                FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructureItem;
                fragmentLayoutStructureItems.put(fragmentStyledLayoutStructureItem.getFragmentEntryLinkId(), fragmentStyledLayoutStructureItem);
            }
            JSONArray deletedLayoutStructureItemJSONArray = Optional.ofNullable(layoutStructureJSONObject.getJSONArray("deletedItems")).orElse(JSONFactoryUtil.createJSONArray());
            HashMap<String, DeletedLayoutStructureItem> deletedLayoutStructureItems = new HashMap<String, DeletedLayoutStructureItem>(deletedLayoutStructureItemJSONArray.length());
            deletedLayoutStructureItemJSONArray.forEach(deletedLayoutStructureItemJSONObject -> {
                DeletedLayoutStructureItem deletedLayoutStructureItem = DeletedLayoutStructureItem.of((JSONObject)deletedLayoutStructureItemJSONObject);
                deletedLayoutStructureItems.put(deletedLayoutStructureItem.getItemId(), deletedLayoutStructureItem);
            });
            return new LayoutStructure(deletedLayoutStructureItems, fragmentLayoutStructureItems, layoutStructureItems, rootItemsJSONObject.getString("main"));
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to parse JSON", (Throwable)jsonException);
            }
            return new LayoutStructure();
        }
    }

    public LayoutStructure() {
        this._fragmentLayoutStructureItems = new HashMap<Long, LayoutStructureItem>();
        this._deletedLayoutStructureItems = new HashMap<String, DeletedLayoutStructureItem>();
        this._layoutStructureItems = new HashMap<String, LayoutStructureItem>();
        this._mainItemId = "";
    }

    public LayoutStructureItem addCollectionItemLayoutStructureItem(String parentItemId, int position) {
        CollectionItemLayoutStructureItem collectionItemLayoutStructureItem = new CollectionItemLayoutStructureItem(parentItemId);
        this._updateLayoutStructure(collectionItemLayoutStructureItem, position);
        return collectionItemLayoutStructureItem;
    }

    @Deprecated
    public LayoutStructureItem addCollectionLayoutStructureItem(String parentItemId, int position) {
        return this.addCollectionStyledLayoutStructureItem(parentItemId, position);
    }

    public LayoutStructureItem addCollectionStyledLayoutStructureItem(String parentItemId, int position) {
        CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem = new CollectionStyledLayoutStructureItem(parentItemId);
        this._updateLayoutStructure(collectionStyledLayoutStructureItem, position);
        this.addCollectionItemLayoutStructureItem(collectionStyledLayoutStructureItem.getItemId(), 0);
        return collectionStyledLayoutStructureItem;
    }

    public LayoutStructureItem addColumnLayoutStructureItem(String parentItemId, int position) {
        ColumnLayoutStructureItem columnLayoutStructureItem = new ColumnLayoutStructureItem(parentItemId);
        columnLayoutStructureItem.setSize(12);
        this._updateLayoutStructure(columnLayoutStructureItem, position);
        return columnLayoutStructureItem;
    }

    @Deprecated
    public LayoutStructureItem addContainerLayoutStructureItem(String parentItemId, int position) {
        return this.addContainerStyledLayoutStructureItem(parentItemId, position);
    }

    public LayoutStructureItem addContainerStyledLayoutStructureItem(String parentItemId, int position) {
        ContainerStyledLayoutStructureItem containerStyledLayoutStructureItem = new ContainerStyledLayoutStructureItem(parentItemId);
        this._updateLayoutStructure(containerStyledLayoutStructureItem, position);
        return containerStyledLayoutStructureItem;
    }

    public LayoutStructureItem addDropZoneLayoutStructureItem(String parentItemId, int position) {
        DropZoneLayoutStructureItem dropZoneLayoutStructureItem = new DropZoneLayoutStructureItem(parentItemId);
        this._updateLayoutStructure(dropZoneLayoutStructureItem, position);
        return dropZoneLayoutStructureItem;
    }

    public LayoutStructureItem addFragmentDropZoneLayoutStructureItem(String parentItemId, int position) {
        FragmentDropZoneLayoutStructureItem fragmentDropZoneLayoutStructureItem = new FragmentDropZoneLayoutStructureItem(parentItemId);
        this._updateLayoutStructure(fragmentDropZoneLayoutStructureItem, position);
        return fragmentDropZoneLayoutStructureItem;
    }

    @Deprecated
    public LayoutStructureItem addFragmentLayoutStructureItem(long fragmentEntryLinkId, String parentItemId, int position) {
        return this.addFragmentStyledLayoutStructureItem(fragmentEntryLinkId, parentItemId, position);
    }

    public LayoutStructureItem addFragmentStyledLayoutStructureItem(long fragmentEntryLinkId, String parentItemId, int position) {
        FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem = new FragmentStyledLayoutStructureItem(parentItemId);
        this._updateLayoutStructure(fragmentStyledLayoutStructureItem, position);
        fragmentStyledLayoutStructureItem.setFragmentEntryLinkId(fragmentEntryLinkId);
        return fragmentStyledLayoutStructureItem;
    }

    public LayoutStructureItem addLayoutStructureItem(LayoutStructureItem layoutStructureItem) {
        this._layoutStructureItems.put(layoutStructureItem.getItemId(), layoutStructureItem);
        return layoutStructureItem;
    }

    public LayoutStructureItem addLayoutStructureItem(String itemType, String parentItemId, int position) {
        LayoutStructureItem layoutStructureItem = LayoutStructureItemUtil.create(itemType, parentItemId);
        this._updateLayoutStructure(layoutStructureItem, position);
        return layoutStructureItem;
    }

    public LayoutStructureItem addRootLayoutStructureItem() {
        RootLayoutStructureItem rootLayoutStructureItem = new RootLayoutStructureItem();
        this._updateLayoutStructure(rootLayoutStructureItem, 0);
        if (Validator.isNull((String)this._mainItemId)) {
            this._mainItemId = rootLayoutStructureItem.getItemId();
        }
        return rootLayoutStructureItem;
    }

    @Deprecated
    public LayoutStructureItem addRowLayoutStructureItem(String parentItemId, int position, int numberOfColumns) {
        return this.addRowStyledLayoutStructureItem(parentItemId, position, numberOfColumns);
    }

    public LayoutStructureItem addRowStyledLayoutStructureItem(String parentItemId, int position, int numberOfColumns) {
        RowStyledLayoutStructureItem rowStyledLayoutStructureItem = new RowStyledLayoutStructureItem(parentItemId);
        this._updateLayoutStructure(rowStyledLayoutStructureItem, position);
        rowStyledLayoutStructureItem.setNumberOfColumns(numberOfColumns);
        return rowStyledLayoutStructureItem;
    }

    public List<LayoutStructureItem> deleteLayoutStructureItem(String itemId) {
        LayoutStructureItem parentLayoutStructureItem;
        LayoutStructureItem layoutStructureItem = this._layoutStructureItems.get(itemId);
        if (layoutStructureItem instanceof DropZoneLayoutStructureItem) {
            throw new UnsupportedOperationException("Removing the drop zone of a layout structure is not allowed");
        }
        ArrayList<LayoutStructureItem> deletedLayoutStructureItems = new ArrayList<LayoutStructureItem>();
        ArrayList<String> childrenItemIds = new ArrayList<String>(layoutStructureItem.getChildrenItemIds());
        for (String childrenItemId : childrenItemIds) {
            deletedLayoutStructureItems.addAll(this.deleteLayoutStructureItem(childrenItemId));
        }
        deletedLayoutStructureItems.add(layoutStructureItem);
        if (Validator.isNotNull((String)layoutStructureItem.getParentItemId()) && (parentLayoutStructureItem = this._layoutStructureItems.get(layoutStructureItem.getParentItemId())) != null) {
            parentLayoutStructureItem.deleteChildrenItem(itemId);
        }
        this._deletedLayoutStructureItems.remove(itemId);
        this._layoutStructureItems.remove(itemId);
        return deletedLayoutStructureItems;
    }

    public List<LayoutStructureItem> duplicateLayoutStructureItem(String itemId) {
        LayoutStructureItem layoutStructureItem = this._layoutStructureItems.get(itemId);
        LayoutStructureItem parentLayoutStructureItem = this._layoutStructureItems.get(layoutStructureItem.getParentItemId());
        List<String> childrenItemIds = parentLayoutStructureItem.getChildrenItemIds();
        int position = childrenItemIds.indexOf(itemId) + 1;
        return this._duplicateLayoutStructureItem(itemId, layoutStructureItem.getParentItemId(), position);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LayoutStructure)) {
            return false;
        }
        LayoutStructure layoutStructure = (LayoutStructure)object;
        return Objects.equals(this._mainItemId, layoutStructure._mainItemId) && Objects.equals(this._layoutStructureItems, layoutStructure._layoutStructureItems);
    }

    public int getColumnSize(int size, int column) {
        return _COLUMN_SIZES[size][column];
    }

    public List<DeletedLayoutStructureItem> getDeletedLayoutStructureItems() {
        return ListUtil.fromCollection(this._deletedLayoutStructureItems.values());
    }

    public LayoutStructureItem getDropZoneLayoutStructureItem() {
        for (LayoutStructureItem layoutStructureItem : this.getLayoutStructureItems()) {
            if (!(layoutStructureItem instanceof DropZoneLayoutStructureItem)) continue;
            return layoutStructureItem;
        }
        return null;
    }

    public Map<Long, LayoutStructureItem> getFragmentLayoutStructureItems() {
        return this._fragmentLayoutStructureItems;
    }

    public LayoutStructureItem getLayoutStructureItem(String itemId) {
        return this._layoutStructureItems.get(itemId);
    }

    public LayoutStructureItem getLayoutStructureItemByFragmentEntryLinkId(long fragmentEntryLinkId) {
        return this._fragmentLayoutStructureItems.get(fragmentEntryLinkId);
    }

    public List<LayoutStructureItem> getLayoutStructureItems() {
        return ListUtil.fromCollection(this._layoutStructureItems.values());
    }

    public String getMainItemId() {
        return this._mainItemId;
    }

    public LayoutStructureItem getMainLayoutStructureItem() {
        return this._layoutStructureItems.get(this._mainItemId);
    }

    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this.getMainItemId());
    }

    public void markLayoutStructureItemForDeletion(String itemId, List<String> portletIds) {
        LayoutStructureItem layoutStructureItem = this._layoutStructureItems.get(itemId);
        if (layoutStructureItem instanceof DropZoneLayoutStructureItem) {
            throw new UnsupportedOperationException("Removing the drop zone of a layout structure is not allowed");
        }
        if (Validator.isNotNull((String)layoutStructureItem.getParentItemId())) {
            LayoutStructureItem parentLayoutStructureItem = this._layoutStructureItems.get(layoutStructureItem.getParentItemId());
            List<String> childrenItemIds = parentLayoutStructureItem.getChildrenItemIds();
            int position = childrenItemIds.indexOf(itemId);
            childrenItemIds.remove(itemId);
            this._deletedLayoutStructureItems.put(itemId, new DeletedLayoutStructureItem(itemId, portletIds, position, this._getChildrenItemIds(itemId)));
        } else {
            this._deletedLayoutStructureItems.put(itemId, new DeletedLayoutStructureItem(itemId, portletIds, 0, this._getChildrenItemIds(itemId)));
        }
    }

    public LayoutStructureItem moveLayoutStructureItem(String itemId, String parentItemId, int position) {
        LayoutStructureItem layoutStructureItem = this._layoutStructureItems.get(itemId);
        LayoutStructureItem oldParentLayoutStructureItem = this._layoutStructureItems.get(layoutStructureItem.getParentItemId());
        oldParentLayoutStructureItem.deleteChildrenItem(itemId);
        LayoutStructureItem newParentLayoutStructureItem = this._layoutStructureItems.get(parentItemId);
        newParentLayoutStructureItem.addChildrenItem(position, itemId);
        layoutStructureItem.setParentItemId(parentItemId);
        return layoutStructureItem;
    }

    public void setMainItemId(String mainItemId) {
        this._mainItemId = mainItemId;
    }

    public JSONObject toJSONObject() {
        String dropZoneItemId = "";
        JSONObject layoutStructureItemsJSONObject = JSONFactoryUtil.createJSONObject();
        for (Map.Entry<String, LayoutStructureItem> entry : this._layoutStructureItems.entrySet()) {
            LayoutStructureItem layoutStructureItem = entry.getValue();
            if (layoutStructureItem instanceof DropZoneLayoutStructureItem) {
                dropZoneItemId = layoutStructureItem.getItemId();
            }
            if (layoutStructureItem == null) {
                throw new RuntimeException("Invalid layout structure item for key " + entry.getKey());
            }
            layoutStructureItemsJSONObject.put(entry.getKey(), layoutStructureItem.toJSONObject());
        }
        JSONArray deletedLayoutStructureItemsJSONArray = JSONFactoryUtil.createJSONArray();
        for (DeletedLayoutStructureItem deletedLayoutStructureItem : this._deletedLayoutStructureItems.values()) {
            deletedLayoutStructureItemsJSONArray.put(deletedLayoutStructureItem.toJSONObject());
        }
        return JSONUtil.put((String)"deletedItems", (Object)deletedLayoutStructureItemsJSONArray).put("items", layoutStructureItemsJSONObject).put("rootItems", JSONUtil.put((String)"dropZone", (Object)dropZoneItemId).put("main", this._mainItemId)).put("version", 1);
    }

    public String toString() {
        JSONObject jsonObject = this.toJSONObject();
        return jsonObject.toJSONString();
    }

    public void unmarkLayoutStructureItemForDeletion(String itemId) {
        DeletedLayoutStructureItem deletedLayoutStructureItem = this._deletedLayoutStructureItems.get(itemId);
        if (deletedLayoutStructureItem == null) {
            return;
        }
        LayoutStructureItem layoutStructureItem = this._layoutStructureItems.get(itemId);
        LayoutStructureItem parentLayoutStructureItemId = this._layoutStructureItems.get(layoutStructureItem.getParentItemId());
        parentLayoutStructureItemId.addChildrenItem(deletedLayoutStructureItem.getPosition(), deletedLayoutStructureItem.getItemId());
        this._deletedLayoutStructureItems.remove(itemId);
    }

    public LayoutStructureItem updateItemConfig(JSONObject itemConfigJSONObject, String itemId) {
        LayoutStructureItem layoutStructureItem = this._layoutStructureItems.get(itemId);
        layoutStructureItem.updateItemConfig(itemConfigJSONObject);
        if (layoutStructureItem instanceof RowStyledLayoutStructureItem) {
            RowStyledLayoutStructureItem rowStyledLayoutStructureItem = (RowStyledLayoutStructureItem)layoutStructureItem;
            int modulesPerRow = itemConfigJSONObject.getInt("modulesPerRow");
            if (modulesPerRow > 0) {
                this._updateColumnSizes(rowStyledLayoutStructureItem, ViewportSize.DESKTOP.getViewportSizeId(), modulesPerRow, true);
            }
            for (ViewportSize viewportSize : ViewportSize.values()) {
                JSONObject viewportItemConfigJSONObject;
                if (viewportSize.equals((Object)ViewportSize.DESKTOP) || !itemConfigJSONObject.has(viewportSize.getViewportSizeId()) || (modulesPerRow = (viewportItemConfigJSONObject = itemConfigJSONObject.getJSONObject(viewportSize.getViewportSizeId())).getInt("modulesPerRow")) == 0) continue;
                this._updateColumnSizes(rowStyledLayoutStructureItem, viewportSize.getViewportSizeId(), modulesPerRow, true);
            }
        }
        return layoutStructureItem;
    }

    public List<LayoutStructureItem> updateRowColumnsLayoutStructureItem(String itemId, int numberOfColumns) {
        ColumnLayoutStructureItem columnLayoutStructureItem;
        int i;
        if (numberOfColumns > 12) {
            return Collections.emptyList();
        }
        RowStyledLayoutStructureItem rowStyledLayoutStructureItem = (RowStyledLayoutStructureItem)this._layoutStructureItems.get(itemId);
        int oldNumberOfColumns = rowStyledLayoutStructureItem.getNumberOfColumns();
        if (oldNumberOfColumns == numberOfColumns) {
            return Collections.emptyList();
        }
        rowStyledLayoutStructureItem.setModulesPerRow(numberOfColumns);
        rowStyledLayoutStructureItem.setNumberOfColumns(numberOfColumns);
        for (ViewportSize viewportSize : ViewportSize.values()) {
            if (viewportSize.equals((Object)ViewportSize.DESKTOP)) continue;
            this._updateNumberOfColumns(rowStyledLayoutStructureItem, viewportSize.getViewportSizeId(), numberOfColumns);
        }
        ArrayList<String> childrenItemIds = new ArrayList<String>(rowStyledLayoutStructureItem.getChildrenItemIds());
        if (oldNumberOfColumns < numberOfColumns) {
            for (i = 0; i < oldNumberOfColumns; ++i) {
                String childrenItemId = (String)childrenItemIds.get(i);
                columnLayoutStructureItem = (ColumnLayoutStructureItem)this._layoutStructureItems.get(childrenItemId);
                columnLayoutStructureItem.setSize(this.getColumnSize(numberOfColumns - 1, i));
            }
            for (i = oldNumberOfColumns; i < numberOfColumns; ++i) {
                this._addColumnLayoutStructureItem(itemId, i, this.getColumnSize(numberOfColumns - 1, i));
            }
            return Collections.emptyList();
        }
        for (i = 0; i < numberOfColumns; ++i) {
            String childrenItemId = (String)childrenItemIds.get(i);
            columnLayoutStructureItem = (ColumnLayoutStructureItem)this._layoutStructureItems.get(childrenItemId);
            columnLayoutStructureItem.setSize(this.getColumnSize(numberOfColumns - 1, i));
        }
        ArrayList<LayoutStructureItem> deletedLayoutStructureItems = new ArrayList<LayoutStructureItem>();
        for (int i2 = numberOfColumns; i2 < oldNumberOfColumns; ++i2) {
            String childrenItemId = (String)childrenItemIds.get(i2);
            deletedLayoutStructureItems.addAll(this.deleteLayoutStructureItem(childrenItemId));
        }
        return deletedLayoutStructureItems;
    }

    private LayoutStructure(Map<String, DeletedLayoutStructureItem> deletedLayoutStructureItems, Map<Long, LayoutStructureItem> fragmentLayoutStructureItems, Map<String, LayoutStructureItem> layoutStructureItems, String mainItemId) {
        this._deletedLayoutStructureItems = deletedLayoutStructureItems;
        this._fragmentLayoutStructureItems = fragmentLayoutStructureItems;
        this._layoutStructureItems = layoutStructureItems;
        this._mainItemId = mainItemId;
    }

    private void _addColumnLayoutStructureItem(String parentItemId, int position, int size) {
        ColumnLayoutStructureItem columnLayoutStructureItem = new ColumnLayoutStructureItem(parentItemId);
        columnLayoutStructureItem.setSize(size);
        this._updateLayoutStructure(columnLayoutStructureItem, position);
    }

    private List<LayoutStructureItem> _duplicateLayoutStructureItem(String itemId, String parentItemId, int position) {
        LayoutStructureItem layoutStructureItem = this._layoutStructureItems.get(itemId);
        LayoutStructureItem newLayoutStructureItem = LayoutStructureItemUtil.create(layoutStructureItem.getItemType(), parentItemId);
        ArrayList<LayoutStructureItem> duplicatedLayoutStructureItems = new ArrayList<LayoutStructureItem>();
        newLayoutStructureItem.setItemId(PortalUUIDUtil.generate());
        newLayoutStructureItem.updateItemConfig(layoutStructureItem.getItemConfigJSONObject());
        this._updateLayoutStructure(newLayoutStructureItem, position);
        duplicatedLayoutStructureItems.add(newLayoutStructureItem);
        for (String childrenItemId : layoutStructureItem.getChildrenItemIds()) {
            duplicatedLayoutStructureItems.addAll(this._duplicateLayoutStructureItem(childrenItemId, newLayoutStructureItem.getItemId(), -1));
        }
        return duplicatedLayoutStructureItems;
    }

    private Set<String> _getChildrenItemIds(String itemId) {
        LayoutStructureItem layoutStructureItem = this._layoutStructureItems.get(itemId);
        HashSet<String> childrenItemIds = new HashSet<String>(layoutStructureItem.getChildrenItemIds());
        for (String childrenItemId : layoutStructureItem.getChildrenItemIds()) {
            childrenItemIds.addAll(this._getChildrenItemIds(childrenItemId));
        }
        return childrenItemIds;
    }

    private void _updateColumnSizes(RowStyledLayoutStructureItem rowStyledLayoutStructureItem, String viewportSizeId, int modulesPerRow, boolean updateEmpty) {
        int[] defaultSizes = _COLUMN_SIZES[rowStyledLayoutStructureItem.getNumberOfColumns() - 1];
        if (rowStyledLayoutStructureItem.getNumberOfColumns() != modulesPerRow) {
            defaultSizes = _MODULE_SIZES[rowStyledLayoutStructureItem.getNumberOfColumns() - 2][modulesPerRow - 1];
        }
        int position = 0;
        for (String childItemId : rowStyledLayoutStructureItem.getChildrenItemIds()) {
            JSONObject columnViewportConfigurationJSONObject;
            LayoutStructureItem layoutStructureItem = this.getLayoutStructureItem(childItemId);
            if (!(layoutStructureItem instanceof ColumnLayoutStructureItem)) continue;
            ColumnLayoutStructureItem columnLayoutStructureItem = (ColumnLayoutStructureItem)layoutStructureItem;
            if (position > defaultSizes.length - 1) {
                position = 0;
            }
            int columnSize = defaultSizes[position++];
            if (Objects.equals(viewportSizeId, ViewportSize.DESKTOP.getViewportSizeId())) {
                columnLayoutStructureItem.setSize(columnSize);
                continue;
            }
            Map<String, JSONObject> columnViewportConfigurations = columnLayoutStructureItem.getViewportConfigurations();
            if (!columnViewportConfigurations.containsKey(viewportSizeId) || !(columnViewportConfigurationJSONObject = columnViewportConfigurations.get(viewportSizeId)).has("size") && !updateEmpty) continue;
            columnViewportConfigurationJSONObject.put("size", columnSize);
        }
    }

    private void _updateLayoutStructure(LayoutStructureItem layoutStructureItem, int position) {
        this._layoutStructureItems.put(layoutStructureItem.getItemId(), layoutStructureItem);
        if (Validator.isNull((String)layoutStructureItem.getParentItemId())) {
            return;
        }
        LayoutStructureItem parentLayoutStructureItem = this._layoutStructureItems.get(layoutStructureItem.getParentItemId());
        if (position >= 0) {
            parentLayoutStructureItem.addChildrenItem(position, layoutStructureItem.getItemId());
        } else {
            parentLayoutStructureItem.addChildrenItem(layoutStructureItem.getItemId());
        }
    }

    private void _updateNumberOfColumns(RowStyledLayoutStructureItem rowStyledLayoutStructureItem, String viewportSizeId, int numberOfColumns) {
        Map<String, JSONObject> rowViewportConfigurations = rowStyledLayoutStructureItem.getViewportConfigurations();
        JSONObject viewportConfigurationJSONObject = rowViewportConfigurations.getOrDefault(viewportSizeId, JSONFactoryUtil.createJSONObject());
        viewportConfigurationJSONObject.put("numberOfColumns", numberOfColumns);
        if (viewportConfigurationJSONObject.has("modulesPerRow")) {
            viewportConfigurationJSONObject.put("modulesPerRow", numberOfColumns);
        }
        this._updateColumnSizes(rowStyledLayoutStructureItem, viewportSizeId, numberOfColumns, false);
    }
}

