/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.StyledLayoutStructureItem;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RowStyledLayoutStructureItem
extends StyledLayoutStructureItem {
    private boolean _gutters = true;
    private Integer _modulesPerRow;
    private int _numberOfColumns;
    private boolean _reverseOrder;
    private String _verticalAlignment;
    private final Map<String, JSONObject> _viewportConfigurations = new HashMap<String, JSONObject>();

    public RowStyledLayoutStructureItem(String parentItemId) {
        super(parentItemId);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RowStyledLayoutStructureItem)) {
            return false;
        }
        RowStyledLayoutStructureItem rowStyledLayoutStructureItem = (RowStyledLayoutStructureItem)object;
        if (!(Objects.equals(this._gutters, rowStyledLayoutStructureItem._gutters) && Objects.equals(this._modulesPerRow, rowStyledLayoutStructureItem._modulesPerRow) && Objects.equals(this._numberOfColumns, rowStyledLayoutStructureItem._numberOfColumns) && Objects.equals(this._reverseOrder, rowStyledLayoutStructureItem._reverseOrder) && Objects.equals(this._verticalAlignment, rowStyledLayoutStructureItem._verticalAlignment))) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public JSONObject getItemConfigJSONObject() {
        JSONObject jsonObject = super.getItemConfigJSONObject();
        jsonObject.put("gutters", this._gutters).put("modulesPerRow", this.getModulesPerRow()).put("numberOfColumns", this._numberOfColumns).put("reverseOrder", this._reverseOrder);
        if (Validator.isNotNull((String)this._verticalAlignment)) {
            jsonObject.put("verticalAlignment", this._verticalAlignment);
        }
        for (ViewportSize viewportSize : ViewportSize.values()) {
            if (viewportSize.equals((Object)ViewportSize.DESKTOP)) continue;
            JSONObject currentViewportConfigurationJSONObject = JSONFactoryUtil.createJSONObject();
            if (jsonObject.has(viewportSize.getViewportSizeId())) {
                currentViewportConfigurationJSONObject = jsonObject.getJSONObject(viewportSize.getViewportSizeId());
            }
            JSONObject viewportConfigurationJSONObject = this._viewportConfigurations.getOrDefault(viewportSize.getViewportSizeId(), JSONFactoryUtil.createJSONObject());
            currentViewportConfigurationJSONObject.put("modulesPerRow", viewportConfigurationJSONObject.get("modulesPerRow")).put("reverseOrder", viewportConfigurationJSONObject.get("reverseOrder"));
            if (Validator.isNotNull((Object)viewportConfigurationJSONObject.get("verticalAlignment"))) {
                currentViewportConfigurationJSONObject.put("verticalAlignment", viewportConfigurationJSONObject.get("verticalAlignment"));
            }
            jsonObject.put(viewportSize.getViewportSizeId(), currentViewportConfigurationJSONObject);
        }
        return jsonObject;
    }

    @Override
    public String getItemType() {
        return "row";
    }

    public int getModulesPerRow() {
        if (this._modulesPerRow == null) {
            return this._numberOfColumns;
        }
        return this._modulesPerRow;
    }

    public int getNumberOfColumns() {
        return this._numberOfColumns;
    }

    @Override
    public String getOverflow() {
        String overflow = this.stylesJSONObject.getString("overflow");
        if (Validator.isNull((String)overflow)) {
            return "hidden";
        }
        return overflow;
    }

    public String getVerticalAlignment() {
        return this._verticalAlignment;
    }

    public Map<String, JSONObject> getViewportConfigurations() {
        return this._viewportConfigurations;
    }

    @Deprecated
    public Map<String, JSONObject> getViewportSizeConfigurations() {
        return this.getViewportConfigurations();
    }

    @Override
    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this.getItemId());
    }

    public boolean isGutters() {
        return this._gutters;
    }

    public boolean isReverseOrder() {
        return this._reverseOrder;
    }

    public void setGutters(boolean gutters) {
        this._gutters = gutters;
    }

    public void setModulesPerRow(int modulesPerRow) {
        this._modulesPerRow = modulesPerRow;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this._numberOfColumns = numberOfColumns;
    }

    public void setReverseOrder(boolean reverseOrder) {
        this._reverseOrder = reverseOrder;
    }

    public void setVerticalAlignment(String verticalAlignment) {
        this._verticalAlignment = verticalAlignment;
    }

    public void setViewportConfiguration(String viewportSizeId, JSONObject configurationJSONObject) {
        JSONObject currentConfigurationJSONObject = this._viewportConfigurations.getOrDefault(viewportSizeId, JSONFactoryUtil.createJSONObject());
        if (configurationJSONObject.has("modulesPerRow")) {
            currentConfigurationJSONObject.put("modulesPerRow", configurationJSONObject.getInt("modulesPerRow"));
        }
        if (configurationJSONObject.has("reverseOrder")) {
            currentConfigurationJSONObject.put("reverseOrder", configurationJSONObject.getBoolean("reverseOrder"));
        }
        if (configurationJSONObject.has("verticalAlignment")) {
            currentConfigurationJSONObject.put("verticalAlignment", configurationJSONObject.getString("verticalAlignment"));
        }
        this._viewportConfigurations.put(viewportSizeId, currentConfigurationJSONObject);
    }

    @Deprecated
    public void setViewportSizeConfiguration(String viewportSizeId, JSONObject configurationJSONObject) {
        this.setViewportConfiguration(viewportSizeId, configurationJSONObject);
    }

    @Override
    public void updateItemConfig(JSONObject itemConfigJSONObject) {
        super.updateItemConfig(itemConfigJSONObject);
        if (itemConfigJSONObject.has("gutters")) {
            this.setGutters(itemConfigJSONObject.getBoolean("gutters"));
        }
        if (itemConfigJSONObject.has("modulesPerRow")) {
            this.setModulesPerRow(itemConfigJSONObject.getInt("modulesPerRow"));
        }
        if (itemConfigJSONObject.has("numberOfColumns")) {
            this.setNumberOfColumns(itemConfigJSONObject.getInt("numberOfColumns"));
        }
        if (itemConfigJSONObject.has("reverseOrder")) {
            this.setReverseOrder(itemConfigJSONObject.getBoolean("reverseOrder"));
        }
        if (itemConfigJSONObject.has("verticalAlignment")) {
            this.setVerticalAlignment(itemConfigJSONObject.getString("verticalAlignment"));
        }
        for (ViewportSize viewportSize : ViewportSize.values()) {
            if (viewportSize.equals((Object)ViewportSize.DESKTOP) || !itemConfigJSONObject.has(viewportSize.getViewportSizeId())) continue;
            this.setViewportConfiguration(viewportSize.getViewportSizeId(), itemConfigJSONObject.getJSONObject(viewportSize.getViewportSizeId()));
        }
    }
}

