Liferay.Loader.define('layout-content-page-editor-web$deepmerge@2.2.1/dist/es', ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	var global = window;
	{
		var isMergeableObject = function isMergeableObject(value) {
			return isNonNullObject(value) && !isSpecial(value);
		};

		function isNonNullObject(value) {
			return !!value && typeof value === 'object';
		}

		function isSpecial(value) {
			var stringValue = Object.prototype.toString.call(value);

			return stringValue === '[object RegExp]' || stringValue === '[object Date]' || isReactElement(value);
		}

		// see https://github.com/facebook/react/blob/b5ac963fb791d1298e7f396236383bc955f916c1/src/isomorphic/classic/element/ReactElement.js#L21-L25
		var canUseSymbol = typeof Symbol === 'function' && Symbol.for;
		var REACT_ELEMENT_TYPE = canUseSymbol ? Symbol.for('react.element') : 0xeac7;

		function isReactElement(value) {
			return value.$$typeof === REACT_ELEMENT_TYPE;
		}

		function emptyTarget(val) {
			return Array.isArray(val) ? [] : {};
		}

		function cloneUnlessOtherwiseSpecified(value, options) {
			return options.clone !== false && options.isMergeableObject(value) ? deepmerge(emptyTarget(value), value, options) : value;
		}

		function defaultArrayMerge(target, source, options) {
			return target.concat(source).map(function (element) {
				return cloneUnlessOtherwiseSpecified(element, options);
			});
		}

		function mergeObject(target, source, options) {
			var destination = {};
			if (options.isMergeableObject(target)) {
				Object.keys(target).forEach(function (key) {
					destination[key] = cloneUnlessOtherwiseSpecified(target[key], options);
				});
			}
			Object.keys(source).forEach(function (key) {
				if (!options.isMergeableObject(source[key]) || !target[key]) {
					destination[key] = cloneUnlessOtherwiseSpecified(source[key], options);
				} else {
					destination[key] = deepmerge(target[key], source[key], options);
				}
			});
			return destination;
		}

		function deepmerge(target, source, options) {
			options = options || {};
			options.arrayMerge = options.arrayMerge || defaultArrayMerge;
			options.isMergeableObject = options.isMergeableObject || isMergeableObject;

			var sourceIsArray = Array.isArray(source);
			var targetIsArray = Array.isArray(target);


			if (!(sourceIsArray === targetIsArray)) {
				return cloneUnlessOtherwiseSpecified(source, options);
			} else if (sourceIsArray) {
				return options.arrayMerge(target, source, options);
			} else {
				return mergeObject(target, source, options);
			}
		}

		deepmerge.all = function deepmergeAll(array, options) {
			if (!Array.isArray(array)) {
				throw new Error('first argument should be an array');
			}

			return array.reduce(function (prev, next) {
				return deepmerge(prev, next, options);
			}, {});
		};

		var deepmerge_1 = deepmerge;

		export default deepmerge_1;
	}
});
//# sourceMappingURL=es.js.map