Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/AllowedFragmentSelector", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', 'frontend-js-components-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../store/index', './AllowedFragmentTreeNode'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.AllowedFragmentSelector = void 0;

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _frontendJsComponentsWeb = require("frontend-js-components-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _index = require("../store/index");

    var _AllowedFragmentTreeNode = _interopRequireDefault(require("./AllowedFragmentTreeNode"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var toFragmentEntryKeysArray = function toFragmentEntryKeysArray(collections) {
      var fragmentEntryKeysArray = [];
      collections.forEach(function (collection) {
        collection.fragmentEntries.forEach(function (fragmentEntry) {
          return fragmentEntryKeysArray.push(fragmentEntry.fragmentEntryKey);
        });
        fragmentEntryKeysArray.push(collection.fragmentCollectionId);
      });
      fragmentEntryKeysArray.push('lfr-all-fragments-id');
      return fragmentEntryKeysArray;
    };

    var toNodes = function toNodes(collections) {
      return [{
        children: collections.filter(function (collection) {
          return collection.fragmentCollectionId !== 'layout-elements';
        }).map(function (collection) {
          var children = collection.fragmentEntries.filter(function (fragmentEntry) {
            return fragmentEntry.fragmentEntryKey && fragmentEntry.name;
          }).map(function (fragmentEntry) {
            return {
              id: fragmentEntry.fragmentEntryKey,
              name: fragmentEntry.name
            };
          });
          return {
            children: children,
            expanded: false,
            id: collection.fragmentCollectionId,
            name: collection.name
          };
        }),
        expanded: true,
        id: 'lfr-all-fragments-id',
        name: Liferay.Language.get('all-fragments')
      }];
    };

    var getSelectedNodeIds = function getSelectedNodeIds(allowNewFragmentEntries) {
      var fragmentEntryKeys = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      var fragmentEntryKeysArray = arguments.length > 2 ? arguments[2] : undefined;
      return allowNewFragmentEntries ? fragmentEntryKeysArray.filter(function (fragmentEntryKey) {
        return !fragmentEntryKeys.includes(fragmentEntryKey);
      }) : fragmentEntryKeys;
    };

    var AllowedFragmentSelector = function AllowedFragmentSelector(_ref) {
      var dropZoneConfig = _ref.dropZoneConfig,
          onSelectedFragment = _ref.onSelectedFragment;
      var fragments = (0, _index.useSelector)(function (state) {
        return state.fragments;
      });
      var fragmentEntryKeysArray = (0, _react.useMemo)(function () {
        return toFragmentEntryKeysArray(fragments);
      }, [fragments]);
      var initialAllowNewFragmentEntries = dropZoneConfig.allowNewFragmentEntries == undefined ? true : dropZoneConfig.allowNewFragmentEntries;
      var initialFragmentEntryKeys = dropZoneConfig.fragmentEntryKeys || [];

      var _useState = (0, _react.useState)(''),
          _useState2 = _slicedToArray(_useState, 2),
          filter = _useState2[0],
          setFilter = _useState2[1];

      var nodes = (0, _react.useMemo)(function () {
        return toNodes(fragments);
      }, [fragments]);

      var _useState3 = (0, _react.useState)(initialAllowNewFragmentEntries),
          _useState4 = _slicedToArray(_useState3, 2),
          allowNewFragmentEntries = _useState4[0],
          setAllowNewFragmentEntries = _useState4[1];

      var _useState5 = (0, _react.useState)(getSelectedNodeIds(allowNewFragmentEntries, initialFragmentEntryKeys, fragmentEntryKeysArray)),
          _useState6 = _slicedToArray(_useState5, 2),
          fragmentEntryKeys = _useState6[0],
          setFragmentEntryKeys = _useState6[1];

      (0, _react.useEffect)(function () {
        var newFragmentEntryKeys = getSelectedNodeIds(allowNewFragmentEntries, _toConsumableArray(fragmentEntryKeys), fragmentEntryKeysArray);
        onSelectedFragment({
          allowNewFragmentEntries: allowNewFragmentEntries,
          selectedFragments: newFragmentEntryKeys
        });
      }, [fragmentEntryKeys, allowNewFragmentEntries, fragmentEntryKeysArray, onSelectedFragment]);
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "px-4"
        }, /*#__PURE__*/_react.default.createElement(_form.ClayInput, {
          className: "mb-4",
          onChange: function onChange(event) {
            return setFilter(event.target.value);
          },
          placeholder: "".concat(Liferay.Language.get('search'), "..."),
          sizing: "sm",
          type: "text"
        }), /*#__PURE__*/_react.default.createElement("div", {
          className: "mb-2 page-editor__allowed-fragment__tree"
        }, /*#__PURE__*/_react.default.createElement(_frontendJsComponentsWeb.Treeview, {
          NodeComponent: _AllowedFragmentTreeNode.default,
          filterQuery: filter,
          inheritSelection: true,
          initialSelectedNodeIds: _toConsumableArray(fragmentEntryKeys),
          nodes: nodes,
          onSelectedNodesChange: setFragmentEntryKeys
        }))), /*#__PURE__*/_react.default.createElement("div", {
          className: "page-editor__allowed-fragment__new-fragments-checkbox"
        }, /*#__PURE__*/_react.default.createElement(_form.ClayCheckbox, {
          "aria-label": Liferay.Language.get('select-new-fragments-automatically'),
          checked: allowNewFragmentEntries,
          label: Liferay.Language.get('select-new-fragments-automatically'),
          onChange: function onChange(event) {
            setAllowNewFragmentEntries(event.target.checked);
          }
        })))
      );
    };

    exports.AllowedFragmentSelector = AllowedFragmentSelector;
    var _default = AllowedFragmentSelector;
    exports.default = _default;
    //# sourceMappingURL=AllowedFragmentSelector.js.map
  }
});
//# sourceMappingURL=AllowedFragmentSelector.js.map