Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/CollectionItemContext", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../actions/index', '../services/FragmentService', '../services/InfoItemService', '../store/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.useGetFieldValue = exports.useToControlsId = exports.useFromControlsId = exports.useCollectionItemIndex = exports.useCollectionConfig = exports.useGetContent = exports.useRenderFragmentContent = exports.CollectionItemContextProvider = exports.CollectionItemContext = exports.INITIAL_STATE = void 0;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _index = require("../actions/index");

    var _FragmentService = _interopRequireDefault(require("../services/FragmentService"));

    var _InfoItemService = _interopRequireDefault(require("../services/InfoItemService"));

    var _index2 = require("../store/index");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var defaultFromControlsId = function defaultFromControlsId(itemId) {
      return itemId;
    };

    var defaultToControlsId = function defaultToControlsId(controlId) {
      return controlId;
    };

    var INITIAL_STATE = {
      collectionConfig: null,
      collectionItem: null,
      collectionItemIndex: null,
      fromControlsId: defaultFromControlsId,
      setCollectionItemContent: function setCollectionItemContent() {
        return null;
      },
      toControlsId: defaultToControlsId
    };
    exports.INITIAL_STATE = INITIAL_STATE;

    var CollectionItemContext = /*#__PURE__*/_react.default.createContext(INITIAL_STATE);

    exports.CollectionItemContext = CollectionItemContext;
    var CollectionItemContextProvider = CollectionItemContext.Provider;
    exports.CollectionItemContextProvider = CollectionItemContextProvider;

    var useFromControlsId = function useFromControlsId() {
      var context = (0, _react.useContext)(CollectionItemContext);
      return context.fromControlsId || defaultFromControlsId;
    };

    exports.useFromControlsId = useFromControlsId;

    var useCollectionItemIndex = function useCollectionItemIndex() {
      var context = (0, _react.useContext)(CollectionItemContext);
      return context.collectionItemIndex;
    };

    exports.useCollectionItemIndex = useCollectionItemIndex;

    var useToControlsId = function useToControlsId() {
      var context = (0, _react.useContext)(CollectionItemContext);
      return context.toControlsId || defaultToControlsId;
    };

    exports.useToControlsId = useToControlsId;

    var useCollectionConfig = function useCollectionConfig() {
      var context = (0, _react.useContext)(CollectionItemContext);
      return context.collectionConfig;
    };

    exports.useCollectionConfig = useCollectionConfig;

    var useGetContent = function useGetContent(fragmentEntryLink, segmentsExperienceId) {
      var context = (0, _react.useContext)(CollectionItemContext);
      var dispatch = (0, _index2.useDispatch)();

      var _ref = context.collectionItem || {},
          className = _ref.className,
          classPK = _ref.classPK;

      (0, _react.useEffect)(function () {
        if (context.collectionItemIndex != null) {
          _FragmentService.default.renderFragmentEntryLinkContent({
            collectionItemClassName: className,
            collectionItemClassPK: classPK,
            fragmentEntryLinkId: fragmentEntryLink.fragmentEntryLinkId,
            onNetworkStatus: dispatch,
            segmentsExperienceId: segmentsExperienceId
          }).then(function (_ref2) {
            var content = _ref2.content;
            dispatch((0, _index.updateFragmentEntryLinkContent)({
              collectionItemIndex: context.collectionItemIndex,
              content: content,
              fragmentEntryLinkId: fragmentEntryLink.fragmentEntryLinkId
            }));
          });
        }
      }, [className, classPK, context.collectionItemIndex, dispatch, fragmentEntryLink.fragmentEntryLinkId, segmentsExperienceId, fragmentEntryLink.editableValues]);

      if (context.collectionItemIndex != null) {
        var collectionContent = fragmentEntryLink.collectionContent || [];
        return collectionContent[context.collectionItemIndex] || fragmentEntryLink.content;
      }

      return fragmentEntryLink.content;
    };

    exports.useGetContent = useGetContent;

    var useGetFieldValue = function useGetFieldValue() {
      var _useContext = (0, _react.useContext)(CollectionItemContext),
          collectionItem = _useContext.collectionItem;

      var getFromServer = (0, _react.useCallback)(function (_ref3) {
        var classNameId = _ref3.classNameId,
            classPK = _ref3.classPK,
            fieldId = _ref3.fieldId,
            languageId = _ref3.languageId;
        return _InfoItemService.default.getInfoItemFieldValue({
          classNameId: classNameId,
          classPK: classPK,
          fieldId: fieldId,
          languageId: languageId,
          onNetworkStatus: function onNetworkStatus() {}
        }).then(function (response) {
          var _response$fieldValue = response.fieldValue,
              fieldValue = _response$fieldValue === void 0 ? '' : _response$fieldValue;
          return fieldValue;
        });
      }, []);
      var getFromCollectionItem = (0, _react.useCallback)(function (_ref4) {
        var collectionFieldId = _ref4.collectionFieldId;
        return collectionItem[collectionFieldId] !== null && collectionItem[collectionFieldId] !== undefined ? Promise.resolve(collectionItem[collectionFieldId]) : Promise.reject();
      }, [collectionItem]);

      if (collectionItem) {
        return getFromCollectionItem;
      } else {
        return getFromServer;
      }
    };

    exports.useGetFieldValue = useGetFieldValue;

    var useRenderFragmentContent = function useRenderFragmentContent() {
      var context = (0, _react.useContext)(CollectionItemContext);

      var _ref5 = context.collectionItem || {},
          className = _ref5.className,
          classPK = _ref5.classPK;

      return (0, _react.useCallback)(function (_ref6) {
        var fragmentEntryLinkId = _ref6.fragmentEntryLinkId,
            onNetworkStatus = _ref6.onNetworkStatus,
            segmentsExperienceId = _ref6.segmentsExperienceId;
        return _FragmentService.default.renderFragmentEntryLinkContent({
          collectionItemClassName: className,
          collectionItemClassPK: classPK,
          fragmentEntryLinkId: fragmentEntryLinkId,
          onNetworkStatus: onNetworkStatus,
          segmentsExperienceId: segmentsExperienceId
        }).then(function (_ref7) {
          var content = _ref7.content;
          return {
            collectionItemIndex: context.collectionItemIndex,
            content: content
          };
        });
      }, [className, classPK, context.collectionItemIndex]);
    };

    exports.useRenderFragmentContent = useRenderFragmentContent;
    //# sourceMappingURL=CollectionItemContext.js.map
  }
});
//# sourceMappingURL=CollectionItemContext.js.map