Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/Controls", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../actions/switchSidebarPanel', '../config/constants/itemActivationOrigins', '../config/constants/itemTypes', '../store/index', './CollectionItemContext'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.useSelectItem = exports.useIsHovered = exports.useIsActive = exports.useHoverItem = exports.useHoveredItemType = exports.useHoveredItemId = exports.useActiveItemType = exports.useActiveItemId = exports.useActivationOrigin = exports.reducer = exports.ControlsProvider = void 0;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _switchSidebarPanel = _interopRequireDefault(require("../actions/switchSidebarPanel"));

    var _itemActivationOrigins = require("../config/constants/itemActivationOrigins");

    var _itemTypes = require("../config/constants/itemTypes");

    var _index = require("../store/index");

    var _CollectionItemContext = require("./CollectionItemContext");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var ACTIVE_INITIAL_STATE = {
      activationOrigin: null,
      activeItemId: null,
      activeItemType: null
    };
    var HOVER_INITIAL_STATE = {
      hoveredItemId: null
    };
    var HOVER_ITEM = 'HOVER_ITEM';
    var SELECT_ITEM = 'SELECT_ITEM';

    var ActiveStateContext = /*#__PURE__*/_react.default.createContext(ACTIVE_INITIAL_STATE);

    var ActiveDispatchContext = /*#__PURE__*/_react.default.createContext(function () {});

    var HoverStateContext = /*#__PURE__*/_react.default.createContext(HOVER_INITIAL_STATE);

    var HoverDispatchContext = /*#__PURE__*/_react.default.createContext(function () {});

    var reducer = function reducer(state, action) {
      var itemId = action.itemId,
          itemType = action.itemType,
          origin = action.origin,
          type = action.type;
      var nextState = state;

      if (type === HOVER_ITEM && itemId !== nextState.hoveredItemId) {
        nextState = _objectSpread(_objectSpread({}, nextState), {}, {
          hoveredItemId: itemId,
          hoveredItemType: itemType
        });
      } else if (type === SELECT_ITEM && itemId !== nextState.activeItemId) {
        nextState = _objectSpread(_objectSpread({}, nextState), {}, {
          activationOrigin: origin,
          activeItemId: itemId,
          activeItemType: itemType
        });
      }

      return nextState;
    };

    exports.reducer = reducer;

    var ActiveProvider = function ActiveProvider(_ref) {
      var children = _ref.children,
          initialState = _ref.initialState;

      var _useReducer = (0, _react.useReducer)(reducer, initialState),
          _useReducer2 = _slicedToArray(_useReducer, 2),
          state = _useReducer2[0],
          dispatch = _useReducer2[1];

      return (/*#__PURE__*/_react.default.createElement(ActiveDispatchContext.Provider, {
          value: dispatch
        }, /*#__PURE__*/_react.default.createElement(ActiveStateContext.Provider, {
          value: state
        }, children))
      );
    };

    var HoverProvider = function HoverProvider(_ref2) {
      var children = _ref2.children,
          initialState = _ref2.initialState;

      var _useReducer3 = (0, _react.useReducer)(reducer, initialState),
          _useReducer4 = _slicedToArray(_useReducer3, 2),
          state = _useReducer4[0],
          dispatch = _useReducer4[1];

      return (/*#__PURE__*/_react.default.createElement(HoverDispatchContext.Provider, {
          value: dispatch
        }, /*#__PURE__*/_react.default.createElement(HoverStateContext.Provider, {
          value: state
        }, children))
      );
    };

    var ControlsProvider = function ControlsProvider(_ref3) {
      var _ref3$activeInitialSt = _ref3.activeInitialState,
          activeInitialState = _ref3$activeInitialSt === void 0 ? ACTIVE_INITIAL_STATE : _ref3$activeInitialSt,
          _ref3$hoverInitialSta = _ref3.hoverInitialState,
          hoverInitialState = _ref3$hoverInitialSta === void 0 ? HOVER_INITIAL_STATE : _ref3$hoverInitialSta,
          children = _ref3.children;
      return (/*#__PURE__*/_react.default.createElement(ActiveProvider, {
          initialState: activeInitialState
        }, /*#__PURE__*/_react.default.createElement(HoverProvider, {
          initialState: hoverInitialState
        }, children))
      );
    };

    exports.ControlsProvider = ControlsProvider;

    var useActivationOrigin = function useActivationOrigin() {
      return (0, _react.useContext)(ActiveStateContext).activationOrigin;
    };

    exports.useActivationOrigin = useActivationOrigin;

    var useActiveItemId = function useActiveItemId() {
      return (0, _CollectionItemContext.useFromControlsId)()((0, _react.useContext)(ActiveStateContext).activeItemId);
    };

    exports.useActiveItemId = useActiveItemId;

    var useActiveItemType = function useActiveItemType() {
      return (0, _react.useContext)(ActiveStateContext).activeItemType;
    };

    exports.useActiveItemType = useActiveItemType;

    var useHoveredItemId = function useHoveredItemId() {
      return (0, _CollectionItemContext.useFromControlsId)()((0, _react.useContext)(HoverStateContext).hoveredItemId);
    };

    exports.useHoveredItemId = useHoveredItemId;

    var useHoveredItemType = function useHoveredItemType() {
      return (0, _react.useContext)(HoverStateContext).hoveredItemType;
    };

    exports.useHoveredItemType = useHoveredItemType;

    var useHoverItem = function useHoverItem() {
      var dispatch = (0, _react.useContext)(HoverDispatchContext);
      var toControlsId = (0, _CollectionItemContext.useToControlsId)();
      return (0, _react.useCallback)(function (itemId) {
        var _ref4 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
          itemType: _itemTypes.ITEM_TYPES.layoutDataItem
        },
            _ref4$itemType = _ref4.itemType,
            itemType = _ref4$itemType === void 0 ? _itemTypes.ITEM_TYPES.layoutDataItem : _ref4$itemType;

        return dispatch({
          itemId: toControlsId(itemId),
          itemType: itemType,
          type: HOVER_ITEM
        });
      }, [dispatch, toControlsId]);
    };

    exports.useHoverItem = useHoverItem;

    var useIsActive = function useIsActive() {
      var _useContext = (0, _react.useContext)(ActiveStateContext),
          activeItemId = _useContext.activeItemId;

      var toControlsId = (0, _CollectionItemContext.useToControlsId)();
      return (0, _react.useCallback)(function (itemId) {
        return activeItemId === toControlsId(itemId);
      }, [activeItemId, toControlsId]);
    };

    exports.useIsActive = useIsActive;

    var useIsHovered = function useIsHovered() {
      var _useContext2 = (0, _react.useContext)(HoverStateContext),
          hoveredItemId = _useContext2.hoveredItemId;

      var toControlsId = (0, _CollectionItemContext.useToControlsId)();
      return (0, _react.useCallback)(function (itemId) {
        return hoveredItemId === toControlsId(itemId);
      }, [hoveredItemId, toControlsId]);
    };

    exports.useIsHovered = useIsHovered;

    var useSelectItem = function useSelectItem() {
      var activeDispatch = (0, _react.useContext)(ActiveDispatchContext);
      var sidebarPanelId = (0, _index.useSelector)(function (state) {
        var _state$sidebar, _state$sidebar2;

        return ((_state$sidebar = state.sidebar) === null || _state$sidebar === void 0 ? void 0 : _state$sidebar.open) ? (_state$sidebar2 = state.sidebar) === null || _state$sidebar2 === void 0 ? void 0 : _state$sidebar2.panelId : null;
      });
      var storeDispatch = (0, _index.useDispatch)();
      var toControlsId = (0, _CollectionItemContext.useToControlsId)();
      return (0, _react.useCallback)(function (itemId) {
        var _ref5 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
          itemType: _itemTypes.ITEM_TYPES.layoutDataItem
        },
            _ref5$itemType = _ref5.itemType,
            itemType = _ref5$itemType === void 0 ? _itemTypes.ITEM_TYPES.layoutDataItem : _ref5$itemType,
            _ref5$origin = _ref5.origin,
            origin = _ref5$origin === void 0 ? _itemActivationOrigins.ITEM_ACTIVATION_ORIGINS.pageEditor : _ref5$origin;

        activeDispatch({
          itemId: toControlsId(itemId),
          itemType: itemType,
          origin: origin,
          type: SELECT_ITEM
        });

        if (itemId && !['page-structure', 'comments'].includes(sidebarPanelId)) {
          storeDispatch((0, _switchSidebarPanel.default)({
            sidebarOpen: true,
            sidebarPanelId: 'page-structure'
          }));
        }
      }, [activeDispatch, sidebarPanelId, storeDispatch, toControlsId]);
    };

    exports.useSelectItem = useSelectItem;
    //# sourceMappingURL=Controls.js.map
  }
});
//# sourceMappingURL=Controls.js.map