Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/LayoutViewport", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../../core/debounceRAF', '../config/constants/viewportSizes', '../config/index', '../store/index', './Controls', './DisabledArea', './GlobalContext', './Layout', './MasterLayout'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = LayoutViewport;

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _debounceRAF = _interopRequireDefault(require("../../core/debounceRAF"));

    var _viewportSizes = require("../config/constants/viewportSizes");

    var _index = require("../config/index");

    var _index2 = require("../store/index");

    var _Controls = require("./Controls");

    var _DisabledArea = _interopRequireDefault(require("./DisabledArea"));

    var _GlobalContext = _interopRequireDefault(require("./GlobalContext"));

    var _Layout = _interopRequireDefault(require("./Layout"));

    var _MasterLayout = _interopRequireDefault(require("./MasterLayout"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function LayoutViewport() {
      var handleRef = (0, _react.useRef)();

      var _useState = (0, _react.useState)(null),
          _useState2 = _slicedToArray(_useState, 2),
          element = _useState2[0],
          setElement = _useState2[1];

      var _useState3 = (0, _react.useState)(),
          _useState4 = _slicedToArray(_useState3, 2),
          layoutWidth = _useState4[0],
          setLayoutWidth = _useState4[1];

      var _useState5 = (0, _react.useState)(false),
          _useState6 = _slicedToArray(_useState5, 2),
          resizing = _useState6[0],
          setResizing = _useState6[1];

      var selectItem = (0, _Controls.useSelectItem)();
      var mainItemId = (0, _index2.useSelector)(function (state) {
        return state.layoutData.rootItems.main;
      });
      var masterLayoutData = (0, _index2.useSelector)(function (state) {
        var _state$masterLayout;

        return (_state$masterLayout = state.masterLayout) === null || _state$masterLayout === void 0 ? void 0 : _state$masterLayout.masterLayoutData;
      });
      var selectedViewportSize = (0, _index2.useSelector)(function (state) {
        return state.selectedViewportSize;
      });
      var sidebarOpen = (0, _index2.useSelector)(function (state) {
        return state.sidebar.panelId && state.sidebar.open;
      });
      (0, _react.useEffect)(function () {
        var handleViewport = handleRef.current;
        var initialWidth = 0;
        var initialX = 0;
        setLayoutWidth(undefined);
        var onDrag = (0, _debounceRAF.default)(function (event) {
          var _config$availableView = _index.config.availableViewportSizes[selectedViewportSize],
              maxWidth = _config$availableView.maxWidth,
              minWidth = _config$availableView.minWidth;
          setLayoutWidth(Math.min(Math.max(initialWidth + (event.clientX - initialX) * 2, minWidth), maxWidth + 1));
        });

        var stopDrag = function stopDrag() {
          setResizing(false);
          document.removeEventListener('mousemove', onDrag, true);
          document.removeEventListener('mouseup', stopDrag);
        };

        var initDrag = function initDrag(event) {
          if (element) {
            setResizing(true);
            selectItem(null);
            event.preventDefault();
            initialX = event.clientX;
            initialWidth = element.getBoundingClientRect().width - (parseInt(getComputedStyle(element).paddingRight, 10) || 0);
            setLayoutWidth(initialWidth);
            document.addEventListener('mousemove', onDrag, true);
            document.addEventListener('mouseup', stopDrag);
          }
        };

        if (handleViewport) {
          handleViewport.addEventListener('mousedown', initDrag, true);
        }

        return function () {
          if (handleViewport) {
            handleViewport.removeEventListener('mousedown', initDrag, true);
          }
        };
      }, [element, selectItem, selectedViewportSize]);
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)('page-editor__layout-viewport', "page-editor__layout-viewport--size-".concat(selectedViewportSize), {
            'page-editor__layout-viewport__resizing': resizing,
            'page-editor__layout-viewport--with-sidebar-open': sidebarOpen
          })
        }, resizing && /*#__PURE__*/_react.default.createElement("div", {
          className: "page-editor__layout-viewport__label-width"
        }, /*#__PURE__*/_react.default.createElement("span", null, layoutWidth, "px")), /*#__PURE__*/_react.default.createElement("div", {
          className: "page-editor__layout-viewport__resizer",
          ref: setElement,
          style: {
            width: layoutWidth
          }
        }, /*#__PURE__*/_react.default.createElement(_GlobalContext.default, {
          useIframe: selectedViewportSize !== _viewportSizes.VIEWPORT_SIZES.desktop
        }, /*#__PURE__*/_react.default.createElement(_DisabledArea.default, null), masterLayoutData ? /*#__PURE__*/_react.default.createElement(_MasterLayout.default, null) : /*#__PURE__*/_react.default.createElement(_Layout.default, {
          mainItemId: mainItemId
        }))), selectedViewportSize !== _viewportSizes.VIEWPORT_SIZES.desktop && /*#__PURE__*/_react.default.createElement("div", {
          className: "page-editor__layout-viewport__handle",
          ref: handleRef
        }))
      );
    }
    //# sourceMappingURL=LayoutViewport.js.map
  }
});
//# sourceMappingURL=LayoutViewport.js.map