Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/MasterLayout", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-dom', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../prop-types/index', '../config/constants/layoutDataItemTypes', '../store/index', './Controls', './Layout', './fragment-content/FragmentContent', './layout-data-items/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = MasterPage;

    var _metalDom = require("frontend-js-metal-web$metal-dom");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _index = require("../../prop-types/index");

    var _layoutDataItemTypes = require("../config/constants/layoutDataItemTypes");

    var _index2 = require("../store/index");

    var _Controls = require("./Controls");

    var _Layout = _interopRequireDefault(require("./Layout"));

    var _FragmentContent = _interopRequireDefault(require("./fragment-content/FragmentContent"));

    var _index3 = require("./layout-data-items/index");

    var _LAYOUT_DATA_ITEMS;

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var LAYOUT_DATA_ITEMS = (_LAYOUT_DATA_ITEMS = {}, _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection, _index3.Collection), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collectionItem, CollectionItem), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.column, _index3.Column), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container, _index3.Container), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone, DropZoneContainer), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment, Fragment), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragmentDropZone, Root), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.root, Root), _defineProperty(_LAYOUT_DATA_ITEMS, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, _index3.Row), _LAYOUT_DATA_ITEMS);

    function MasterPage() {
      var fragmentEntryLinks = (0, _index2.useSelector)(function (state) {
        return state.fragmentEntryLinks;
      });
      var masterLayoutData = (0, _index2.useSelector)(function (state) {
        var _state$masterLayout;

        return (_state$masterLayout = state.masterLayout) === null || _state$masterLayout === void 0 ? void 0 : _state$masterLayout.masterLayoutData;
      });
      var mainItem = masterLayoutData.items[masterLayoutData.rootItems.main];
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "master-page"
        }, /*#__PURE__*/_react.default.createElement(MasterLayoutDataItem, {
          fragmentEntryLinks: fragmentEntryLinks,
          item: mainItem,
          layoutData: masterLayoutData
        }))
      );
    }

    function MasterLayoutDataItem(_ref) {
      var fragmentEntryLinks = _ref.fragmentEntryLinks,
          item = _ref.item,
          layoutData = _ref.layoutData;
      var Component = LAYOUT_DATA_ITEMS[item.type];

      if (!Component) {
        return null;
      }

      return (/*#__PURE__*/_react.default.createElement(Component, {
          fragmentEntryLinks: fragmentEntryLinks,
          item: item,
          layoutData: layoutData
        }, item.children.map(function (childId) {
          return (/*#__PURE__*/_react.default.createElement(MasterLayoutDataItem, {
              fragmentEntryLinks: fragmentEntryLinks,
              item: layoutData.items[childId],
              key: childId,
              layoutData: layoutData
            })
          );
        }))
      );
    }

    function DropZoneContainer() {
      var mainItemId = (0, _index2.useSelector)(function (state) {
        return state.layoutData.rootItems.main;
      });
      return (/*#__PURE__*/_react.default.createElement(_Layout.default, {
          mainItemId: mainItemId,
          withinMasterPage: true
        })
      );
    }

    function Root(_ref2) {
      var children = _ref2.children;
      return (/*#__PURE__*/_react.default.createElement("div", null, children)
      );
    }

    function CollectionItem(_ref3) {
      var children = _ref3.children;
      return (/*#__PURE__*/_react.default.createElement("div", null, children)
      );
    }

    function Fragment(_ref4) {
      var item = _ref4.item;
      var ref = (0, _react.useRef)(null);
      var selectItem = (0, _Controls.useSelectItem)();
      (0, _react.useEffect)(function () {
        var element = ref.current;

        if (!element) {
          return;
        }

        var handler = function handler(event) {
          var element = event.target;

          if ((0, _metalDom.closest)(element, '[href]')) {
            event.preventDefault();
          }

          if (!(0, _metalDom.closest)(event.target, '.page-editor')) {
            selectItem(null);
          }
        };

        element.addEventListener('click', handler);
        return function () {
          element.removeEventListener('click', handler);
        };
      });
      var fragmentEntryLinks = (0, _index2.useSelector)(function (state) {
        return state.fragmentEntryLinks;
      });
      var masterLayoutData = (0, _index2.useSelector)(function (state) {
        var _state$masterLayout2;

        return (_state$masterLayout2 = state.masterLayout) === null || _state$masterLayout2 === void 0 ? void 0 : _state$masterLayout2.masterLayoutData;
      });
      var getPortals = (0, _react.useCallback)(function (element) {
        return Array.from(element.querySelectorAll('lfr-drop-zone')).map(function (dropZoneElement) {
          var mainItemId = dropZoneElement.getAttribute('uuid') || '';

          var Component = function Component() {
            return mainItemId ? /*#__PURE__*/_react.default.createElement(MasterLayoutDataItem, {
              fragmentEntryLinks: fragmentEntryLinks,
              item: masterLayoutData.items[mainItemId],
              layoutData: masterLayoutData
            }) : null;
          };

          Component.displayName = "DropZone(".concat(mainItemId, ")");
          return {
            Component: Component,
            element: dropZoneElement
          };
        });
      }, [fragmentEntryLinks, masterLayoutData]);
      return (/*#__PURE__*/_react.default.createElement(_FragmentContent.default, {
          className: "page-editor__fragment-content--master",
          elementRef: ref,
          fragmentEntryLinkId: item.config.fragmentEntryLinkId,
          getPortals: getPortals,
          item: item
        })
      );
    }
    //# sourceMappingURL=MasterLayout.js.map
  }
});
//# sourceMappingURL=MasterLayout.js.map