Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/Topper", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../prop-types/index', '../actions/index', '../config/constants/layoutDataItemTypes', '../config/index', '../selectors/selectCanUpdateItemConfiguration', '../selectors/selectCanUpdatePageStructure', '../store/index', '../thunks/moveItem', '../utils/dragAndDrop/constants/targetPosition', '../utils/dragAndDrop/useDragAndDrop', '../utils/getLayoutDataItemLabel', './Controls', './ItemActions'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = Topper;

    var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _index = require("../../prop-types/index");

    var _index2 = require("../actions/index");

    var _layoutDataItemTypes = require("../config/constants/layoutDataItemTypes");

    var _index3 = require("../config/index");

    var _selectCanUpdateItemConfiguration = _interopRequireDefault(require("../selectors/selectCanUpdateItemConfiguration"));

    var _selectCanUpdatePageStructure = _interopRequireDefault(require("../selectors/selectCanUpdatePageStructure"));

    var _index4 = require("../store/index");

    var _moveItem = _interopRequireDefault(require("../thunks/moveItem"));

    var _targetPosition = require("../utils/dragAndDrop/constants/targetPosition");

    var _useDragAndDrop = require("../utils/dragAndDrop/useDragAndDrop");

    var _getLayoutDataItemLabel = _interopRequireDefault(require("../utils/getLayoutDataItemLabel"));

    var _Controls = require("./Controls");

    var _ItemActions = _interopRequireDefault(require("./ItemActions"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    var TOPPER_BAR_HEIGHT = 24;

    var itemIsMappedCollection = function itemIsMappedCollection(item) {
      return item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection && 'collection' in item.config;
    };

    var TopperListItem = /*#__PURE__*/_react.default.forwardRef(function (_ref, ref) {
      var children = _ref.children,
          className = _ref.className,
          expand = _ref.expand,
          props = _objectWithoutProperties(_ref, ["children", "className", "expand"]);

      return (/*#__PURE__*/_react.default.createElement("li", _extends({}, props, {
          className: (0, _classnames.default)('page-editor__topper__item', 'tbar-item', {
            'tbar-item-expand': expand
          }, className),
          ref: ref
        }), children)
      );
    });

    TopperListItem.displayName = 'TopperListItem';
    TopperListItem.propTypes = {
      expand: _propTypes.default.bool
    };

    var MemoizedTopperContent = /*#__PURE__*/_react.default.memo(TopperContent);

    function Topper(_ref2) {
      var children = _ref2.children,
          item = _ref2.item,
          props = _objectWithoutProperties(_ref2, ["children", "item"]);

      var canUpdatePageStructure = (0, _index4.useSelector)(_selectCanUpdatePageStructure.default);
      var canUpdateItemConfiguration = (0, _index4.useSelector)(_selectCanUpdateItemConfiguration.default);
      var isHovered = (0, _Controls.useIsHovered)();
      var isActive = (0, _Controls.useIsActive)();

      if (canUpdatePageStructure || canUpdateItemConfiguration) {
        return (/*#__PURE__*/_react.default.createElement(MemoizedTopperContent, _extends({
            isActive: isActive(item.itemId),
            isHovered: isHovered(item.itemId),
            item: item
          }, props), children)
        );
      }

      return children;
    }

    function TopperContent(_ref3) {
      var _config$sidebarPanels, _config$sidebarPanels2;

      var children = _ref3.children,
          className = _ref3.className,
          isActive = _ref3.isActive,
          isHovered = _ref3.isHovered,
          item = _ref3.item,
          itemElement = _ref3.itemElement,
          style = _ref3.style;
      var canUpdatePageStructure = (0, _index4.useSelector)(_selectCanUpdatePageStructure.default);
      var dispatch = (0, _index4.useDispatch)();
      var segmentsExperienceId = (0, _index4.useSelector)(function (state) {
        return state.segmentsExperienceId;
      });
      var hoverItem = (0, _Controls.useHoverItem)();
      var fragmentEntryLinks = (0, _index4.useSelector)(function (state) {
        return state.fragmentEntryLinks;
      });
      var selectItem = (0, _Controls.useSelectItem)();

      var _useDropTarget = (0, _useDragAndDrop.useDropTarget)(item),
          canDropOverTarget = _useDropTarget.canDropOverTarget,
          isOverTarget = _useDropTarget.isOverTarget,
          sourceItem = _useDropTarget.sourceItem,
          targetPosition = _useDropTarget.targetPosition,
          targetRef = _useDropTarget.targetRef;

      var _useDragItem = (0, _useDragAndDrop.useDragItem)(item, function (parentItemId, position) {
        return dispatch((0, _moveItem.default)({
          itemId: item.itemId,
          parentItemId: parentItemId,
          position: position,
          segmentsExperienceId: segmentsExperienceId
        }));
      }),
          handlerRef = _useDragItem.handlerRef,
          isDraggingSource = _useDragItem.isDraggingSource;

      var commentsPanelId = (_config$sidebarPanels = _index3.config.sidebarPanels) === null || _config$sidebarPanels === void 0 ? void 0 : (_config$sidebarPanels2 = _config$sidebarPanels.comments) === null || _config$sidebarPanels2 === void 0 ? void 0 : _config$sidebarPanels2.sidebarPanelId;
      var notDroppableMessage = isOverTarget && !canDropOverTarget ? Liferay.Util.sub(Liferay.Language.get('a-x-cannot-be-dropped-inside-a-x'), [(0, _getLayoutDataItemLabel.default)(sourceItem, fragmentEntryLinks), (0, _getLayoutDataItemLabel.default)(item, fragmentEntryLinks)]) : null;
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)(className, 'page-editor__topper', {
            active: isActive,
            'drag-over-bottom': isOverTarget && targetPosition === _targetPosition.TARGET_POSITION.BOTTOM,
            'drag-over-middle': isOverTarget && targetPosition === _targetPosition.TARGET_POSITION.MIDDLE,
            'drag-over-top': isOverTarget && targetPosition === _targetPosition.TARGET_POSITION.TOP,
            dragged: isDraggingSource,
            hovered: isHovered,
            'not-droppable': !!notDroppableMessage,
            'page-editor__topper--mapped': itemIsMappedCollection(item)
          }),
          onClick: function onClick(event) {
            event.stopPropagation();

            if (isDraggingSource) {
              return;
            }

            selectItem(item.itemId);
          },
          onMouseLeave: function onMouseLeave(event) {
            event.stopPropagation();

            if (isDraggingSource) {
              return;
            }

            if (isHovered) {
              hoverItem(null);
            }
          },
          onMouseOver: function onMouseOver(event) {
            event.stopPropagation();

            if (isDraggingSource) {
              return;
            }

            hoverItem(item.itemId);
          },
          style: style
        }, /*#__PURE__*/_react.default.createElement(TopperLabel, {
          isActive: isActive,
          item: item,
          itemElement: itemElement
        }, /*#__PURE__*/_react.default.createElement("ul", {
          className: "tbar-nav"
        }, canUpdatePageStructure && /*#__PURE__*/_react.default.createElement(TopperListItem, {
          className: "page-editor__topper__drag-handler",
          ref: handlerRef
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          className: "page-editor__topper__drag-icon page-editor__topper__icon",
          symbol: "drag"
        })), /*#__PURE__*/_react.default.createElement(TopperListItem, {
          className: "page-editor__topper__title",
          expand: true
        }, (0, _getLayoutDataItemLabel.default)(item, fragmentEntryLinks) || Liferay.Language.get('element')), item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment && /*#__PURE__*/_react.default.createElement(TopperListItem, null, /*#__PURE__*/_react.default.createElement(_button.default, {
          displayType: "unstyled",
          small: true,
          title: Liferay.Language.get('comments')
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          className: "page-editor__topper__icon",
          onClick: function onClick() {
            dispatch((0, _index2.switchSidebarPanel)({
              sidebarOpen: true,
              sidebarPanelId: commentsPanelId
            }));
          },
          symbol: "comments"
        }))), canUpdatePageStructure && /*#__PURE__*/_react.default.createElement(TopperListItem, null, /*#__PURE__*/_react.default.createElement(_ItemActions.default, {
          item: item
        })))), /*#__PURE__*/_react.default.createElement("div", {
          className: "page-editor__topper__content",
          ref: targetRef
        }, /*#__PURE__*/_react.default.createElement(TopperErrorBoundary, null, /*#__PURE__*/_react.default.cloneElement(children, {
          data: notDroppableMessage ? {
            'data-not-droppable-message': notDroppableMessage
          } : null,
          withinTopper: true
        }))))
      );
    }

    var TopperErrorBoundary = /*#__PURE__*/function (_React$Component) {
      _inherits(TopperErrorBoundary, _React$Component);

      _createClass(TopperErrorBoundary, null, [{
        key: "getDerivedStateFromError",
        value: function getDerivedStateFromError(error) {

          return {
            error: error
          };
        }
      }]);

      function TopperErrorBoundary(props) {
        var _this;

        _classCallCheck(this, TopperErrorBoundary);

        _this = _possibleConstructorReturn(this, _getPrototypeOf(TopperErrorBoundary).call(this, props));
        _this.state = {
          error: null
        };
        return _this;
      }

      _createClass(TopperErrorBoundary, [{
        key: "render",
        value: function render() {
          return this.state.error ? /*#__PURE__*/_react.default.createElement(_alert.default, {
            displayType: "danger",
            title: Liferay.Language.get('error')
          }, Liferay.Language.get('an-unexpected-error-occurred-while-rendering-this-item')) : this.props.children;
        }
      }]);

      return TopperErrorBoundary;
    }(_react.default.Component);

    function TopperLabel(_ref4) {
      var children = _ref4.children,
          isActive = _ref4.isActive,
          item = _ref4.item,
          itemElement = _ref4.itemElement;

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          isInset = _useState2[0],
          setIsInset = _useState2[1];

      var _useState3 = (0, _react.useState)(0),
          _useState4 = _slicedToArray(_useState3, 2),
          windowScrollPosition = _useState4[0],
          setWindowScrollPosition = _useState4[1];

      (0, _react.useEffect)(function () {
        if (isActive) {
          var handleWindowScroll = function handleWindowScroll() {
            setWindowScrollPosition(window.scrollY);
          };

          window.addEventListener('scroll', handleWindowScroll);
          return function () {
            window.removeEventListener('scroll', handleWindowScroll);
          };
        }
      }, [isActive]);
      (0, _react.useEffect)(function () {
        if (itemElement && isActive) {
          var _document$querySelect, _document$querySelect2;

          var itemTop = itemElement.getBoundingClientRect().top - TOPPER_BAR_HEIGHT;
          var controlMenuContainerHeight = (_document$querySelect = (_document$querySelect2 = document.querySelector('.control-menu-container')) === null || _document$querySelect2 === void 0 ? void 0 : _document$querySelect2.offsetHeight) !== null && _document$querySelect !== void 0 ? _document$querySelect : 0;

          if (itemTop < controlMenuContainerHeight) {
            setIsInset(true);
          } else {
            setIsInset(false);
          }
        }
      }, [isActive, itemElement, windowScrollPosition]);
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)('page-editor__topper__bar', 'tbar', {
            'page-editor__topper__bar--inset': isInset,
            'page-editor__topper__bar--mapped': itemIsMappedCollection(item)
          })
        }, children)
      );
    }
    //# sourceMappingURL=Topper.js.map
  }
});
//# sourceMappingURL=Topper.js.map