Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/Translation", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../actions/index', '../config/constants/backgroundImageFragmentEntryProcessor', '../config/constants/editableFragmentEntryProcessor', '../config/constants/translationStatusType'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = Translation;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _index = require("../actions/index");

    var _backgroundImageFragmentEntryProcessor = require("../config/constants/backgroundImageFragmentEntryProcessor");

    var _editableFragmentEntryProcessor = require("../config/constants/editableFragmentEntryProcessor");

    var _translationStatusType = require("../config/constants/translationStatusType");

    var _TRANSLATION_STATUS_L;

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    var getEditableValues = function getEditableValues(fragmentEntryLinks) {
      return Object.values(fragmentEntryLinks).filter(function (fragmentEntryLink) {
        return !fragmentEntryLink.masterLayout && fragmentEntryLink.editableValues;
      }).map(function (fragmentEntryLink) {
        return [].concat(_toConsumableArray(Object.values(fragmentEntryLink.editableValues[_editableFragmentEntryProcessor.EDITABLE_FRAGMENT_ENTRY_PROCESSOR] || {})), _toConsumableArray(Object.values(fragmentEntryLink.editableValues[_backgroundImageFragmentEntryProcessor.BACKGROUND_IMAGE_FRAGMENT_ENTRY_PROCESSOR] || {})));
      }).reduce(function (editableValuesA, editableValuesB) {
        return [].concat(_toConsumableArray(editableValuesA), _toConsumableArray(editableValuesB));
      }, []);
    };

    var isTranslated = function isTranslated(editableValue, languageId) {
      return editableValue[languageId];
    };

    var getTranslationStatus = function getTranslationStatus(_ref) {
      var editableValuesLength = _ref.editableValuesLength,
          isDefault = _ref.isDefault,
          translatedValuesLength = _ref.translatedValuesLength;

      if (isDefault) {
        return _translationStatusType.TRANSLATION_STATUS_TYPE.default;
      } else if (translatedValuesLength === 0) {
        return _translationStatusType.TRANSLATION_STATUS_TYPE.untranslated;
      } else if (translatedValuesLength < editableValuesLength) {
        return _translationStatusType.TRANSLATION_STATUS_TYPE.translating;
      } else if (translatedValuesLength === editableValuesLength) {
        return _translationStatusType.TRANSLATION_STATUS_TYPE.translated;
      }
    };

    var TRANSLATION_STATUS_LANGUAGE = (_TRANSLATION_STATUS_L = {}, _defineProperty(_TRANSLATION_STATUS_L, _translationStatusType.TRANSLATION_STATUS_TYPE.default, Liferay.Language.get('default')), _defineProperty(_TRANSLATION_STATUS_L, _translationStatusType.TRANSLATION_STATUS_TYPE.translated, Liferay.Language.get('translated')), _defineProperty(_TRANSLATION_STATUS_L, _translationStatusType.TRANSLATION_STATUS_TYPE.translating, Liferay.Language.get('translating')), _defineProperty(_TRANSLATION_STATUS_L, _translationStatusType.TRANSLATION_STATUS_TYPE.untranslated, Liferay.Language.get('not-translated')), _TRANSLATION_STATUS_L);

    var TranslationItem = function TranslationItem(_ref2) {
      var editableValuesLength = _ref2.editableValuesLength,
          isDefault = _ref2.isDefault,
          language = _ref2.language,
          languageIcon = _ref2.languageIcon,
          languageId = _ref2.languageId,
          languageLabel = _ref2.languageLabel,
          onClick = _ref2.onClick,
          translatedValuesLength = _ref2.translatedValuesLength;
      var status = getTranslationStatus({
        editableValuesLength: editableValuesLength,
        isDefault: isDefault,
        translatedValuesLength: translatedValuesLength
      });
      return (/*#__PURE__*/_react.default.createElement(_dropDown.default.Item, {
          onClick: onClick,
          symbolLeft: languageIcon
        }, languageId === language.languageId ? /*#__PURE__*/_react.default.createElement("strong", null, languageLabel) : /*#__PURE__*/_react.default.createElement("span", null, languageLabel), /*#__PURE__*/_react.default.createElement("span", {
          className: "dropdown-item-indicator-end page-editor__translation__label-wrapper"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)('page-editor__translation__label label', status)
        }, TRANSLATION_STATUS_LANGUAGE[status], _translationStatusType.TRANSLATION_STATUS_TYPE[status] === _translationStatusType.TRANSLATION_STATUS_TYPE.translating && " ".concat(translatedValuesLength, "/").concat(editableValuesLength))))
      );
    };

    function Translation(_ref3) {
      var availableLanguages = _ref3.availableLanguages,
          defaultLanguageId = _ref3.defaultLanguageId,
          dispatch = _ref3.dispatch,
          fragmentEntryLinks = _ref3.fragmentEntryLinks,
          languageId = _ref3.languageId,
          _ref3$showNotTranslat = _ref3.showNotTranslated,
          showNotTranslated = _ref3$showNotTranslat === void 0 ? true : _ref3$showNotTranslat;

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          active = _useState2[0],
          setActive = _useState2[1];

      var editableValues = (0, _react.useMemo)(function () {
        return getEditableValues(fragmentEntryLinks);
      }, [fragmentEntryLinks]);
      var languageValues = (0, _react.useMemo)(function () {
        var availableLanguagesMut = _objectSpread({}, availableLanguages);

        var defaultLanguage = availableLanguages[defaultLanguageId];
        delete availableLanguagesMut[defaultLanguageId];
        return Object.keys(_objectSpread(_defineProperty({}, defaultLanguageId, defaultLanguage), availableLanguagesMut)).filter(function (languageId) {
          return showNotTranslated || editableValues.filter(function (editableValue) {
            return isTranslated(editableValue, languageId) || languageId === defaultLanguageId;
          }).length > 0;
        }).map(function (languageId) {
          return {
            languageId: languageId,
            values: editableValues.filter(function (editableValue) {
              return isTranslated(editableValue, languageId);
            })
          };
        });
      }, [availableLanguages, defaultLanguageId, editableValues, showNotTranslated]);
      var _availableLanguages$l = availableLanguages[languageId],
          languageIcon = _availableLanguages$l.languageIcon,
          languageLabel = _availableLanguages$l.languageLabel;
      return (/*#__PURE__*/_react.default.createElement(_dropDown.default, {
          active: active,
          hasLeftSymbols: true,
          hasRightSymbols: true,
          menuElementAttrs: {
            className: 'page-editor__translation'
          },
          onActiveChange: setActive,
          trigger: /*#__PURE__*/_react.default.createElement(_button.default, {
            "aria-pressed": active,
            className: "btn-monospaced",
            displayType: "secondary",
            small: true
          }, /*#__PURE__*/_react.default.createElement(_icon.default, {
            symbol: languageIcon
          }), /*#__PURE__*/_react.default.createElement("span", {
            className: "sr-only"
          }, languageLabel))
        }, /*#__PURE__*/_react.default.createElement(_dropDown.default.ItemList, null, languageValues.map(function (language) {
          return (/*#__PURE__*/_react.default.createElement(TranslationItem, {
              editableValuesLength: editableValues.length,
              isDefault: language.languageId === defaultLanguageId,
              key: language.languageId,
              language: language,
              languageIcon: availableLanguages[language.languageId].languageIcon,
              languageId: languageId,
              languageLabel: availableLanguages[language.languageId].languageLabel,
              onClick: function onClick() {
                dispatch((0, _index.updateLanguageId)({
                  languageId: language.languageId
                }));
                setActive(false);
              },
              translatedValuesLength: language.values.length
            })
          );
        })))
      );
    }
    //# sourceMappingURL=Translation.js.map
  }
});
//# sourceMappingURL=Translation.js.map