Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/URLParser", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../actions/switchSidebarPanel', '../config/constants/highlightedCommentIdKey', '../store/index', './Controls'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = URLParser;

    var _react = require("frontend-js-react-web$react");

    var _switchSidebarPanel = _interopRequireDefault(require("../actions/switchSidebarPanel"));

    var _highlightedCommentIdKey = require("../config/constants/highlightedCommentIdKey");

    var _index = require("../store/index");

    var _Controls = require("./Controls");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function URLParser() {
      var fragmentEntryLinks = (0, _index.useSelector)(function (state) {
        return state.fragmentEntryLinks;
      });
      var layoutData = (0, _index.useSelector)(function (state) {
        return state.layoutData;
      });
      var dispatch = (0, _index.useDispatch)();
      var selectItem = (0, _Controls.useSelectItem)();
      var selectFragment = (0, _react.useCallback)(function (messageId) {
        var _ref = Object.values(fragmentEntryLinks).find(function (fragmentEntryLink) {
          return fragmentEntryLink.comments.find(function (comment) {
            return comment.commentId === messageId || comment.children.find(function (childComment) {
              return childComment.commentId === messageId;
            });
          });
        }) || {
          fragmentEntryLinkId: null
        },
            fragmentEntryLinkId = _ref.fragmentEntryLinkId;

        var _ref2 = Object.values(layoutData.items).find(function (item) {
          return item.config.fragmentEntryLinkId === fragmentEntryLinkId;
        }) || {
          itemId: null
        },
            itemId = _ref2.itemId;

        if (itemId) {
          selectItem(itemId);
          dispatch((0, _switchSidebarPanel.default)({
            sidebarOpen: true,
            sidebarPanelId: 'comments'
          }));
        }
      }, [dispatch, fragmentEntryLinks, layoutData.items, selectItem]);
      (0, _react.useEffect)(function () {
        var url = new URL(window.location.href);

        if (url.searchParams.has('messageId')) {
          window.sessionStorage.setItem(_highlightedCommentIdKey.HIGHLIGHTED_COMMENT_ID_KEY, url.searchParams.get('messageId'));
          selectFragment(url.searchParams.get('messageId'));
          url.searchParams.delete('messageId');
          var skipLoadPopstate;

          if (Liferay.SPA && Liferay.SPA.app) {
            skipLoadPopstate = Liferay.SPA.app.skipLoadPopstate;
            Liferay.SPA.app.skipLoadPopstate = true;
          }

          history.replaceState(null, document.head.title, url.href);
          requestAnimationFrame(function () {
            if (Liferay.SPA && Liferay.SPA.app && typeof skipLoadPopstate === 'boolean') {
              Liferay.SPA.app.skipLoadPopstate = skipLoadPopstate;
            }
          });
        }
      }, [selectFragment]);
      return null;
    }
    //# sourceMappingURL=URLParser.js.map
  }
});
//# sourceMappingURL=URLParser.js.map